/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: getfields.c,v 1.4 1998/04/28 11:46:38 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include "begemot.h"

unsigned long delim[8] = { 0x00000201, 0x00000001 };

# define DELIM(C) (delim[(unsigned char)(C) >> 5] & (1UL << ((C) & 0x1f)))
# define SETDL(C) (delim[(unsigned char)(C) >> 5] |= (1UL << ((C) & 0x1f)))

int
getfields(char *str, char **fields, int nfields)
{
	char **fp = fields;

	while(nfields-- > 0) {
		*fp++ = str;
		while(!DELIM(*str))
			str++;
		if(nfields == 0 || *str == '\0')
			break;
		*str++ = '\0';
	}
	if(nfields > 0)
		*fp = NULL;

	return fp - fields;
}

int
getmfields(char *str, char **fields, int nfields)
{
	char **fp = fields;

	while(nfields > 0) {
		while(*str != '\0' && DELIM(*str))
			str++;
		if(*str == '\0')
			break;
		*fp++ = str;
		if(--nfields == 0)
			break;
		while(!DELIM(*str))
			str++;
		if(*str == '\0')
			break;
		*str++ = '\0';
	}

	if(nfields > 0)
		*fp = NULL;

	return fp - fields;
}

char *
setfields(char *str)
{
	static char odelim[256];
	char *p;
	int i;

	p = odelim;
	for(i = 1; i < 256; i++)
		if(DELIM(i))
			*p++ = i;
	*p = '\0';

	for(i = 0; i < 8; i++)
		delim[i] = 0;
	while(*str) {
		SETDL(*str);
		str++;
	}
	SETDL(0);

	return odelim;
}

# ifdef TEST


int
main(int argc, char *argv[])
{
	char *str, *p;
	int i, n;
	char *fields[6];

	p = setfields(" \t");
	p = cstrd(p, strlen(p));
	free(p);
	for(i = 0; i < 8; i++)
		printf("%08lx%c", delim[i], (i==7)?'\n':' ');

	while((str = readline(stdin)) != NULL) {
		str[strlen(str)-1] = '\0';
		if(str[0] == '!') {
			p = setfields(str+1);
			p = cstrd(p, strlen(p));
			printf("old: %s\n", p);
			free(p);
			for(i = 0; i < 8; i++)
				printf("%08lx%c", delim[i], (i==7)?'\n':' ');
		} else {
# ifdef TESTM
			n = getmfields(str, fields, 6);
# else
			n = getfields(str, fields, 6);
# endif
			printf("n = %d\n", n);
			for(i = 0; i < n; i++)
				printf("%d: '%s'\n", i, fields[i]);
			if(n < 6 && fields[n] == NULL)
				printf("%d: NULL\n", n);
		}
		free(str);
	}

	return 0;
}

# endif
