'\"
'\" Copyright (c)1997 Begemot Computer Associates. All rights reserved.
'\" See the file COPYRIGHT for details of redistribution and use.
'\"
'\" $Id: cstrc.man,v 1.4 1997/12/01 10:04:40 hbb Exp $
'\"
.TH cstrc l "9 Oct 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
cstrc, cstrd \- convert between ANSI C-strings and strings
.SH SYNOPSIS
.LP
.B "# include <begemot.h>"
.LP
.BI "char * cstrc(char **" "pstr" ", char " "delim" ", size_t"
.BI "*" "plen" ");"
.LP
.BI "char * cstrd(const char *" "str" ", char " "delim" ", size_t"
.IB "len" ");"
.LP
.B "int cstrwarn;"
.SH DESCRIPTION
The
.B cstrc
function converts a string as specified in the ANSI C-standard to the usual internal
representation. All escape sequences are (hopefully) recognized. Setting
.B cstrwarn
to any non-zero value enables some warning messages, which are emitted via
.BR warn (l).
.I Pstr
is the address of a pointer to the string to be parsed.
.I Delim
is the character at which the parsing should stop. It should be
a single or a double quote character. Parsing stops also if a NUL character
is found. *
.I pstr
is left pointing to the terminating character. At entry to the function *
.I pstr
should point behind the initial delimiter.
*
.I plen
will hold the number of bytes in the output string. The string
will be NUL termninated, but note, that it may contain embedded NULs.
.P
.B Cstrd
prints a string with non-printable characters converted to escape sequences.
.I delim
is escaped in the output string (usually '\\'' or '"').
.P
The user is responsible the deallocate the memory returned by
.B cstrc
and
.BR cstrd .
Both functions call
.BR xalloc (l)
and
.BR xrealloc (l)
and therefor end in
.BR panic (l)
if not enough memory is available.
.SH "RETURN VALUE"
Both functions return allocated memory that must be freed by the caller. They may
never return NULL.
.SH "SEE ALSO"
.BR panic (l),
.BR xalloc (l),
.BR xrealloc (3b)
.SH BUGS
Certainly.
