/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: begemot.h,v 1.23 1999/10/27 18:44:05 hbb Exp $
 */

# ifndef begemot_h
# define begemot_h

# include <stdarg.h>
# include <sys/types.h>

/*
 * Tcl 8... defines panic. :-((((
 */
# ifdef panic
#  undef panic
# endif

# ifdef __cplusplus
extern "C" {
# endif

# if defined(__GNUC__)
#  if __GNUC__ >= 2 && __GNUC_MINOR__ >= 5
void panic(const char *, ...) __attribute__ ((noreturn, format(printf, 1, 2)));
void bug(const char *, ...) __attribute__ ((noreturn, format(printf, 1, 2)));
void warn(const char *, ...) __attribute__ ((format(printf, 1, 2)));
void error(const char *, ...) __attribute__ ((format(printf, 1, 2)));
void inform(const char *, ...) __attribute__ ((format(printf, 1, 2)));

void vpanic(const char *, va_list) __attribute__((noreturn));
void vbug(const char *, va_list) __attribute__((noreturn));

void verb(u_int, u_int, const char *, ...) __attribute__ ((format(printf, 3, 4)));
void verbc(u_int, u_int, const char *, ...) __attribute__ ((format(printf, 3, 4)));
void verbn(u_int, u_int, const char *, ...) __attribute__ ((format(printf, 3, 4)));

#  else

volatile void panic(const char *, ...);
volatile void bug(const char *, ...);
void warn(const char *, ...);
void error(const char *, ...);
void inform(const char *, ...);

volatile void vpanic(const char *, va_list);
volatile void vbug(const char *, va_list);

void verb(u_int, u_int, const char *, ...);
void verbc(u_int, u_int, const char *, ...);
void verbn(u_int, u_int, const char *, ...);

#  endif
# else

void panic(const char *, ...);
void bug(const char *, ...);
void warn(const char *, ...);
void error(const char *, ...);
void inform(const char *, ...);

void vpanic(const char *, va_list);
void vbug(const char *, va_list);

void verb(u_int, u_int, const char *, ...);
void verbc(u_int, u_int, const char *, ...);
void verbn(u_int, u_int, const char *, ...);

# endif

void vwarn(const char *, va_list);
void verror(const char *, va_list);
void vinform(const char *, va_list);

void vverb(u_int, u_int, const char *, va_list);
void vverbc(u_int, u_int, const char *, va_list);
void vverbn(u_int, u_int, const char *, va_list);

int geterrorcnt();
int getwarncnt();
void set_errmode(int);
void set_argv0(char *);

void * xalloc(size_t);
void * xrealloc(void *, size_t);
void xfree(void *);

char * strsave(const char *);
char * xstrsave(const char *);

size_t strnlen(const char *, size_t);
void strtrimsp(char **, int);
char * strnchr(const char *, int, size_t);

char * cstrc(char **, char, size_t *);
char * cstrd(char *, char, size_t);
extern int cstrwarn;

int getfields(char *, char **, int);
int getmfields(char *, char **, int);
char *setfields(char *);

/*
 * The following definitions require stdio.h to be included. Because we
 * don't want to require each program that uses libbegemot to include
 * stdio.h we make a heuristic check whether it's included or not.
 */
# ifdef EOF
struct stat;
void prstat(FILE *, const struct stat *);

char * readline(FILE *);
extern int readlinecnt;
# endif

struct iovec;

int frame_write(int, void *, u_int, void *, ...);
int frame_writev(int, void *, u_int, struct iovec *, u_int);
int frame_read(int, void *, u_int, void **, u_int *);
int framefd_write(int, void *, u_int, void *, ...);
int framefd_writev(int, void *, u_int, struct iovec *, u_int);
int framefd_read(int, void *, u_int, void **, u_int *);

typedef struct verb_option_t {
	char	*opt;
	u_int	level;
} verb_option_t;

enum {
	V_DFLT	= 0,
};

void verb_opts(verb_option_t *);

u_int verb_level(u_int);
void verb_option(char *);
# ifdef EOF
void verb_update(FILE *);
# endif

# ifdef __cplusplus
}
# endif
# endif
