/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: _common_err.c,v 1.5 1998/03/26 15:11:16 robf Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include <stdarg.h>
# include <string.h>
# include <time.h>
# include <unistd.h>
# include "begemot.h"
# include "private.h"


# define MODE	"BEGEMOT_ERR"

static int mode = -1;
static char *argv0;

void
set_errmode(int m)
{
	char *e;

	if((e = getenv(MODE)) != NULL)
		mode = strtol(e, NULL, 0);
	else
		mode = m;
	if(mode < 0)
		mode = -mode;
}

void
set_argv0(char *a)
{
	argv0 = a;
}

void
begemot_common_err(const char *prefix, const char *suffix, const char *fmt, va_list ap)
{
	time_t clock;
	char tbuf[100];
	struct tm *tm;

	if(mode == -1)
		set_errmode(0);
	if(mode) {
		time(&clock);
		tm = localtime(&clock);
		strftime(tbuf, sizeof(tbuf), "%H:%M:%S", tm);
		fprintf(stderr, "%s(%u)-%s%s%s: ",
			  (argv0 == NULL) ? ""
			: (mode == 1 && strrchr(argv0, '/') != NULL) ? (strrchr(argv0, '/') + 1)
			: argv0,
			(u_int)getpid(), tbuf, prefix ? "-" : "",
			prefix ? prefix : "");
	} else {
		fprintf(stderr, "%s: ", prefix);
	}
	vfprintf(stderr, fmt, ap);
	if(suffix)
		fprintf(stderr, suffix);
}
