/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

# include	<sys/types.h>
# include	<sys/stat.h>
# include	<stdio.h>
# include	<unistd.h>
# include	<stdlib.h>
# include	<stdarg.h>
# include	<fcntl.h>
# include	<errno.h>
# include	<string.h>

# include	"cproftab.c"

# ifdef	MPROF
#  define	PTABSIZE	4
#  define	MYNAME		"mprof"
# else
#  define	PTABSIZE	1
#  define	MYNAME		"cprof"
# endif MPROF

extern unsigned	instab[0200000][4];
unsigned	itimes[0200000][PTABSIZE];
unsigned	icalls[0200000];

unsigned	ptimes[NNAMES];
unsigned	pcalls[NNAMES];

void fatal( char *fmt, ... );
void cprof(void);
void cout(void);

static char	*progname;
static char	*myname = MYNAME;

main( int argc, char *argv[] )
{
	int	fd;
	char	*fname;
	struct stat sbuf;

	progname = argv[0];
	fname = argv[1];

	if( argc != 2 )
		fatal("Usage: %s file\n", myname);

	if( ( fd = open( fname, O_RDWR ) ) < 0 )
		fatal("Cannot open %s: %s\n", fname, strerror(errno) );

	if( fstat( fd, &sbuf ) < 0 )
		fatal("Cannot stat %s: %s\n", fname, strerror(errno));

	if( sbuf.st_size != (sizeof(itimes)+sizeof(icalls)) )
		fatal("%s has wrong size, probably not an %s file\n",
					fname, myname );

	if( read( fd, itimes, sizeof(itimes) ) != sizeof(itimes) )
		fatal("Error reading %s: %s\n", fname, strerror(errno));

	if( read( fd, icalls, sizeof(icalls) ) != sizeof(icalls) )
		fatal("Error reading %s: %s\n", fname, strerror(errno));

	cprof();
	cout();
}

void
cprof(void)
{
	int	i, j;

	for( i = 0 ; i < 0200000 ; i++ )
		for( j = 0 ; j < PTABSIZE ; j++ )
			if( itimes[i][j] ) {
				ptimes[instab[i][j]] += itimes[i][j];
				pcalls[instab[i][j]] += icalls[i];
			}
}

void
cout(void)
{
	int	i;

	for( i = 0 ; i < NNAMES ; i++ )
		if( pcalls[i] )
			printf("%s\t%10d%10d%10d\n",
				inames[i], pcalls[i], ptimes[i],
				pcalls[i] ? ptimes[i]/pcalls[i] : 0 );
}

void
fatal( char *fmt, ... )
{
	va_list	ap;

	va_start(ap, fmt);
	fprintf(stderr,"%s: ", progname);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	exit(1);
}
