#include <param.h>
#include <inode.h>
#include <file.h>
#include <fcntl.h>
#include <dir.h>
#include <signal.h>
#include <user.h>
#include <proc.h>
#include <lnode.h>
#include <retlim.h>
#include <errno.h>

extern struct lnode lnode[];
extern struct user u;

#define	LNSZ	(sizeof(struct lnode))

/*
 * limits system call
 *
 * Functions:
 *	L_MYLIM returns own limits structure
 *	L_OTHLIM returns limits structure of l_uid
 *	L_ALLLIM returns all active limits structures
 *	L_SETLIM initialises limits structure for l_uid
 *	L_DEADLIM wait for a dead child, and return limits struct. & proc entry
 *	L_CHNGLIM changes limits structure for l_uid
 */
limits()
{
	register struct a
	{
		struct lnode *lp;
		int select;
	} *uap;
	register struct lnode *lnp;
	register i;
	int uid;
	struct lnode dummy;	/* care - this is fairly large */

	uap = (struct a *)u.u_ap;
	switch(uap->select)
	{
	case L_MYLIM:
		if (copyout((caddr_t)u.u_procp->p_lnode, (caddr_t)uap->lp, LNSZ) < 0)
			u.u_error = EFAULT;
		u.u_r.r_r0 = 1;
		return;

	case L_OTHLIM:
		uid = fuword((caddr_t)&uap->lp->l_uid);
		for (lnp = lnode; lnp < &lnode[NLNODE]; lnp++)
			if (lnp->l_uid == uid && lnp->l_refcount)
			{
				if (copyout((caddr_t)lnp, (caddr_t)uap->lp, LNSZ) < 0)
					u.u_error = EFAULT;
				u.u_r.r_r0 = 1;
				return;
			}
		u.u_error = ESRCH;
		return;

	case L_ALLLIM:
		i = 0;
		for (lnp = lnode; lnp < &lnode[NLNODE]; lnp++)
			if (lnp->l_refcount)
			{
				if (copyout((caddr_t)lnp, (caddr_t)uap->lp, LNSZ) < 0)
				{
					u.u_error = EFAULT;
					return;
				}
				uap->lp++;
				i++;
			}
		u.u_r.r_r0 = i;
		return;

	case L_SETLIM:
		if (!suser())
			return;
		if ((uid = fuword((caddr_t)&uap->lp->l_uid)) == -1)
		{
			u.u_error = EFAULT;
			return;
		}
		if (uid == u.u_procp->p_lnode->l_uid)
			return;
		i = 0;
		for (lnp = lnode; lnp < &lnode[NLNODE]; lnp++)
		{
			if (lnp->l_refcount == 0)
			{
				if (i == 0)
					i = (int)lnp;
			}
			else if (lnp->l_uid == uid)
			{
				if (lnp->l_plimit && lnp->l_refcount == lnp->l_plimit)
				{
					u.u_error = EPLIM;
					return;
				}
				break;
			}
		}
		if (lnp == &lnode[NLNODE])	/* lnode not found */
		{
			if (i == 0)
			{
				u.u_error = ELOUT;
				return;
			}
			lnp = (struct lnode *)i;
			if (copyin((caddr_t)uap->lp, (caddr_t)lnp, LNSZ) < 0)
			{
				u.u_error = EFAULT;
				return;
			}
			lnp->l_refcount = 0;
			lnp->l_muse = 0;
		}
		/*
		 * lnp now points to the new lnode structure
		 */
		lnp->l_refcount++;
		lnp->l_muse += u.u_procp->p_size;
		i = (int)u.u_procp->p_lnode;
		u.u_procp->p_lnode = lnp;
		lnp = (struct lnode *)i;
		lnp->l_refcount--;
		if (lnp->l_refcount == 0)	/* impossible! */
			printf("Lnode refcnt 0 (uid %d)\n", lnp->l_uid);
		lnp->l_muse -= u.u_procp->p_size;
		u.u_r.r_r0 = 0;
		return;

	case L_DEADLIM:
		wait1(1);
		return;

	case L_CHNGLIM:
		if (!suser())
			return;
		lnp = &dummy;
		if (copyin((caddr_t)uap->lp, (caddr_t)lnp, LNSZ) < 0)
		{
			u.u_error = EFAULT;
			return;
		}
		if ((i = lnp->l_uid) == 0)
		{
			u.u_error = EINVAL;
			return;
		}
		for (lnp = lnode; lnp < &lnode[NLNODE]; lnp++)
			if (lnp->l_uid == i && lnp->l_refcount)
			{
				lnp->l_shares = dummy.l_shares;
				lnp->l_dlimit = dummy.l_dlimit;
				lnp->l_doverflw = dummy.l_doverflw;
				lnp->l_plimit = dummy.l_plimit;
				lnp->l_mlimit = dummy.l_mlimit;
				lnp->l_mplimit = dummy.l_mplimit;
				for (i = 0; i < CLASSMASKSIZE; i++)
					lnp->l_cmask[i] = dummy.l_cmask[i];
				lnp->l_flags |= dummy.l_flags;
				return;
			}
		u.u_error = ESRCH;
		return;

	default:
		u.u_error = EINVAL;
		return;
	}
}

retlimits(p)
register struct proc *p;
{
	register struct a
	{
		struct retlim *rp;
	} *uap;

	uap = (struct a *)u.u_ap;
	if (copyout((caddr_t)p, (caddr_t)&uap->rp->r_proc, sizeof(struct xproc)) < 0)
	{
		u.u_error = EFAULT;
		return;
	}
	if (copyout((caddr_t)p->p_lnode, (caddr_t)&uap->rp->r_lnode, LNSZ) < 0)
		u.u_error = EFAULT;
}

/*
 *	dlimit - check disk limits (return non-zero if hard limit reached
 */
dlimit(inc)
unsigned inc;
{
	register struct lnode *lnp;
	register unsigned dl;

	if (u.u_fmode & O_FREE)
		return(0);
	lnp = u.u_procp->p_lnode;
	lnp->l_duse += inc;
	if ((dl = lnp->l_dlimit) == 0)
		return(0);
	if (lnp->l_duse > dl)
	{
		if ((lnp->l_flags & DLIMIT) || lnp->l_duse >= (dl + lnp->l_doverflw))
		{
			if ((lnp->l_flags & DLIMIT) == 0)
			{
				lnp->l_flags |= DLIMIT;
				uprints("\n\007Hard disk limit reached\n");
			}
			lnp->l_duse -= inc;
			u.u_error = EDLIM;
			return(1);
		}
		lnp->l_flags |= DAWARN;
	}
	return(0);
}

/*
 *	dlimfree - decrement disk usage and clear flags
 */
dlimfree(dec, ip)
unsigned dec;
register struct inode *ip;
{
	register struct lnode *lnp;

	lnp = u.u_procp->p_lnode;
	if (ip->i_uid != lnp->l_uid || (ip->i_mode & IFMT) == IFIFO)
		return;
	if (dec > lnp->l_duse)
		dec = lnp->l_duse;
	if ((lnp->l_duse -= dec) <= lnp->l_dlimit)
		lnp->l_flags &= ~(DAWARN | DLIMIT);
}
