/*
 *	ianj sep 77
 *
 *	when invoked (only by super-user) will signal all
 *	processes with a SIGTERM this will cause
 *	system to shutdown - nicely. only processes not
 *	killed are 0,1,parent and self.  init will loop
 *	waiting for shells to terminate - no restart at all.
 *	parent (presumably shell) can do as wishes.  the
 *	parent can then kill off any remaining processes.
 *	when all shells are dead init will exit - leaving
 *	only process 0 active.
 */

#include	<local-system>
#include	<sys/param.h>
#include	<sys/proc.h>
#include	<signal.h>
#include	<sys/table.h>

struct proc proc[1];
struct table table;

char kmem[] = "/dev/kmem";

#ifdef	DEBUG
#define kill(pid, sig)	printf("kill(%u, %u)\n", pid, sig)
#endif

#define	INITPID	1


main()
{
	register i;
	register struct proc *p;
	register nzomb;
	int llimit = 10;
	int sig = SIGTRM;
	unsigned short pgrp,maxpid;
	int nproc;
	int mf;

	signal(SIGTRM, SIG_IGN);
	signal(SIGHUP, SIG_IGN);

	maxpid = INITPID;
	pgrp = getpgrp();	/* my process group */
	kill(INITPID, SIGTRM);	/* tell init about shutdown */
	if((mf = open(kmem, 0)) == SYSERROR)
	{
		perror(kmem);
		exit(1);
	}
	getaddr(PROC, &table);
	nproc = table.tb_num;
	lseek(mf, (long)table.tb_addr, 0);
	p = proc;


	/*
	 * scan proc array thrice
	 * kill -14 all but 0,1,pgrp first time thru
	 * on all but first pass only kill new processes (>maxpid)
	 */

	nzomb = -1;	/* force two loops */
	do
	{
		if(nzomb < 0)
		{
			nzomb = 1;
		}
		else
		{
			nice(20);
			nzomb = 0;
		}
		if(llimit == 2)
		{
			sig = SIGKIL;	/* make really sure */
			maxpid = INITPID;
		}
		if(llimit == 1)
			sleep(2);	/* let them die peacefully */
		i = INITPID;
		do
		{
			read(mf, p, sizeof(struct proc));
			if(p->p_stat == 0 || p->p_pgrp == pgrp)
				continue;
			nzomb++;
			if(p->p_stat == SZOMB)
				continue;
			if(p->p_pid <= maxpid)
				continue;
			kill(p->p_pid, sig);
			if(p->p_pid > i)
				i = p->p_pid;
		} while(--nproc);
		maxpid = i;
		if(nzomb) 
			lseek(mf, (long)table.tb_addr, 0);
	} while(nzomb && --llimit);
	execl("/bin/ps","ps","ax",0);
	perror("/bin/ps");
}
