/*
**	UNIX Shell
**
**	Piers Lauder
**	Sydney University
*/

#include	"defs.h"
#include	<local-system>
#ifdef	AUSAM
#include	<passwd.h>

STRUCT pwent	PWENT;
#else	AUSAM
#include	<pwd.h>

STRUCT passwd *	PWENT;
PWENT		getpwnam();
#endif	AUSAM



/*
**	match string passed with login name and return home directory
*/

STRING gethomedir(person)
	STRING		person;		/* ['%'|'@']person['/'|'\0'] */
{
	REG STRING	ps, pe;
	REG POS		l;
	LOCAL STRING	lastperson, lasthomedir;
	PROC BOOL	sameperson();

	/** Clip person **/

	IF *(ps=person) == '%' ORF *ps == '@' THEN ps++ FI
	FOR pe=ps, l=0 ; *pe != '\0' ANDF *pe != '/' ; pe++, l++ DONE

	/** Match person with lastperson **/

	IF lastperson != NIL ANDF sameperson(lastperson, ps, pe)
	THEN	return(lasthomedir == NIL ? person : lasthomedir);
	ELSE
		/** find person in password file **/

		PWENT	pw;
#		ifdef	AUSAM
		CHAR	sbuf[SSIZ];
#		endif	AUSAM

		IF lastperson != NIL THEN free(lastperson); FI
		lastperson=alloc(l+1);
		IF lasthomedir != NIL
		THEN	free(lasthomedir);
			lasthomedir = NIL;
		FI

		FOR pe=lastperson ; l-- ; *pe++ = *ps++ DONE
		*pe='\0';

#		ifdef	AUSAM
		pw.pw_strings[LNAME] = lastperson;
		IF getpwuid(&pw, sbuf, SSIZ) != PWERROR
		THEN	movstr(pw.pw_strings[DIRPATH], (lasthomedir=alloc(length(pw.pw_strings[DIRPATH]))));
			return(lasthomedir);
#		else	AUSAM
		IF (pw=getpwnam(lastperson)) != (PWENT)0
		THEN	movstr(pw->pw_dir, (lasthomedir=alloc((POS)length(pw->pw_dir))));
			return(lasthomedir);
#		endif	AUSAM
		ELSE	return(person);
		FI
	FI
}



LOCAL BOOL sameperson(p1, p2, p2e)
	REG STRING	p1, p2, p2e;
{
	WHILE p2 < p2e DO IF *p1++ != *p2++ THEN return(FALSE); FI OD
	return(*p1 == '\0');
}
