#include <stdio.h>
#include <sgtty.h>
#include <signal.h>
#include <fcntl.h>

#define BSIZE 512		/* size of max block */

char obuf[BSIZE + 12];		/* 12 byte header + tailer */
char *obufp;			/* where next char to go */
int ocount = 0;		/* count of char already output */

#define PLOTTER	"/dev/plotter"

#define BLOCKSTART	"\033A("
#define BLOCKEND	"\033A)"
#define PLOTON		"\033AE"
#define PLOTOFF		"\033AF"
#define PLOTSIZE	"\033AH"
#define ESC		'\033'
#define MASK		0177

struct sgttyb tty;	/* buffer for sgtty info */
int saved;
char reply[10];
int check;
int pfile;

main()
{

	register c;
	int endit();

#ifdef	SEPARATE_DEV
	if((pfile = open(PLOTTER, O_RDWR|O_EXCL)) == -1)
#else
	if((pfile = open(PLOTTER, O_RDWR)) == -1)
#endif
	{
		perror(PLOTTER);
		exit(1);
	}
	if(gtty(pfile, &tty) == -1)
	{
		perror(PLOTTER);
		exit(1);
	}

	if(signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, endit);
	saved = tty.sg_flags;
	tty.sg_flags = RAW + CRMOD;
	tty.sg_ospeed = tty.sg_ispeed = B1200;
	if(stty(pfile, &tty) == -1)
	{
		perror(PLOTTER);
		exit(1);
	}

	{
		char buf[20];
		char buf2[10];

		strcpy(buf, PLOTON);
		strcat(buf, PLOTSIZE);
		sprintf(buf2, "%d", BSIZE+6);	/* , is termination char */
		strcat(buf, buf2);
		write(pfile, buf, strlen(buf));
	}
	startblock();
	while((c = getchar()) != EOF)
	{
		if(c == ESC)
		{
			endblock();	/* finish current block */
			/* prompt on sequence "esc device 'K'" */
			out(c);
			c = getchar();
			out(c);
			c = getchar();
			out(c);

			if(c == 'K')	/* Prompt ON sequence */
			{
				endblock();
				read(pfile, reply, 9);
			}
		}
		else
			out(c);
		if(ocount == BSIZE)	/* buffer full */
			endblock();
	}
	endblock();	/* end last block */
	endit(0);
}

startblock()
{

	ocount = 0;
	obufp = obuf;
	sprintf(obuf, BLOCKSTART);
	skip();
	check = '(' + 'A' + 033 + ')';
}

endblock()
{

	sprintf(obufp, BLOCKEND);
	skip();
	sprintf(obufp, "%d", check);
	skip();
	*obufp++ = ',';		/* termination char */

	do {
		/* write block to plotter */
		if(write(pfile, obuf, obufp - obuf) != obufp - obuf)
		{
			perror(PLOTTER);
			endit(1);
		}
		/* read reply */
		read(pfile, reply, 3);
		reply[0] &= MASK;

		switch(reply[0])
		{
		case 'A':	/* ok */
		case 'I':	/* err */
			break;
		default:	/* who knows */
			endit(1);
		}
	} while (reply[0] == 'I');
	startblock();
}

out(c)
{

	*obufp++ = c;
	ocount++;
	check += c;

	if(check & 0170000)
		check = (check + 1) & 07777;
}

skip()
{
	while(*obufp)
		obufp++;
}

endit(sig)
{
	/* finish up turn plotter off */
	write(pfile, PLOTOFF, sizeof PLOTOFF - 1);
	tty.sg_flags = saved;
	stty(pfile, &tty);
	exit(sig);
}
