#include "draw.h"

jmp_buf env;

int levelmask;
float sscale = 40.0;
float gridscale = 20.0;

float xbottom, xtop;
float ybottom, ytop;

float xoffset = 0.0, yoffset = 0.0;

int line = 0;	/* current dine for commands */
struct symbol symtab[NSYMS];
unsigned nsyms = 0;
char iobuf[BUFSIZ];
char *tempname;

main()
{
	int catchit();
	char buf[BUFSZ];


	setbuf(stdout, iobuf);
	tempname = mktemp("drawXXXXXX");
	if((tempfile = fopen(tempname, "w+")) == NULL)
	{
		perror("tempname");
		exit(1);
	}
	init(stdout);
	syncs(0);
	erase();
	line = 0;

	/* set default page and char sizes */
	size("1");
	set("a4");
	levelmask = 1;

	/* setup position for commandline */
	home();
	alpha();
	fflush(stdout);
	oldline();

	/* return here on error */
	setjmp(env);

	signal(SIGINT, catchit);

	/* main command loop */
	for(;;)
	{
		newline();
		printf("\033AF> "); /* turn plotter of and prompt */
		fflush(stdout);
		buf[0] = 0;
		while(gets(buf) == NULL);
		oldline();
		if(buf[0])
			cmd(buf, 0);

	}
}

catchit()
{

	register i;
	register struct symbol *p;

	/* if we were editing a module wirte it out */
	for(i = 0;i < nsyms;i++)
	{
		if((p = &symtab[i])->def & EDIT)
		{
			p->def &= ~EDIT;
			writeout(p);
			break;
		}
	}
	warn("interrupted");
	longjmp(env, 0);
}

static linex, liney;
newline()
{
	smovea(linex, liney);
	alpha();
	fflush(stdout);
}

oldline()
{
	fflush(stdout);
	senq(&linex, &liney);
	smovea(linex, liney);
	alpha();
	fflush(stdout);
}
