;;;	/ p o p / u s r / l i b / p i c p l a y . p
;;;
;;;	Steven Hardy, 11th May 1977
;;;
;;;	This package provides facilities for examining 'grey level' pictures.
;;;	See the PICPLAY demo for more details.
;;;
Uses turtle;
Uses seepicture;
vars picturefile;
'/user3/EECF-Maint/pop/usr/lib/thinkpic.p' -> picturefile;
vars greypic;
picture -> greypic;
;;;
;;;	The following function returns the width and height of the
;;;	TURTLE picture.
function dimensions();
	hd(tl(fnprops(picture))), hd(tl(tl(tl(fnprops(picture)))));
end;
;;;	The following function shows the basic picture.
function basic();
	vars threshold, picture;
	0 -> threshold;
	'This is the basic picture' =>
	greypic -> picture;
	display();
end;
;;;
;;;	The following function shows a modificiation of the basic
;;;	picture.
function repaint();
	vars x, y, height, width, picture;
	'This is the basic picture repainted' =>
	compile(picturefile);
	dimensions() -> height -> width;
	for 1 -> x step x + 1 -> x till x > width then
		for 1 -> y step y + 1 -> y till y > height then
			if	picture(x,y) == 0
			then	space
			elseif	picture(x,y) == 1
			then	"-"
			elseif	picture(x,y) == 2
			then	"/"
			else	"*"
			close	-> picture(x,y);
		close;
	close;
	display();
end;
;;;	The following function applies an operator to the basic picture.
;;;	The operator is represented by a opsize*opsize element string (i.e. opsize rows of opsize).
;;;	The elements of the operator are either
;;;		+ add corresponding picture location
;;;	or	- subtract corresponding picture location
;;;	or	ignore picture location.
vars opsize;
function map(opr);
	vars x, y, dx, dy, height, width,
		sum, total, temp1, temp2, temp3, temp4;
	'After applying operator' =>
	for opsize -> y step y - 1 -> y till y == 0 then
		cucharout(`\t);
		for 1 -> x step x + 1 -> x till x > opsize then
			cucharout(subscrc(y*opsize+x-opsize,opr));
		close;
		cucharout(`\n);
	close;
	'The picture is' =>
	dimensions() -> height -> width;
	width - opsize -> width;
	height - opsize -> height;
	for 1 -> x step x + 1 -> x till x > width then
		for 1 -> y step y + 1 -> y till y > height then
			0 -> sum;
			0 -> total;
			10 -> temp3;
			0 -> temp4;
			for 0 -> dx step dx + 1 -> dx  till dx == opsize then
				for 0 -> dy step dy + 1 -> dy till dy == opsize then
					subscrc(opsize*dy+dx+1,opr) -> temp1;
					greypic(x+dx, y+dy) -> temp2;
					if	temp1 == `+
						or	temp1 == `-
					then	total + temp2 -> total;
						if temp2 < temp3 then temp2 -> temp3 close;
						temp4 + 1 -> temp4;
						if	temp1 == `+
						then	sum + temp2
						else	sum - temp2
						close	-> sum;
					close
				close;
			close;
			total - (temp3 * temp4) -> total;
			unless total == 0 then
				erase(abs(sum) * 10 // total -> sum);
				if sum > 9 then 9 -> sum close;
				unless	isinteger(picture(x, y))
					and	picture(x, y) > sum
				then	sum -> picture(x, y)
				close
			close
		close;
	close;
	display();
end;
;;;	The following function shows vertical lines.
function vert();
	vars opsize; 2 -> opsize;
	map('+-+-');
end;
;;;
;;;	The following function shows horizontal lines.
function horiz();
	vars opsize; 2 -> opsize;
	map('++--');
end;
;;;
;;;	The following function shows a perfect line drawing.
function perfect();
	'This is a perfect line drawing of the picture' =>
	Lib("edgepic");
	display();
end;
;;;
;;;	The following function reads a template line.
function tline(num);
	vars prompt, char;
	popmess(Prompt) -> prompt;
	'line-' >< num >< '\t' -> popmess(Prompt);
	undef -> char;
	fill(repeat opsize times
			unless char == `\n then charin() -> char close;
			if char == `\n then `\s else char close;
		close,
		initc(opsize));
	until char == `\n then charin() -> char close;
	prompt -> popmess(Prompt);
end;
;;;	The following function reads an operator and then applies it.
function read();
	vars opr, num, opsize;
	'What size template would you like?' =>
	itemread() -> opsize;
	'Please type in your template' =>
	for 1 -> num, '' -> opr step num + 1 -> num till num > opsize then
		tline(num) >< opr -> opr;
	close;
	map(opr)
end;
;;;
4 -> minlinelength;
vars describe;
function process();
	vars x,y, x1, y1, x2, y2, threshold, xmax, ymax, paint;
	if popmess([%Fork%]) then
		erase(popmess([%Wait%]))
	exit;
	function errfun();
		'picture too complicated -- try a higher threshold' =>
		interrupt();
	end;
	vars interrupt; popmess(%[%Exit%]%) -> interrupt;
	[] -> database;
	[] -> greypic;
	[] -> basic;
	[] -> repaint;
	[] -> map;
	[] -> vert;
	[] -> horiz;
	[] -> perfect;
	[] -> tline;
	[] -> read;
	[] -> describe;
	unless isinteger(threshold) then 1 -> threshold close;
	dl(fnprops(picture)) -> ymax -> y -> xmax -> x;
	until y > ymax then
		1 -> x;
		until x > xmax then
			picture(x, y) -> paint;
			if isinteger(paint) and paint < threshold then
				space -> picture(x, y)
			close;
			x + 1 -> x;
		close;
		y + 1 -> y;
	close;
	'Please be patient - this takes a long time' =>
	seepicture();
	'This is the picture with features noted' =>
	display();
	interrupt();
end;
;;;	The following function calls SEEPICTURE.
function describe();
	Lib("edgepic");
	process();
end;
;;;
vars threshold; 1 -> threshold;
function display();
	vars x, y, height, width, paint, col;
	dimensions() -> height -> width;
	for height -> y step y - 1 -> y till y == 0 then
		0 -> col;
		for 1 -> x step x + 1 -> x till x > width then
			picture(x, y) -> paint;
			if paint == space or isinteger(paint) and paint < threshold then
				col + 1 -> col
			else
				while col > 0 then cucharout(`\s), col - 1 -> col close;
				pr(paint);
			close
		close;
		cucharout(`\n);
	close;
end;
;;;
function reset();
	compile(picturefile);
	picture -> greypic;
	newpicture(dimensions());
end;
;;;
function col(n, x, y);
	greypic(x + n, y)
	+ greypic(x + n, y + 1)
	+ greypic(x + n, y + 2)
end;
;;;
function row(n, x, y);
	greypic(x, y + n)
	+ greypic(x + 1, y + n)
	+ greypic(x + 2, y + n)
end;
;;;
function diff();
	vars x, y, xmax, ymax;
	dimensions() -> ymax -> xmax;
	for 1 -> x step x + 1 -> x till x + 2 = xmax then
		for 1 -> y step y + 1 -> y till y + 2 = ymax then
			row(0, x, y) - row(2, x, y) -> dx;
			col(0, x, y) - col(2, x, y) -> dy;
			if abs(dx) + abs(dy) > threshold then
				subscr(intof(angleof(dx, dy) / 36) + 1, {a b c d e f g h i j})
					-> picture(x, y);
			close
		close
	close
end;
;;;
reset();
;;;
prstring('\
commands available are:\
: basic();	;;; show basic picture\
: repaint();	;;; show basic picture repainted\
: vert();	;;; add vertical lines to picture\
: horiz();	;;; add horizontal lines to picture\
: read();	;;; add points found by user defined template\
: diff();	;;; differentiate the picture\
: reset();	;;; clear the picture\
: display();	;;; show those points in the picture exceeding threshold\
: process();	;;; find lines in current picture\
: perfect();	;;; show perfect line drawing\
: describe();	;;; find lines in perfect drawing\
');
