#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"
#include	"../h/em1.h"

/*
 * this file contains several library routines.
 * these routines are included to overcome the
 * incompatibilities between UNIX version 6 and 7.
 * not included are the system call routines and printf.
 */

zero(area,length) char *area; {
	register char *p;
	register n;
	/*
	 * Clear area of length bytes.
	 */
	if ((n=length)==0)
		return;
	p = area;
	do *p++=0; while (--n);
}

bmove(from,to,count) char *from,*to; {
	register char *p1,*p2;
	register n;
	/*
	 * Move count bytes from from to to 
	 */
	p1 = from; p2 = to; n = count;
	do
		*p2++ = *p1++;
	while (--n);
}

int strcmp(as1,as2) char *as1,*as2; {
	register char *s1,*s2;
	/*
	 * String compare.
	 */
	s1 = as1; s2 = as2;
	while (*s1++ == *s2)
		if (*s2++ == 0)
			return(0);
	return( (*--s1 < *s2) ? -1 : 1);
}

strcpy(as1,as2) char *as1,*as2; {
	register char *s1,*s2;
	/*
	 * Fast string copy.
	 */
	s1 = as1; s2 = as2;
	while (*s1++ = *s2++)
		;
}

int abs(i) {
	return((i < 0) ? -i : i);
}

error(string1,a1) char	*string1,*a1; {
	/*
	 * diagnostic output
	 */
	error_count++;
	printf("%s: line %d (byte %o",progname,complines,inpoff);
	if (module[0])
		printf(";pro %s",module);
	printf("): ");
	printf(string1,a1);
	printf("\n");
	gen(ps_mes,CONST,0);
	outbyte(sp_cend);
}

fatal(s) char *s; {
	static	secondfatal;
	/*
	 * handle fatal errors
	 */
	if (secondfatal)
		return;
	secondfatal++;
	error("Fatal error: %s",s);
	ertrap();
}

ertrap() { /* trap routine to drain input in case of compile errors */

	gen(ps_mes,CONST,0);
	outbyte(sp_cend);
	if (ifile.fd == 0)
		while (getc(&ifile) >= 0)
			;
	pflush(&ofile);
	exit(-1);
}

putchar(c) char c; {
	/*
	 * only used for diagnostic output by printf
	 */
	if (write(2,&c,1) < 0)
		;
}

finit(af,fd) FILE *af; {
	register FILE *f;
	/*
	 * initialize file structure
	 */
	f = af;
	f->fd = fd;
	f->nleft = 0;
	f->nextp = 0;
}

int ffill(af) FILE *af; {
	register FILE *f;
	/*
	 * read in next block
	 */
	f = af;
	f->nextp = f->buff;
	return(f->nleft = read(f->fd,f->buff,BUFSIZ) - 1);
}

pflush(af) FILE *af; {
	register FILE *f;
	/*
	 * write out a (partial) filled block; fatal if error
	 */
	f = af;
	if (f->nextp)
		if (write(f->fd,f->buff,f->nextp - f->buff) < 0)
			fatal("write error");
	f->nextp = f->buff;
	f->nleft = BUFSIZ;
}

int getc(af) FILE *af; {
	register FILE *f;
	/*
	 * read next character; return -1 on eof
	 */
	f = af;
	if (--f->nleft < 0)
		if (ffill(f) < 0)
			return(EOF);
	return(*(f->nextp)++ & 0377);
}

putc(c,af) FILE *af; {
	register FILE *f;
	/*
	 * write next character
	 */
	f = af;
	if (--f->nleft < 0) {
		pflush(f);
		--f->nleft;
	}
	*(f->nextp)++ = c;
}

putw(w,f) FILE *f; {
	/*
	 * two times putc
	 */
	putc(w,f);
	putc(w>>8,f);
}

outbyte(b) {
	/*
	 * scratch out byte on code file
	 */
	putc(b,&ofile);
}

int readbyte() {
	register b; register FILE *f;
	/*
	 * Read one byte from ifile.
	 */
	inpoff++;
	f = &ifile;
	if (--f->nleft < 0)
		if (ffill(f) < 0)
			fatal("end of file on input");
	b = *(f->nextp)++ & 0377;
	if (pseumode)
		put_byte_in_list(b);
	return(b);
}

int readword() {
	register n;
	/*
	 * get a word.
	 */
	n = readbyte();
	return(n | (readbyte() << 8));
}


even() {
	/*
	 * Called when a word constant has to be assembled
	 */
	if ( odd(databytes) ) databytes++;
}

extword(w) {
	/*
	 * Assemble the word constant w.
	 */
	even();
	databytes =+ 2;
	if (inrom)
		if (lastrom < oursize->n_rom)
			rom[lastrom++] = w;
		else {
			lastglosym->g_rom = 0;
			fatal("out of rom");
		}
}
