/*
 * compile time options
 */

/* #define DUMP			/* dump between passes */

#ifndef DUMP
#define dump()			/* nothing */
#endif

/*
 * incompatibilities between C version 6 and C version 7
 */

#ifdef C7
#define	lnp_cast		(line_t *)
#define gbp_cast		(glob_t *)
#define lbp_cast		(locl_t *)
#define prp_cast		(proc_t *)
#define	iip_cast		(int	*)
#define	int_cast		(int	)
#define	chp_cast		(char	*)
#define	rmp_cast		(remb_t	*)
#define	blp_cast		(bloc_t	*)
#define	lsp_cast		(list_t	*)
#endif
#ifndef C7
#define	lnp_cast		/* nothing */
#define	gbp_cast		/* nothing */
#define	lbp_cast		/* nothing */
#define	prp_cast		/* nothing */
#define	iip_cast		/* nothing */
#define	int_cast		/* nothing */
#define	chp_cast		/* nothing */
#define	rmp_cast		/* nothing */
#define	blp_cast		/* nothing */
#define	lsp_cast		/* nothing */
#endif

#ifdef NC6
#define C7	1
#endif

#ifdef C7
typedef	struct lines		line_t;
typedef	struct loc_label	locl_t;
typedef	struct glob_label	glob_t;
typedef	struct mnems		mnem_t;
typedef	struct sizes		size_t;
typedef	struct procs		proc_t;
typedef struct list		list_t;
typedef struct block		bloc_t;
typedef struct remem		remb_t;
typedef struct file		FILE;

typedef union {
	int	ad_i;
	locl_t	*ad_lp;
	glob_t	*ad_gp;
	proc_t	*ad_pp;
}	addr_u;

#define	EQ			=
#endif
#ifndef C7
#define	line_t	struct lines
#define	locl_t	struct loc_label
#define	glob_t	struct glob_label
#define	mnem_t	struct mnems
#define	size_t	struct sizes
#define	proc_t	struct procs
#define	list_t	struct list
#define	bloc_t	struct block
#define	remb_t	struct remem
#define	FILE	struct file

#define addr_u	int
#define	EQ		/* nothing */
#endif

#ifndef CEM
#define	void	int
#endif

/*
 * Global variables for EM1-optimiser
 * Version 10		13-07-79
 */

#define	ABSENT		op_nul
#define op_PSEU		255		/* reserved instr # */

#define	MISSING		0
#define	CONST		1
#define PROCNAME	2
#define GLOSYM		3
#define LOCSYM		4
#define PSEUDO		5

#define DEFINED		01	/* must be 1 (cf. opt60.c) */
#define DEFINING	DEFINED
#define IMPORT		02
#define EXPORT		04
#define OCCURRING	010
#define OCCURRED	OCCURRING
#define RELOC		020


#define	MAXIDENT	8
#define	MAXSTRING	200
#define MAXREG		64

#define odd(n)		((n)&1)		/* boolean odd function */

struct loc_label
{
	int	l_num;
	char	l_status;
};

struct glob_label
{
	char	g_name[MAXIDENT+1];	/* must be first in structure */
	char	g_status;
	int	g_val;
	int    *g_rom;		/* points into rom */
};

struct lines
{
	char	instr_num;
	char	type1;
	addr_u	ad;
};

struct mnems
{
	char	m_name[3];
	char	m_nminis;
	char	m_mbase;
	char	m_nshorties;
	char	m_sbase;
	char	m_obase;
	int	m_flags;
};

/* flagbits of m_flags */
#define MN0		0
#define MNS		01
#define MNL		02
#define MNXYZ		014
#define		MNX	004
#define		MNY	010
#define		MNZ	014
#define MNABCEM		0160
#define		MNA	0020
#define		MNB	0040
#define		MNM	0060
#define		MNC	0100
#define		MNE	0120
#define MNO		0200

struct procs {
	char	p_name[MAXIDENT+1];
	char	p_status;
};

struct sizes {
	int	n_lines;
	int	n_llab;
	int	n_glab;
	int	n_proc;
	int	n_rom;
};

#define	EXCESS		33
#define	CONLIM		(2*EXCESS)
#define	ARANGE		17
#define ARITBASE	(CONLIM+4*ARANGE)

#define TRUE	1
#define FALSE	0

struct	pattern {
	struct	element {
		char	instr;
		char	operand;
	} sub[7];
	char	optkind;
	char	optbits;
};

#define	BUFSIZ		512
#define	EOF		(-1)
#define	NULL		0

struct	file {
	int	fd;
	int	nleft;
	char	*nextp;
	char	buff[BUFSIZ];
};

#ifndef C7
struct {int	ad_i;};
struct {locl_t	*ad_lp;};
struct {glob_t	*ad_gp;};
struct {proc_t	*ad_pp;};
#endif

#ifdef SFLOAT
#define	REALSIZE	4
#endif
#ifndef SFLOAT
#define	REALSIZE	8
#endif

#define	LONGSIZE	4
