#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */

/*
** Main routine of EM-1 optimizer
*/

#define MAGIC	172

main(argc, argv) int argc; char **argv; {
	register char *argp;
	register fd,w;

	progname = argv[0];
	while(--argc && **++argv == '-') {
		argp = *argv;
		while (*++argp)
		{
			switch(*argp) {
			case 'v':
				silent=0; break;
			case 's':
				getsizes(argp+1); argp = "x"; break;
			case 'd':
				++d_flag; break;
			case 'N':
				optimizing=0; break;
				/* process EXC and constant glosyms only */
			case 'L':
				if(--argc >= 0) {
					++makelib;
					if ((libfil = creat(*++argv,0644)) < 0)
						fatal("can't create lib file");
				}
				break;
			default:
				error("bad flag %s",argp);
			}
		}
	}
	getcore();
	if (argc>0) {
		if ((fd = open(argv[0],0)) < 0)
			fatal("unable to open the input file");
	} else
		fd = 0;
	finit(&ifile,fd);
	finit(&ofile,1);
	w = getc(&ifile); w =| (getc(&ifile) << 8);
	if (w != MAGIC)
		fatal("Bad input format");
	putw(MAGIC,&ofile);
	init_vars();
	init_lists();

	do {
		initproc();
		read_compact(); dump(1);
		pass_2();
		pass_3(); dump(3);
		if (d_flag) pflush(&ofile);
		forget();
	}
	while (!eof_seen);
	finish_up();
}

int askmore(n) {
	register result;

	/*
	 * This routine asks for a chunk of n bytes core.
	 * It does this by asking the system for it.
	 * If your operating system doesn't provide this,
	 * or if you don't have an operating system it
	 * can be simulated as follows:
	 *
	 * You should have a variable end, containing the address
	 * of the first location not used by this program.
	 *
	 * int askmore(n) {
	 *	register result;
	 *
	 *	result = end;
	 *	end =+ n;	/* check overflow
	 *	return(result);
	 * }
	 *
	 */
	result = int_cast sbrk(n);
	if (result == -1)
		fatal("out of core");
	return(result);
}

getcore() {
	register size_t *p;
	size_t bytes;
	register n,base;

	p = oursize; n = 0;
	n =+ (bytes.n_lines = p->n_lines * (sizeof *line));
	n =+ (bytes.n_llab = p->n_llab * (sizeof *loclabel));
	n =+ (bytes.n_glab = p->n_glab * (sizeof *globlabel));
	n =+ (bytes.n_proc = p->n_proc * (sizeof *procdesc));
	n =+ (bytes.n_rom = p->n_rom * (sizeof *rom));
	base = askmore(n);
	line = lnp_cast base; base =+ bytes.n_lines;
	loclabel = lbp_cast base; base =+ bytes.n_llab;
	globlabel = gbp_cast base; base =+ bytes.n_glab;
	procdesc = prp_cast base; base =+ bytes.n_proc;
	rom = iip_cast base; base =+ bytes.n_rom;
}

getsizes(str) char *str; {

	/*
	 * accepts -ss (small), -sm (medium), -sl (large)
	 * Should also accept: -s#,#,#,#,#,#,#,#
	 * When this is implemented compute prime numbers for
	 * hash table sizes.
	 */

	switch(*str) {
	default:error("bad size option %s",str);
	case 's':	oursize = &sizes[0]; break;
	case 'm':	oursize = &sizes[1]; break;
	case 'l':	oursize = &sizes[2]; break;
	}
}

init_vars() {

	complines = 0;
	last_proc = procdesc;
}

initproc() {

	zero(chp_cast loclabel,oursize->n_llab*sizeof loclabel[0]);
	last_line = line;
	nlocs = 0;
	regp = regvar;
}

pro_check() {
	register proc_t *p;

	for(p=procdesc;p<last_proc;p++)
		if((p->p_status & EXPORT) &&
			(p->p_status & DEFINED) == 0)
		error("undefined pro-export %.8s",p->p_name);
}

glo_check () {
	register glob_t *gbp;

	for(gbp=globlabel;gbp < &globlabel[oursize->n_glab]; gbp++)
		if (gbp->g_name[0]
		 && (gbp->g_status&EXPORT)
		 && ((gbp->g_status&DEFINED)==0) )
			error("undefined global-export",0);
}

finish_up() {

	module[0]=0;
	pro_check();
	glo_check();
	pflush(&ofile);
	exit(error_count != 0);
}
