%token	NUMBER COMMENT BMCL END ZEXT ADZERO ADONE
%token	AMPCR SAR LIT CSAR SLIT CTR LCTR INC COMP LABEL
%token	MDOP SET RESET GC LBLDOT DESTSEP COMPSEP
%token	LC1 LC2 LC3 GC1 GC2 INT
%token	LST MST AOV ABT COV SAI RDC
%token	IF THEN ELSE WHEN NOT
%token	SUCCESSOR IC
%token	A1 A2 A3 MIR
%token	ADA1 ADA2 ADA3 ADCTR ADAMPCR ADB
%token	BEX BAD BMI BBE BBA BBI BC4 BC8
%token	MAR MAR1 MAR2 BR1 BR2 LMAR
%token	ADDOP
%{
#include "const.h"

	FILE *fdi, *fdh, *fdl, *fdh1;
	char *lfnptr, *hfnptr;
	int	yyline = 1;
	int	mpm[4],nano[16];
	int	HEX,HEX1,BINARY,ECHO,EOL;
	int	STATS;
	char	buf[BUFSIZE],*p1;
	char	buf1[BUFSIZE],*fnhptr;
	int	setflg,mflag,sucflg,lopflag;
	int	ctrflag,lctrflg,marflag,lmarflg,sarflag,csarflg;
	int	sflag,destflg,plusflg,minusflg,lbflag;
	int	litflg,labcnt,ovflg,compl,litfirst;
	int	temp,linecnt,errcnt,nanocnt;
	int	x_input,y_input;
	int	keyword[] =
		{
			COMP,	'c',	ELSE,	END,
			GC,	IC,	IF,	LIT,
			'l',	NOT,	RESET,	'r',
			SET,	SLIT,	THEN,	WHEN,
			ZEXT,	'z'
		};
	int	condta[] =
		{
			ABT,	AOV,	COV,	GC1,
			GC2,	INT,	LC1,	LC2,
			LC3,	LST,	MST,	RDC,
			SAI
		};
/*
 *	Now follow the key words which are both adder inputs 
 *	and destinations. There must be a lexical distinction
 *	made between these two uses.
 */
	int	keyw2a[] =
		{
			ADA1,	ADA2,	ADA3,	ADAMPCR,
			ADCTR,	CSAR,	0
		};
	int	keyw2[] =
		{
			A1,	A2,	A3,	AMPCR,
			CTR,	CSAR,	0
		};
/*
 *	destinations beginning with 'b'...
 */
	int	destbtbl[] =
		{
			BAD,	BBA,	BBE,	BBI,
			BC4,	BC8,	BEX,	BMI,
			BR1,	BR2,	0
		};
/*
 *	beginning with 'm'...
 */
	int	destmtbl[] =
		{
			MAR,	MAR1,	MAR2,	MIR,
			0
		};
/*
 *	others ('l','i','s')..
 */
	int	destlis[] =
		{
			LCTR,	LMAR,	INC,	SAR,
			0
		};
/*
 *	Now follow two tables which are used to allow
 *	adder operations to be expressed with 'not'
 *	before x or y inputs.
 *		e.g.
 *			x and not y
 *		rather than
 *			x nim y
 *	etc.
 *
 *	Entries of 16 correspond to illegal use of 'not'
 *	( for example  "not x + y" cannot be encoded ).
 */

	int	xalt[] =
		{
			16,	7,	11,	16,
			13,	16,	9,	1,
			14,	6,	16,	2,
			16,	4,	8,	16,
			16
		};
	int	yalt[] =
		{
			12,	2,	1,	15,
			8,	16,	9,	11,
			4,	6,	16,	7,
			0,	14,	13,	3,
			16
		};
%}
%%
program:
	body end_line	=
	{
		mpm[0] = 4;
		fwrite((char *)mpm, sizeof mpm, 1, fdh);
		fwrite((char *)nano, sizeof nano, 1, fdh);
	};

body:
	program_line '\n'	=
	{
		yyline++;
	}|
	body program_line '\n'	=
	{
		yyline++;
	}|
	body error '\n'	=
	{
		yyerrok;
		errcnt++;
		yyline++;
	};

program_line:
	COMMENT|
	label_part|	/* label only - may also be empty */
	label_part instruction	=
	{
		fwrite((char *)mpm, sizeof mpm, 1, fdh);
		fwrite((char *)nano, sizeof nano, 1, fdh);
		if( BINARY )	binout();
		linecnt++;
	};

instruction:
	literal_assign	=
	{
		$$ = FALSE;
	}|
	nanoinstruction	=
	{
		$$ = TRUE;
		mpm[0] = 0xF;
		mpm[1] = (nanocnt & 0xF00) >> 8;
		mpm[2] = (nanocnt & 0x0F0) >> 4;
		mpm[3] = (nanocnt & 0x00F);
		nanocnt++;
	};

label_part:
	|	/* empty */
	label_part LBLDOT	=
	{
		storelbl((char *)($2));
	};

end_line:
	END '\n'|
	=	/* empty ,ie. eof */
	{
		printf("Warning. No end statement.\n");
	};

/*
 *	literal assignment
 */
literal_assign:
	literal '=' AMPCR	=
	{
		litstore((struct litinfo *)($1),AMPCR );
	}|
	literal '=' SAR		=
	{
		litstore((struct litinfo *)($1),SAR );
	}|
	literal '=' lit		=
	{
		litstore((struct litinfo *)($1),$3 );
	}|
	literal '=' SAR COMPSEP literal '=' lit	=
	{
		sflag = TRUE;
		litptr = (struct litinfo *)($1);
		if( !litptr->flagl )	litfirst = TRUE;
		litstore((struct litinfo *)($1),SAR );
		litstore((struct litinfo *)($5),$7 );
	}|
	literal '=' lit COMPSEP literal '=' SAR	=
	{
		sflag = TRUE;
		litptr = (struct litinfo *)($1);
		if( litptr->flagl )	litfirst = TRUE;
		litstore((struct litinfo *)($5),SAR );
		litstore((struct litinfo *)($1),$3 );
	};

literal:
	integer	=
	{
		litptr->flagc = FALSE;
		litptr->flagl = FALSE;
		litptr->litvalu = $1;
		$$ = (int)(litptr++);
	}|
	COMP integer	=
	{
		litptr->flagc = TRUE;
		litptr->flagl = FALSE;
		litptr->litvalu = ~$2;
		$$ = (int)(litptr++);
	}|
	LABEL	=
	{
		litptr->flagl = TRUE;
		storelit((char *)($1));
		litptr->litvalu = $1;
		$$ = (int)(litptr++);
	}|
	LABEL '-' '1'	=
	{
		litptr->flagl = 2;
		storelit((char *)($1));
		litptr->litvalu = $1;
		$$ = (int)(litptr++);
	};

lit:
	LIT	=
	{
		$$ = LIT;
	}|
	SLIT	=
	{
		$$ = SLIT;
	};

/*
 *	nanoinstruction statements
 */
nanoinstruction:
	unconditional conditional	=
	{
/*
 *	if no successor specified - set default (step unconditional).
 */
		if( !sucflg )	nano[3] = 011;
	};

unconditional:
	comp_list	;

comp_list:
	component	=
	{
		$$ = $1;
	}|
	comp_list COMPSEP component	=
	{
		$$ = $1 | $3;
		destflg = FALSE;
	}|
	=	/* empty */
	{
		$$ = 0;
	};

component:
	ext_op	=
	{
		$$ = 04;
	}|
	logic_op	=
	{
		$$ = 02;
	}|
	SUCCESSOR	=
	{
		if( sucflg )
		{
			perr("more than one successor");
		}
		else
		{
			sucflg = TRUE;
			nano[3] |= $1;
			nano[2] |= ($1 >> 1);
			if( $1 & 1 )	nano[3] |= 8;
		}
		$$ = 01;
	};

ext_op:
	MDOP	=		/* memory device op */
	{
		if( mflag )
		{
			perr("more than one memory operation");
		}
		else
		{
			mflag = TRUE;
			nano[12] |= ($1 & 014) >> 2;
			nano[13] = ($1 & 3) << 2;
		}
	}|
	set_op	=
	{
		if( setflg )
		{
			perr("you can only set one condition at a time");
		}
		else
		{
			if( $1 & 4 )	nano[1] |= 1;
			nano[2] |= (($1 & 3) << 2);
			setflg = TRUE;
		}
	}

set_op:
	SET caj_bit	=
	{
		$$ = $2;
	}|
	RESET GC	=
	{
		$$ = 3;
	};

caj_bit:
	LC1	=
	{
		$$ = 7;
	}|
	LC2	=
	{
		$$ = 1;
	}|
	LC3	=
	{
		$$ = 5;
	}|
	INT	=
	{
		$$ = 4;
	}|
	GC1	=
	{
		$$ = 6;
	}|
	GC2	=
	{
		$$ = 2;
	};

logic_op:
	adder_op op_ic shift_op destinations	=
	{
		if( lopflag )
		{
			perr("more than one adder operation");
		}
		else
		{
			if( $1 & 8 )	nano[6] |= 1;
			nano[7] |= (($1 & 7) << 1);
			if( $3 & 2 )	nano[7] |= 1;
			nano[8] |= (($3 & 1) << 3);
			nano[4] |= (x_input << 1) & 016;
			nano[4] |= (y_input >> 6) & 01;
			nano[5] |= (y_input >> 2) & 017;
			nano[6] |= (y_input << 2) & 014;
			lopflag = TRUE;
		}
	};

op_ic:
	IC	=
	{
		nano[6] |= 02;		/* set bit 27 */
	}|
	;	/* empty - no action */

adder_op:
	not x_select	=
	{
		if( $1 )	$$ = 1;
		else	$$ = 0;
	}|
	not y_select	=
	{
		if( ($1 && !compl) || ((!$1) && compl ) )
			$$ = 12;
		else	$$ = 0;
	}|
	not x_select ADDOP not y_select	=
	{
		if( $1 )
		{
			if( ($4 && !compl) || ((!$4) && compl) )
					temp = xalt[ yalt [ $3 ] ];
			else		temp = xalt[ $3 ];
		}
		else
		{
			if( ($4 && !compl) || ((!$4) && compl) )
					temp = yalt[ $3 ];
			else		temp = $3;
		}
		if( temp == 16 )
			perr(" 'not' used incorrectly");
		$$ = temp;
	}|
/*
 *	In the following two rules ( x+y+1 and x-y-1 ),
 *	the 'not' before the x_select is provided ONLY
 *	for uniformity with the previous three rules.
 *	This prevents Yacc splitting these five rules
 *	into two separate groups:
 *		'not'	seen......
 *			and
 *			not seen.
 */
	not x_select '+' not y_select '+' ADONE	=
	{
		if( $1 )	perr(" 'not' used incorrectly");
		if( ($4 && !compl) || (compl && !$4) )
			$$ = 15;
		else	$$ = 3;
	}|
	not x_select '-' not y_select '-' ADONE	=
	{
		if( $1 )	perr(" 'not' used incorrectly");
		if( ($4 && !compl) || (compl && !$4) )
			$$ = 0;
		else	$$ = 12;
	}|
	=	/* empty - treat as 0 + 0 */
	{
		$$ = 0;
	};

not:
	NOT	=
	{
		$$ = TRUE;
	}|
	=	/* empty */
	{
		$$ = FALSE;
	};

x_select:
	ADZERO	=
	{
		x_input = 0;
	}|
	ADA1	=
	{
		x_input = 5;
	}|
	ADA2	=
	{
		x_input = 6;
	}|
	ADA3	=
	{
		x_input = 7;
	}|
	ADCTR	=
	{
		x_input = 3;
	}|
	LIT	=
	{
		x_input = 1;
	}|
	'z'	=
	{
		x_input = 4;
	}|
	ZEXT	=
	{
		x_input = 2;
	};

y_select:
	ADZERO	=
	{
		y_input = 0;
	}|
	ADONE	=
	{
		y_input = 03;
	}|
	ADB	=
	{
		y_input = 061;
	}|
	BMCL	=
	{
		y_input = (($1 & 060) << 1) | (($1 & 04) << 2) | ($1 & 03);
	}|
	ADCTR	=
	{
		y_input = 054;
	}|
	LIT	=
	{
		y_input = 05;
	}|
	ADAMPCR	=
	{
		y_input = 031;
	}|
	ZEXT	=
	{
		y_input = 010;
	}|
	'z'	=
	{
		y_input = 065;
	};

shift_op:
	'r'	=
	{
		$$ = 1;
	}|
	'l'	=
	{
		$$ = 2;
	}|
	'c'	=
	{
		$$ = 3;
	}|
	=	/* empty - no shift */
	{
		$$ = 0;
	};

destinations:
	'='	|
	'=' dest	|
	dest	|
	destinations DESTSEP dest;

dest:
	A1	=
	{
		nano[8] |= 04;
	}|
	A2	=
	{
		nano[8] |= 02;
	}|
	A3	=
	{
		nano[8] |= 01;
	}|
	MIR	=
	{
		nano[10] |= 010;
	}|
	BR1	=
	{
		nano[10] |= 02;
	}|
	BR2	=
	{
		nano[10] |= 01;
	}|
	AMPCR	=
	{
		nano[10] |= 04;
	}|
	b_input	=
	{
		nano[9] |= $1;
	}|
	ctr_input	=
	{
		nano[11] |= $1 & 07;
	}|
	mar_input	=
	{
		nano[10] |= ($1 >> 2) & 03;
		nano[11] |= ($1 << 2) & 014;
	}|
	sar_input	=
	{
		nano[12] |= ($1 << 2) & 014;
	};

b_input:
	'b'	=
	{
		$$ = 11;
	}|
	BEX	=
	{
		$$ = 12;
	}|
	BAD	=
	{
		$$ = 8;
	}|
	BMI	=
	{
		$$ = 13;
	}|
	BBE	=
	{
		$$ = 14;
	}|
	BBA	=
	{
		$$ = 10;
	}|
	BBI	=
	{
		$$ = 15;
	}|
	BC4	=
	{
		$$ = 1;
	}|
	BC8	=
	{
		$$ = 9;
	};

ctr_input:
	CTR	=
	{
		if( lctrflg || lmarflg )
		{
			perr("ctr cannot follow lmar, lctr or inc");
			$$ = 0;
		}
		else
		{
			$$ = 05;
			ctrflag = TRUE;
		}
	}|
	LCTR	=
	{
		if( ctrflag )
		{
			perr("lctr cannot follow ctr or inc");
			$$ = 0;
		}
		else
		{
			$$ = 01;
			lctrflg = TRUE;
		}
	}|
	INC	=
	{
		$$ = 02;
	};

mar_input:
	MAR	=
	{
		if( ctrflag || lmarflg )
		{
			perr("mar cannot follow ctr or lmar");
		}
		else
		{
			$$ = 03;
			marflag = TRUE;
		}
	}|
	MAR1	=
	{
		if( ctrflag || lmarflg )
		{
			perr("mar1 cannot follow ctr or lmar");
		}
		else
		{
			$$ = 013;
			marflag = TRUE;
		}
	}|
	MAR2	=
	{
		if( ctrflag || lmarflg )
		{
			perr("mar2 cannot follow ctr or lmar");
		}
		else
		{
			$$ = 07;
			marflag = TRUE;
		}
	}|
	LMAR	=
	{
		if( ctrflag || marflag )
		{
			perr("lmar cannot follow ctr, mar, mar1 or mar2");
		}
		else
		{
			$$ = 02;
			lmarflg = TRUE;
		}
	};

sar_input:
	SAR	=
	{
		if( csarflg )
		{
			perr("sar cannot follow csar");
		}
		else
		{
			$$ = 02;
			sarflag = TRUE;
		}
	}|
	CSAR	=
	{
		if( sarflag )
		{
			perr("csar cannot follow sar");
		}
		else
		{
			$$ = 01;
			csarflg = TRUE;
		}
	};

conditional:
	if_part then_part else_part|
	if_part	|
	when_part	=
	{
		if( !sucflg )
		{
			nano[3] = 010;
			sucflg = TRUE;
		}
		else
		{
			nano[3] &= 070;		/* mask else successor to wait */
		}
	}|
	when_part then_part	=
	{
		nano[3] &= 070;
	}|
	;	/* empty */

if_part:
	IF condition	;

condition:
	not basic_cond	=
	{
		if( !$1 )	nano[1] |= 010;
		nano[0] = $2;
	};

basic_cond:
	LST	=
	{
		$$ = 5;
	}|
	MST	=
	{
		$$ = 4;
	}|
	AOV	=
	{
		$$ = 7;
	}|
	ABT	=
	{
		$$ = 6;
	}|
	COV	=
	{
		$$ = 8;
	}|
	SAI	=
	{
		$$ = 9;
	}|
	RDC	=
	{
		$$ = 10;
	}|
	GC1	=
	{
		$$ = 0;
	}|
	GC2	=
	{
		$$ = 1;
	}|
	LC1	=
	{
		$$ = 2;
	}|
	LC2	=
	{
		$$ = 3;
	}|
	LC3	=
	{
		$$ = 11;
	}|
	INT	=
	{
		$$ = 13;
	};

then_part:
	THEN comp_list	=
	{
		if( $2 & 04 )
		{
			nano[1] |= 02;
		}
		if( $2 & 02 )
		{
			nano[1] |= 04;
		}
		if( !($2 & 01) )
		{
			if( !sucflg )
			{
				nano[3] = 011;
				sucflg = TRUE;
			}
		}
	};

else_part:
	=	/* empty */
	{
		nano[3] = (nano[3] & 010) | 01;
	}|
	ELSE SUCCESSOR	=
	{
		nano[3] = (nano[3] & 070) | ($2 & 07);
	};

when_part:
	WHEN condition	;

/*
 *	low level production
 */
integer:
	'0'|
	'1'|
	NUMBER;

%%
