#

#include	"mas.h"

extern struct aform aout;
extern char symbuf[];
extern char getnonbl();
extern char getch();
extern  char  peekc;
extern pc_def;
extern char seg;
extern unsigned pc;
extern unsigned text;
extern unsigned data;
extern unsigned bss;
extern struct evalx r;
extern lab;
extern struct symbol *symtab;
extern char tch;


savepc()
{
	switch(seg)
	{
	case TEXT:
		text = pc;
		break;
	case DATA:
		data = pc;
		break;
	case BSS:
		bss = pc;
		break;
	}
}

pseudop(opc)
{
	register n;
	register char c;
	register l;
	struct symbol *p;

	switch (opc) {
	case o_TEXT:
		if(seg == TEXT)
			return;
		pass1a();	/* clean up expressions */
		savepc();
		pc = text;
		seg = TEXT;
		return;

	case o_DATA:
		if(seg == DATA)
			return;
		pass1a();	/* clean up expressions */
		savepc();
		pc = data;
		seg = DATA;
		return;

	case o_BSS:
		if(seg == BSS)
			return;
		pass1a();	/* clean up expressions */
		savepc();
		pc = bss;
		seg = BSS;
		return;

	case o_GLBL:
		c = getnonbl();
		for(;;)
		{
			if(digit(c) || getsym(c) == 0)
				syntax();
			p = &symtab[lookup()];
			p->s_def =+ GLBL;
			p->s_seg = UNDEF;
			p->s_pc = 0;
			c = getnxt();
			if(c == '\n')
				return;
			if(c != ',')
				syntax();
			c = getnxt();
		}
	case o_COMM:
		c = getnonbl();
		if(digit(c) || getsym(c) == 0)
			syntax();
		p = &symtab[lookup()];
		p -> s_def =+ GLBL;
		p-> s_seg = UNDEF;
		getexpr();
		evalexpr();
		if( r.r_type != ABS)
			syntax();
		p->s_pc = r.r_val;
		return;
	case o_EQU:
		if ( ! lab )
			syntax();
		getexpr();
		evalexpr();
		if ( r.r_type != ABS )	/* und, exp or est */
			outaform(a_EQU+lab);
		equsym(lab);
		return;

	case o_FCB:
		pc =+ getlis();
		return;

	case o_FDB:
		pc =+ getlis() << 1;
		return;

	case o_FCC:
		if ( (c = getnonbl()) != SLASH )
			syntax();
		while ( (c = getch()) != SLASH ) {
			if ( c == BACKSL )
				if ( nonspec(getch()) )
					pc++;
			if ( c == NL )
				syntax();
			if ( c == EOF )
				eoferr();
			pc++;
		}
		return;

	case o_RMB:
	case o_ZMB:
		getexpr();
		evalexpr();
		if ( (n = r.r_type) == UND )
			undefexp();
		if ( n != ABS ) {
			pass1a();
			evalexpr();
		}
		if ( r.r_type != ABS )
			syserr();
		if ( (n = r.r_val) < 0 )
			relerr();
		pc =+ n;
		return;
	}
}



nonspec(ch)
char ch;
{
register char c;
register int ct;

	if ( ((c = ch) == SLASH) ||
		(c == BACKSL) ||
		(c == 'n') ||
		(c == 't') ||
		(c == 'r') ||
		(c == 's') )
			return(0);
	if ( c == '0' ) {
		ct = 0;
		while ( ((c = getch()) >= '0') && (c <= '7') && (++ct < 4))
			;
		peekc = c;
		return(0);
	}

	return(1);
}
