module bufio;

device module clock[6];
define	tick, delay;
var	tick: signal;
	lcs[177546B]: bits;

	procedure delay(n: integer);
	var	left: integer;
	begin
		left := n;
		repeat
			wait(tick); dec(left)
		until left <= 0
	end delay;

	process driver[100B];
	begin
		lcs[6] := true;
		loop
			doio; send(tick)
		end
	end driver;

begin
	driver
end clock;

device module keyboard[4];
define	get;
const	n = 16;
var	inx, outx, nf: integer;
	nonfull, nonempty: signal;
	buf: array 1:n of char;

	procedure get(var ch: char);
	begin
		if nf = 0 then wait(nonempty) end;
		ch := buf[outx]; outx := (outx mod n) + 1;
		dec(nf);
		send(nonfull)
	end get;

	process driver[60B];
	var	kbs[177560B]: bits;
		kbb[177562B]: integer;
		ch: char;
	begin
		loop
			if nf = n then wait(nonfull) end;
			kbs[6] := true; doio; kbs[6] := false;
			ch := char(kbb mod 200B);
			buf[inx] := ch; inx := (inx mod n) + 1;
			inc(nf); send(nonempty)
		end
	end driver;

begin
	inx := 1; outx := 1; nf := 0;
	driver
end keyboard;

device module typewriter[4];
define	put;
use	delay;
const	n = 64;
var	inx, outx, nf: integer;
	nonfull, nonempty: signal;
	buf: array 1:n of char;

	procedure put(ch: char);
	begin
		if nf = n then wait(nonfull) end;
		buf[inx] := ch; inx := (inx mod n) + 1;
		inc(nf); send(nonempty)
	end put;

	process driver[64B];
	var	tws[177564B]: bits;
		twd[177566B]: char;
	begin
		loop
			delay(25);
			if nf = 0 then wait(nonempty) end;
			twd := buf[outx]; outx := (outx mod n) + 1;
			tws[6] := true; doio; tws[6] := false;
			dec(nf); send(nonfull)
		end
	end driver;

begin
	inx := 1; outx := 1; nf := 0;
	driver
end typewriter;

process stream;
use	get, put;
const	cr = 15C; lf = 12C;
var	ch: char;
begin

	loop
		get(ch);
		if ch = cr then
			put(cr); put(cr); put(lf)
		else
			put(ch)
		end
	end
end stream;

begin
	stream
end bufio.
