MODULE comms;

DEVICE MODULE dl11[4];
DEFINE get;
  CONST bmax=64; { buffer size }
  VAR buffer: ARRAY 0:bmax-1 OF char;
      in, out: integer; { buffer pointers }
      ready: signal;

  PROCEDURE get(VAR c: char);
  BEGIN
    IF out=in THEN wait(ready) END;
    c := buffer[out];
    out := (out+1) MOD bmax
  END get;

  PROCESS receiver[310B];
    VAR rsr[175610B]: bits; { receiver status }
        rbf[175612B]: char; { receiver buffer }
  BEGIN
    LOOP
      rsr[6] := true;
      doio;
      buffer[in] := rbf;
      in := (in+1) MOD bmax;
      send(ready)
    END
  END receiver;

BEGIN { dl11 }
  receiver
END dl11;


DEVICE MODULE la36[4];
DEFINE put;
  VAR nonbusy: signal;
      busy: boolean;

  PROCEDURE put(ch: char);
    VAR pbf[177566B]: char; { printer buffer }
  BEGIN
    IF busy THEN wait(nonbusy) END;
    busy := true;
    pbf := ch
  END put;

  PROCESS printer[64B];
    VAR psr[177564B]: bits; { printer status }
  BEGIN
    psr[6] := true;
    LOOP
      doio;
      busy := false;
      send(nonbusy)
    END
  END printer;

  PROCESS keyboard[60B];
    VAR ksr[177560B]: bits; { keyboard status }
        kbf[177562B]: char; { keyboard buffer }
        tbf[175616B]: char; { transmitter buffer }
  BEGIN
    LOOP
      ksr[6] := true;
      doio;
      tbf := kbf
    END
  END keyboard;

BEGIN { la36 }
  keyboard;
  printer
END la36;


PROCESS terminal;
  VAR ch: char;
BEGIN
  LOOP
    get(ch);
    put(ch)
  END
END terminal;


BEGIN { comms program }
  terminal
END comms.
{
.bp
}
