; The use and distribution of the information
; contained herein may be restricted.
;
title	xfma4,<4-word xfuns>,24,22-jul-74,mhb/tge/ld/tph

.sbttl	load push-pop code for extended functions

	..	ppsin,sin
	..	ppcos,cos
	..	ppatan,atan
	..	ppsqrt,sqrt
	..	ppexp,exp
	..	ppln,log
	..	pplg10,log10
	..	pptan,tan
.sbttl	long route for a**b (a**b = exp(b*log(a)) )

	org	xf,0

xf:	jsr	pc,logf		;take log of number to exponentiate
	movflt	(sp)+,-(r1)	;exponent back to r1
	jsr	pc,mulf		;mult by log of number
	jmp	expf		;and exit thru exponential routine
	.if	ndf	fpu
;	poly4 is a polynomial evaluator to eval
;	c(n)*x**n+c(n-1)*x**n-1+...+c(1)*x+c(0)
;	call poly4 (via $polsh) with x (a 4-wd fl-pt no.)
;	on the r1 stack and c(r4)=a pointer to a pointer to a word
;	containing n+1, i.e., the no. of constants.
;	the constants themselves are stored (as 4-wd fl-pt
;	no's.) immed. before the word containing the n+1,
;	with c(n) at lowest addr and c(0) at highest.
;	e.g., to eval. 5*x**2+3*x+2, the const. table
;	looks like:
;		.word	...,...,...,...		;4-wd fl-pt 5, i.e. c(2)
;		.word	...,...,...,...		;4-wd fl-pt 3, i.e. c(1)
;		.word	...,...,...,...		;4-wd fl-pt 2, i.e. c(0)
;		.word	3			;no. of cons'ts
;
poly2:	;poly2 is like poly4 - but for 2-word stuff
poly4:	mov	(r4)+,r0	;pointer to number of coefficients, etc.
	mov	r4,-(sp)	;save return pointer
	mov	(r0),r4		;save the number of coefficients in r4
	mov	r4,-(sp)	;and on the stack
	mov	(r1)+,r2	;save x
	mov	(r1)+,r3
	.rept	fltlen-2
	mov	(r1)+,-(sp)
	.endr
	br	plp42		;go push a coefficient
plp41:	.if	eq	fltlen-4	;fetch x back to the r1 stack
	mov	(sp),-(r1)
	mov	2(sp),-(r1)
	.endc
	mov	r3,-(r1)
	mov	r2,-(r1)
plp42:	movflt	-(r0),-(r1)	;push one of the coefficients
	dec	r4		;decrement the coefficient count
	bgt	plp41		;around again if count not done
	.if	eq	fltlen-4
	cmp	(sp)+,(sp)+	;some garbage off the stack
	.endc
	dec	(sp)		;decrement 2nd copy of counter
plp43:	jsr	pc,mulf		;multiply top of stack by x
	jsr	pc,addf		;add in next coefficient
	dec	(sp)		;decrement coefficient count
	bgt	plp43		;br if more to do in loop
	tst	(sp)+		;pop the counter
	mov	(sp)+,r4	;restore polish pointer
	jmp	@(r4)+		;polish exit
;	up4 is a polish routine to move the 4 wds at the head
;	of the stack to a loc 8 wd's away inside the stack
up2:	;like up4 but 2 words at head get moved 4 words away
up4:	movflt	(r1)+,6*fltlen-2(r1)  ;move some words some distance
	jmp	@(r4)+
;
;	mspr1 is a polish routine that transfers the top 2 wds.
;	of the sp stack to the r1 stack
mspr1:	mov	(sp)+,-(r1)
	mov	(sp)+,-(r1)
	jmp	@(r4)+
;
	.endc
tan:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	movflt	(r1)+,-(sp)	;copy arg on sp stack
	fltpp	-(r1)		;back up on r1 stack
	jsr	pc,sinf		;get sin(x)
	movflt	(sp)+,-(r1)	;get back the copy
	jsr	pc,cosf		;get cos(x)
	jmp	divf		;tan(x)=sin(x)/cos(x)
	.sbttl	4-wd fl-pt transcendental routines

;	sqrt	the double precision square root function
;	calling sequence:
;	called with arg (4-word fl-pt no.) on the r1 stack
;		jsr	pc,sqrt
;		(return)
;	returns sqrt (4-wd fl-pt no.) on r1 stack
;
sqrt:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	tst	(r1)		;get high order argument
	bpl	dsqrt1		;br if argument positive
	bic	#100000,(r1)	;make it positive
	sqrerr			;signal error before continuing
dsqrt1:	beq	exitsq		;fast exitsq if zero
	.if	ndf	fpu
	mov	#4,-(sp)	;push iteration count
	mov	r1,r0		;back up the r1 pointer
	movflt	(r0)+,-(sp)	;store floater upside down
	clr	-(r0)		;use only high order parts first
	clr	-(r0)		;for faster add,divide
	mov	r1,r2		;save r1 backup
	jsr	pc,duplf	;duplicate arg
	asr	(r2)		;tamper with initial copy to
	ror	2(r2)		;form initial estimate
	add	#20100,(r2)
	clr	-(r1)		;copy est (with low-ord parts =0)
	clr	-(r1)		;to r1 stack
loop:	mov	14.(r1),-(r1)
	mov	14.(r1),-(r1)
	jsr	pc,divf		;x/e
	jsr	pc,addf		;x/e+e
	sub	#200,(r1)	;(x/e+e)/2
	dec	8.(sp)		;count loop
	beq	rtn2		;count exhausted, exitsq
	mov	sp,r0		;working version of stack pointer
	movflt	(r0)+,-(r1)	;copy full arg onto stack
	mov	14.(r1),-(r1)	;copy (full) est to r1 stack
	mov	14.(r1),-(r1)
	br	loop		;go around again
rtn2:	add	#10.,sp		;clean up sp stack
exitsq:	rts	pc		;return to caller
	.endc
	.if	df	fpu
	clr	-(sp)		;form initial estimate
	clr	-(sp)		;low-order parts are 0
	mov	2(r1),-(sp)	;tamper with copy of
	mov	(r1),-(sp)	;high-order
	asr	(sp)		;parts
	ror	2(sp)
	add	#20100,(sp)
	mov	#4,r0		;iteration count
	setd			;double precesion fp
	ldd	(sp)+,f0	;get initial estimate
	ldd	(r1)+,f2	;get x
;
loop:	ldd	f0,f1		;e=e'
	ldd	f2,f0		;x
	divd	f1,f0		;x/e
	addd	f1,f0		;x/e+e
	dec	r0		;count
	divd	#2.0,f0		;e'=(x/e+e)/2e
	bgt	loop		;loop
;
	std	f0,-(r1)	;move result to stack
exitsq:	rts	pc		;return to caller
	.endc
;	the log and log10 functions
;	calling sequence:
;	called with arg (4-word fl-pt no.) on r1 stack
;		jsr	pc,log	(or log10)
;		(return)
;	returns ln(arg) (or log10(arg)) (4-word fl-pt no.) on r1 stack
;
	.if	ndf	fpu
log:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
logf:	mov	(r1)+,r0	;save x in r0,r2,r3,(sp)
	ble	error2		;jump if not positive
	mov	(r1)+,r2
	mov	(r1)+,r3
	mov	(r1)+,r4
	cmp	r0,#040200	;is this log(1.000000)?
	bne	10$		;nope
	mov	r4,-(sp)	;might be
	bis	r3,(sp)
	bis	r2,(sp)+
	bne	10$		;but it isn't
	jmp	pushf0		;the log(1.0000000)=0.000000

10$:	mov	#147572,-(r1)	;push -1/2*ln(2)
	mov	#173721,-(r1)
	mov	#071027,-(r1)
	mov	#137661,-(r1)
	sub	#8.,r1		;push work space
	mov	r4,-(r1)	;push x
	mov	r3,-(r1)
	mov	r2,-(r1)
	mov	r0,-(r1)
	asl	(r1)+
	movb	-(r1),-(sp)	;get exponent
	movb	#200,(r1)	;transform x into (1/2,1)
	rorb	(r1)
	rorb	-(r1)
	mov	#157145,-(r1)	;push 1/2*root2
	mov	#031771,-(r1)
	mov	#002363,-(r1)
	mov	#040065,-(r1)
	mov	r4,-(r1)	;push modified x
	mov	r3,-(r1)
	mov	r2,-(r1)
	mov	14.(r1),-(r1)
	mov	#157145,-(r1)	;push 1/2*root2
	mov	#031771,-(r1)
	mov	#002363,-(r1)
	mov	#040065,-(r1)
	jsr	r4,$polsh	;enter polish mode
	.word	$sbd,up4,$add,$dvd
				;get (x-root2)/(x+root2)
	.word	dup4,dup4	;get three copies
	.word	$mld,poly4	;expand polynomial
	.word	const		;const. tab. pointer for poly4
	.word	$mld,$add
	.word	scale2,$id,pln2,$mld	;get ln(exp)
	.word	$add,logqz	;combine with fraction
				;and check if done
;
error2:	mov	r0,-(r1)	;fix up r1 stack
	logerr			;negative argument a bad scene
logqz:	rts	pc
;
scale2:	clr	-(r1)
	bisb	(sp)+,(r1)	;get exponent
	sub	#200,(r1)	;remove excess 128
	jmp	@(r4)+
;
pln2:	mov	#147572,-(r1)	;push ln(2)
	mov	#173721,-(r1)
	mov	#071027,-(r1)
	mov	#040061,-(r1)
	jmp	@(r4)+
;
log10:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	jsr	pc,logf
	mov	#024162,-(r1)	;push log10(e)
	mov	#124467,-(r1)
	mov	#055730,-(r1)
	mov	#037736,-(r1)
	jmp	mulf
;
	.endc
	.if	df	fpu
log10:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.iftf
	mov	pc,r4		;get non-zero as log10 flag
	br	logf1
log:
	.ift
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
logf:	clr	r4		;get 0 as log flag
logf1:	setd			;double precision fp
	seti			;short integers
	mov	#fcons0,r0	;pointer to constants
	ldd	(r1),f2		;get arg
	cfcc
	ble	error2		;jump if not positive
	cmpd	#1.0,f2		;is this log(1.000000000)?
	cfcc
	bne	10$		;nope
	clrd	f0		;yes, log(1.000000)=0.00000
	br	logout		;and exit

10$:	stexp	f2,r2		;get exponent of argument
	ldcid	r2,f3		;convert to fp for.
	muld	(r0)+,f3	;scale factor=exponent*ln(2)
	ldexp	#0,f2		;transform arg to(1/2,1)
;
	ldd	f2,f1		;
	subd	(r0),f2		;x-1/2*sqrt(2)
	addd	(r0)+,f1	;x+1/2*sqrt(2)
	divd	f1,f2		;w=(x-root2)/(x+root2)
	ldd	f2,f1		;
	muld	f1,f1		;y=w**2
;
	mov	#6,r2		;count constants for polynomial
	ldd	(r0)+,f0	;initialize accumulator
xpan0:	muld	f1,f0		;
	dec	r2		;count
	addd	(r0)+,f0	;f0:= y*f0 + c(i)
	bgt	xpan0		;loop
	muld	f2,f0		;
	addd	(r0)+,f0	;f0:= w*f0 - 1/2*ln(2)
	addd	f3,f0		;add scale factor for exponent
	tst	r4		;test log10 flag
	beq	logout		;
	muld	(r0),f0		;log10 = log*log10(e)
;
logout:	std	f0,(r1)		;move result to stack
	rts	pc		;exit
error2:	logerr			;log is infinite
	rts	pc		;exit
;	order-dependent constants for routine
; 	r0 points at current constant in fpu version
;
fcons0:	.word	040061,071027	;ln(2)
	.word	173721,147572	;
;
	.word	040065,002363	;1/2*sqrt(2)
	.word	031771,157145	;
	.endc
	.word	037455,106270	;.16948212488
	.word	157166,174770
;
	.word	037471,072731	;.1811136267967
	.word	137716,117115
;
	.word	037543,111153	;.22223823332791
	.word	060101,135465
;
	.word	037622,044436	;.2857140915904889
	.word	007306,063062
;
	.word	037714,146314	;.400000001206045365
	.word	153450,165773
;
	.word	040052,125252	;.6666666666633660894
	.word	125247,004643
;
	.word	040400,000000	;2.00000000000000261
	.word	000000,000057
	.if	ndf	fpu
const:	.word	7
	.endc
	.if	df	fpu
;	more order-dependent constants
;
	.word	137661,071027	;-1/2*ln(2)
	.word	173721,147572	;
;
	.word	037736,055730	;log10(e)
	.word	124467,024162	;
	.endc
;	the exp function
;	calling sequence:
;	called with arg (4-wd fl-pt no.) on r1 stack
;		jsr	pc,exp
;		(return)
;	returns e**arg (4-wd fl-pt no.) on r1 stack
;
exp:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
expf:	mov	(r1),r0		;get high order arg in r0
	.if	ndf	fpu
	mov	r0,-(sp)	;also save it on sp stack
	.endc
	bgt	pos1		;jump if +
	cmp	r0,#141662	;arg is -
	bhi	zero4		;jump if arg <88.7
	br	smtst		;jump to test small magnitude arg
pos1:	cmp	r0,#41660
	bhi	over5		;jump if arg >87
smtst:	asl	r0		;dump sign
	cmp	r0,#044142
	blos	one		;jump if arg magnitude <2**-60
	.if	ndf	fpu
	sub	#8.,r1		;move arg up to get work space
	mov	#16.,r2
	add	r1,r2
	mov	-(r2),-(r1)
	mov	-(r2),-(r1)
	mov	-(r2),-(r1)
	mov	-(r2),-(r1)
	mov	#013761,-(r1)	;push log2(e)
	mov	#024534,-(r1)
	mov	#125073,-(r1)
	mov	#40270,-(r1)
	jsr	r4,$polsh	;enter polish mode
	.word	$mld		;y=x*log2(e)
	.word	dup4
	.word	$di		;int(x*log2(e))
	.word	adjst
	.word	$id		;z=int(x*log2(e)),y>=0; z=z-1,y<0
	.word	$sbd
	.word	m16		;d=16*(x*log2(e)-float(z))
	.word	dup4		;2 copies
	.word	$di
	.word	dsave		;save integer part of 2**y
	.word	$id		;e=d-int(d)
	.word	$sbd,d16	;e/16
	.word	dup4,dup4	;get 3 copies
	.word	$mld		;e*e
	.word	unpol1
one:	mov	#40200,(r1)	;result is 1.
	br	z1
over5:
zero4:	experr			;can't do exponential
	clr	(r1)		;result is 0
z1:	clr	2(r1)
	clr	4(r1)
	clr	6(r1)
out3:	tst	(sp)+
	rts	pc
unpol1:	mov	(r1)+,r0	;pop e*e to registers
	mov	(r1)+,r2
	mov	(r1)+,r3
	mov	(r1)+,-(sp)
	mov	#033343,-(r1)	;push p0=7.213503410844819083
	mov	#015345,-(r1)
	mov	#152405,-(r1)
	mov	#040746,-(r1)
	mov	(sp),-(r1)	;push e*e
	mov	r3,-(r1)
	mov	r2,-(r1)
	mov	r0,-(r1)
	mov	#153703,-(r1)	;push p1=.057761135831801928
	mov	#153011,-(r1)
	mov	#113360,-(r1)
	mov	#037154,-(r1)
	mov	(sp)+,-(r1)	;push e*e (and pop sp)
	mov	r3,-(r1)
	mov	r2,-(r1)
	mov	r0,-(r1)
	mov	#171042,-(r1)	;push q0=20.8137711965230362973
	mov	#074433,-(r1)
	mov	#101232,-(r1)
	mov	#041246,-(r1)
	jsr	r4,$polsh
	.word	$add,aup	;a=e*e+q0 to work space
	.word	$mld,$add,$mld	;b=e*(e*e*p1+p0)
	.word	twice		;duplicate a and b
	.word	$add,up4	;a+b to work space
	.word	$sbd,$dvd	;(a+b)/(a-b)
	.word	scale		;apply scale factors
scale:	mov	#roots2+8.,-(sp)	;point to powers of 2
asr:	mov	(sp)+,r0
	asr	(sp)		;shift d
	bcc	nomult		;jump if bit is off
	mov	-(r0),-(r1)	;push 2**((2**n)*d/16)
	mov	-(r0),-(r1)
	mov	-(r0),-(r1)
	mov	-(r0),-(r1)
	mov	r0,-(sp)
	jsr	r4,$polsh
	.word	$mld,asr	;multiply by above factor and test
nomult:	beq	scale1
	sub	#8.,r0		;point to next power of 2
	mov	r0,-(sp)
	br	asr
scale1:	tst	(sp)+		;flush d
	mov	(sp)+,r0	;get z
	swab	r0
	clrb	r0		;make into exponent modifier
	asr	r0
	add	r0,(r1)		;apply to result
	bmi	over5		;jump if overflow
	br	out3
;
adjst:	tst	(sp)		;test x
	bge	artn		;jump if +
	dec	(r1)		;z=z-1
artn:	mov	(r1),-(sp)
	jmp	@(r4)+
;
m16:	add	#1000,(r1)	;16* stack item
	jmp	@(r4)+
;
d16:	sub	#1000,(r1)	;1/16*stack item
	bpl	d16r		;jump if no underflow
	clr	(r1)		;underflow=0
d16r:	jmp	@(r4)+
;
dsave:	mov	(r1),-(sp)	;save d as an integer
	jmp	@(r4)+
;
aup:	mov	#40.,r2		;move a to work space
	br	aabup
	mov	#24.,r2		;move a+b to work space
aabup:	add	r1,r2
	mov	(r1)+,(r2)+
	mov	(r1)+,(r2)+
	mov	(r1)+,(r2)+
	mov	(r1)+,(r2)
	jmp	@(r4)+
;
twice:	mov	#8.,r0		;eight items
tw1:	mov	14.(r1),-(r1)	;duplicate 2 doubles
	dec	r0
	bgt	tw1
	jmp	@(r4)+
;
	.word	040265,002363,031771,157145	;2**1/2
	.word	040230,033760,050615,134251	;2**1/4
	.word	040213,112701,161752,105727	;2**1/8
roots2:	.word	040205,125303,063714,044173	;2**1/16
	.endc
;
	.if	df	fpu
	setd			;double precision fp
	seti			;short integers
	mov	#fcons2,r0	;pointer to constants
	ldd	(r1)+,f2	;get argument
	modd	(r0)+,f2	;f2=fract(x*log2(e))
	stcdi	f3,r4		;z=int(x*log2(e))
	tstd	f2		;
	cfcc			;
	bge	m16		;test f2
	addd	#1.0,f2		;make f2 positive
	dec	r4		;and adjust z=z-1
;
m16:	modd	#16.0,f2	;f2=fract(16*(x*log2(e)-float(z)))
	stcdi	f3,r3		;d=int (16*(...
	divd	#16.0,f2	;e=f2/16
	ldd	f2,f3		;
	muld	f3,f3		;e*e
;
	ldd	f3,f1		;
	addd	(r0)+,f1	;a=e*e+q0
	muld	(r0)+,f3	;
	addd	(r0)+,f3	;
	muld	f2,f3		;b=(e*e*p1 + p0)*e
	ldd	f1,f0		;
	addd	f3,f0		;a+b
	subd	f3,f1		;a-b
	divd	f1,f0		;(a+b)/(a-b)
;
scale:	asr	r3		;shift d
	bcc	nomult		;
	muld	(r0)+,f0	;multiply by root of 2
	br	scale		;
nomult:	beq	scale1		;
	add	#8.,r0		;point to next root of 2
	br	scale		;
;
scale1:	std	f0,-(r1)	;move result to stack
	swab	r4		;convert z to exponent modifier
	clrb	r4		;
	asr	r4		;
	add	r4,(r1)		;apply to result
	bmi	over5		;jump if overflow
	rts	pc		;exit
;
one:	mov	#40200,(r1)	;result is 1.
	br	z1
over5:
zero4:	experr			;can't do exponential
	clr	(r1)		;result is 0
z1:	clr	2(r1)
	clr	4(r1)
	clr	6(r1)
	rts	pc		;exit
;
;	order-dependent constants
;	r0 points at next constant in fpu version
;
fcons2:	.word	40270,125073,024534,013761	;log2(e)
;
	.word	041246,101232,074433,171042	;q0
	.word	037154,113360,153011,153703	;p1
	.word	040746,152405,015345,033343	;p0
	.word	040205,125303,063714,044173	;2**1/16
	.word	040213,112701,161752,105727	;2**1/8
	.word	040230,033760,050615,134251	;2**1/4
	.word	040265,002363,031771,157145	;2**1/2
;
; this patch stops exp from running into garbage core
; if the integer part is too close to 1.
	.word	040400,0,0			;stupid dec programmers
	.endc
;	sin	cos	the double precision sin and cos
;	functions.
;	calling sequence:
;	called with arg (4-wd fl-pt no.) on r1 stack
;		jsr	pc,sin	(or cos)
;		(return)
;	returns sin or cos of arg (4-wd fl-pt no.) on r1 stack
;
sin:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.iftf
	br	sinf		;and do sine
cos:
	.ift
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	.if	ndf	fpu
cosf:	mov	#064302,-(r1)	;push pi/2
	mov	#121041,-(r1)
	mov	#007732,-(r1)
	mov	#040311,-(r1)
	jsr	r4,$polsh	;enter polish mode
	.word	$add,sinf	;cos(x)=sin(x+pi/2)
sinf:	clr	-(sp)		;make room for quadrant flag
	asl	(r1)		;clear sign and save it
	ror	(sp)		;in quadrant flag
	ror	(r1)
	cmp	(r1),#026000	;very small?
	blo	rtn3		;yes
	mov	#064302,-(r1)	;push 2*pi
	mov	#121041,-(r1)
	mov	#007732,-(r1)
	mov	#040711,-(r1)
	jsr	r4,$polsh	;enter polish mode
	.word	$dvd		;x/2pi
	.word	dup4		;2 copies
	.word	$dint		;int(x/2pi)
	.word	$sbd		;fract(x/2pi)
	.word	x4		;4*fract(x/2pi)
	.word	dup4		;2 copies
	.word	$dint		;int(4*fract(x/2pi))
	.word	quad		;save int(......)
	.word	$sbd		;y=fract(4*fract(x/2pi))
	.word	qset		;reduce y to (-1,1)
qsetre:	.word	dup4		;2 copies
	.word	dup4		;3 copies
	.word	$mld		;y*y
	.word	poly4		;push coefficients
	.word	consts		;const. tab. pointer for poly4
	.word	$mld		;calc y*poly(y*y)
	.word	rtn3
rtn3:	tst	(sp)+		;pop quadrant flag
	bge	rtn1		;jump if argument was +
	add	#100000,(r1)	;sin(-x)=-sin(x)
rtn1:	rts	pc		;back to caller
x4:	tst	(r1)		;check for 0 fraction
	beq	rtn3		;quit now
	incb	1(r1)		;quadruple stack item
	jmp	@(r4)+
;
quad:	bis	(r1),(sp)	;save quadrant number
	jmp	@(r4)+
;
qset:	tstb	(sp)		;test quadrant
	beq	q13		;jump if first or third quad
	tst	(r1)		;if it's zero
	beq	qset1		;then don't negate it
	add	#100000,(r1)	;negate stack item
qset1:	clr	-(r1)
	clr	-(r1)
	clr	-(r1)		;push a floating 1.
	mov	#40200,-(r1)
	jsr	r4,$polsh	;enter polish
	.word	$add,qsetr	;x=1.-x
qsetr:	mov	#qsetre,r4	;point back into list
q13:	asrb	1(sp)		;test quadrant
	bcc	qout		;jump if first or second
	tst	(r1)		;if it's zero
	beq	qout		;then don't negate it
	add	#100000,(r1)	;negate stack item
qout:	jmp	@(r4)+
	.endc
;
	.if	df	fpu
cosf:	setd			;double precision fp
	ldd	(r1)+,f0	;get argument
	addd	piov2,f0	;cos(x)=sin(x+pi/2)
	br	sincos		;
sinf:	setd			;double precision fp
	ldd	(r1)+,f0	;get argument
sincos:	seti			;short integers
	mov	#fconst,r0	;pointer to constants
	cfcc			;get sign of arg
	sxt	r4		;set sign flag accordingly
	absd	f0		;remove argument sign
	cmpd	#026000,f0	;too small?
	cfcc
	blt	rtnx		;yes
	divd	(r0)+,f0	;x/2pi
	modd	#1.0,f0		;f0= fract(x/2pi)
	cfcc
	beq	rtn3		;exit on 0 fraction
	modd	#4.0,f0		;f0= fract(4*fract(x/2pi))
	stcdi	f1,r2		;quad= int(4*fract(x/2pi))
	ror	r2		;
	bcc	q13		;jump if first or third quad
	negd	f0		;
	addd	#1.0,f0		;y=1.0-x
q13:	ror	r2		;
	bcc	q12		;jump if first or 2nd quad
	negd	f0		;y = -y
;
q12:	ldd	f0,f2		;
	muld	f2,f2		;z=y**2
	mov	#8.,r2		;count of constants for polynomial
	ldd	(r0)+,f1	;initialize accumulator
xpand:	muld	f2,f1		;
	dec	r2		;count
	addd	(r0)+,f1	;f1:= z:f1 + c(i)
	bgt	xpand		;loop
;
	muld	f1,f0		;f0:= y*f1
rtnx:	tst	r4		;test sign flag
	beq	rtn3		;
	negd	f0		;sin(-x) = -sin(x)
rtn3:	std	f0,-(r1)	;move result to stack
	rts	pc		;exit
;
piov2:	.word	040311,007732	;pi/2
	.word	121041,064302	;
;
;	order-dependent constants
;
fconst:	.word	040711,007732	;2*pi
	.word	121041,064302	;
	.endc
	.word	026716,106703	;.587061098171e-11
	.word	045277,146362
;
	.word	130467,136273	;-.66843217206396e-9
	.word	103054,123153
;
	.word	032164,074657	;.5692134872719023e-7
	.word	047254,154742
;
	.word	133561,101646	;-.3598843007208693e-5
	.word	167216,134016
;
	.word	035050,036032	;.1604411847068221e-3
	.word	041214,103131
;
	.word	136231,064546	;-.4681754135302643e-2
	.word	071423,125024
;
	.word	037243,032743	;.7969262624616544e-1
	.word	035655,051557
;
	.word	140045,056747	;-.6459640975062462
	.word	030455,171222
;
	.word	040311,007732	;1.570796326794897
	.word	121041,064302
;
	.if	ndf	fpu
consts:	.word	9.
	.endc
;	the atan function
;	calling sequence for atan:
;	called with arg (4-wd fl-pt no.) on r1 stack
;		jsr	pc,atan
;		(return)
;	returns arctan(arg) (4-wd fl-pt no.) on r1 stack
;
atan:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	.if	ndf	fpu
	clr	-(sp)		;clear sign flag
	clr	-(sp)		;clear quadrant bias
	clr	-(sp)
	clr	-(sp)
	clr	-(sp)
	tst	(r1)		;test x
	bge	plusqz		;jump if quadrant 1 or 3
	add	#100000,(r1)	;get abs value 
	inc	10(sp)		;flag -
plusqz:	mov	r1,r0		;working copy of r1 pointer
	cmp	(r0)+,#40200	;check if <1.
	blo	le1		;jump if <1.
	bgt	gt1		;>1.
	tst	(r0)+		;check low order
	bne	gt1
	tst	(r0)+
	bne	gt1
	tst	(r0)+
	beq	le1		;=1.
gt1:	mov	sp,r0		;working copy of r1 stack pointer
	mov	#064301,(r0)+	;-pi/2
	mov	#121041,(r0)+	;atan(x)=pi/2-atan(1/x)
	mov	#007732,(r0)+
	mov	#140311,(r0)+
	dec	10(sp)		;adjust sign
	mov	r1,r2
	jsr	pc,duplf	;duplicate argument
	mov	#40200,(r2)+	;insert 1.
	clr	(r2)+
	clr	(r2)+
	clr	(r2)+
	jsr	pc,divf
le1:	mov	r1,r2
	jsr	pc,duplf
	clr	(r2)+		;insert a 0.
	clr	(r2)+
	clr	(r2)+
	clr	(r2)+
	mov	r1,r0
	cmp	(r0)+,#037611	;tan(15)
	blo	lt15		;jump if less than tan(15)
	bhi	trans		;jump if >
	cmp	(r0)+,#030242	;check low order
	bhi	trans
	blo	lt15
	cmp	(r0)+,#172366
	bhi	trans
	blo	lt15
	cmp	(r0)+,#065261
	blos	lt15		;jump if =
trans:	mov	#115454,-(r2)	;insert pi/6
	mov	#140553,-(r2)
	mov	#005221,-(r2)
	mov	#040006,-(r2)
	mov	-(r2),r4
	mov	-(r2),r3
	mov	-(r2),r2
	mov	(r1),r0
	mov	#062524,-(r1)	;push -root3
	mov	#041302,-(r1)
	mov	#131727,-(r1)
	mov	#140335,-(r1)
	mov	r4,-(r1)	;push arg
	mov	r3,-(r1)
	mov	r2,-(r1)
	mov	r0,-(r1)
	clr	-(r1)		;push 1
	clr	-(r1)
	clr	-(r1)
	mov	#40200,-(r1)
	mov	#062524,-(r1)	;push root3
	mov	#041302,-(r1)
	mov	#131727,-(r1)
	mov	#040335,-(r1)
	mov	r4,-(r1)	;push arg
	mov	r3,-(r1)
	mov	r2,-(r1)
	mov	r0,-(r1)
	jsr	r4,$polsh	;transform arg
;		(root3*x-1)/(root3 +x)
	.word	$mld,$sbd,up4,$sbd,$dvd,lt15
lt15:	jsr	r4,$polsh
	.word	dup4,dup4,$mld	;get arg**2
	.word	poly4		;expand polynomial
	.word	const1		;const. tab. pointer for poly4
	.word	$mld,$add,mspr1,mspr1
	.word	$add		;p(x)+0 if x<=1, p(x)-pi/2 if x>1
	.word	sign3		;adjust sign 
	.word	exit2
exit2:	rts	pc		;return to user
;
sign3:	tst	(sp)+		;check sign flag
	beq	sign1
	add	#100000,(r1)	;negate result for (-1,0) & (1,inf)
sign1:	jmp	@(r4)+
;
	.endc
	.if	df	fpu
	setd			;set dp mode for fpu
	clrd	f3		;clear atan2 bias
	ldd	(r1)+,f0	;get argument
	clr	r4		;clear sign flag
	cfcc			;get sign of argument
	std	f3,f5		;f5=atan2 bias
	clrd	f3		;clear quadrant bias
	bge	plusqz		;jump if quadrant 1 or 3
	absd	f0		;abs(x)
	inc	r4		;flag -
plusqz:	ldd	#1.0,f1		;1.0
	cmpd	f0,f1		;check if x<=1.0
	cfcc
	ble	le1		;
	dec	r4		;x>1.0, adjust sign flag
	divd	f0,f1		;1.0/x
	ldd	f1,f0		;atan(x)=pi/2-atan(1/x)
	ldd	pi2,f3		;quadrant bias=pi/2
le1:	std	f3,f4		;f4=quadrant bias
	clrd	f3		;f3=0,0
	cmpd	tan15,f0	;compare tan(15) : x
	cfcc
	bge	lt15		;x<= tan(15)
	ldd	pi6,f3		;f3=pi/6
	ldd	f0,f1		;
	muld	root3,f0	;
	subd	#1.0,f0		;x*root3-1.0
	addd	root3,f1	;x+root3
	divd	f1,f0		;(x*root3-1.0)/(x+root3)
;
lt15:	ldd	f0,f2		;x
	muld	f0,f0		;x**2
	mov	#fcons1,r0	;pointer to polynomial constants
	mov	#8.,r2		;count of coefficients
	ldd	(r0)+,f1	;initialize accumulator
xpand1:	muld	f0,f1		;
	dec	r2		;count
	addd	(r0)+,f1	;f1:= f1* x**2 + c(i)
	bgt	xpand1		;loop
	muld	f2,f1		;f1:= f1*x
	addd	f3,f1		;pi/6 or 0.0
	subd	f4,f1		;p(x)-quad bias
	tst	r4		;test sign flag
	beq	sign1		;no adjustment
	negd	f1		;negate result for (-1,0)&(1,inf)
sign1:	addd	f5,f1		;atan2 bias
;
	std	f1,-(r1)	;move result to stack
	rts	pc		;exit
;
;
pi:	.word	040511,007732	;pi
	.word	121041,064301	;
;
pi2:	.word	040311,007732	;pi/2
	.word	121041,064301	;
;
tan15:	.word	037611,030242	;tan(15)
	.word	172366,065261	;
;
pi6:	.word	040006,005221	;pi/6
	.word	140553,115454	;
;
root3:	.word	040335,131727	;
	.word	041302,062524	;
	.endc
fcons1:	.word	037065,150707	;.0443895157187
	.word	162300,163030
;
	.word	137204,143233	;-.06483193510303
	.word	004010,000413
;
	.word	037235,043002	;.0767936896066
	.word	027154,142446
;
	.word	137272,025671	;-.0909037114191074
	.word	116412,065630
;
	.word	037343,107047	;.11111097898051048
	.word	023625,025401
;
	.word	137422,044444	;-.14285714102825545
	.word	071335,116151
;
	.word	037514,146314	;.19999999998729448
	.word	146224,165650
;
	.word	137652,125252	;-.33333333333329930
	.word	125252,113602
;
	.word	040200,000000	;.999999999999999
	.word	000000,000000
	.if	ndf	fpu
const1:	.word	9.
	.endc
