#
/*
 *	ianj sep 77
 *
 *	when invoked (only by super-user) will signal all
 *	processes with a '14' (terminate) this will cause
 *	system to shutdown - nicely. only processes not
 *	killed are 0,1,parent and self.  init will loop
 *	waiting for shells to terminate - no restart at all.
 *	parent (presumably shell) can do as wishes.  the
 *	parent can then kill off any remaining processes.
 *	when all shells are dead init will exit - leaving
 *	only process 0 active.
 */

#include <param.h>
#include <proc.h>
struct proc proc[NPROC];

main()
{
	register i;	register struct proc *p;
	register unsigned pid,ppid,maxpid;
	int nproc;

	pid = getpid();	/* my process id */
	maxpid = 0;	/* limit for currently active processes */
	nproc = gprocs(proc);

	for(p = &proc[0]; p <= &proc[nproc] ; p++ ) {
		if( p->p_stat == 0 ) continue;
		if( p->p_pid == pid ) ppid = p->p_ppid;
		if( p->p_pid > maxpid ) maxpid = p->p_pid;
	}

	kill(1, SIGTERMINATE);	/* tell init about shutdown */

	/* scan proc array thrice */
	/* kill -14 all but 0,1,pid,ppid first time thru */
	/* on second and third pass only kill new processes (>maxpid) */

	for(i=0;i<3;i++) {
		sleep(1);
		if( i>0 ) nproc = gprocs(proc);
		for(p = &proc[2]; p <= &proc[nproc] ; p++ ) {
			if( p->p_stat == 0 ) continue;
			if( (i>0) && (maxpid>=p->p_pid) ) continue;
			if( (p->p_pid==pid) || (p->p_pid==ppid) ) continue;
			kill( p->p_pid , SIGTERMINATE);
		}
	}
	execl("/bin/ps","ps","zxal",0);
	write(2,"exec ps failed\n",15);
}
