#

/*
 *	TRANSFORMATION MODULE OF GPAC
 */

#include "../gpac.h"
#include "../error_codes.h"

posttranslate(dx, dy)
	double dx, dy;
	{

	Gctm_pu++;
	Gctm_mod++;
	Gctmc =+ Gctma*dx +Gctmb*dy;
	Gctmf =+ Gctmd*dx+Gctme*dy;
	GOOD_RETURN;
	}


postscale(sx, sy)
	double sx, sy;
	{

	if(sx <= 0.0 || sy <= 0.0)
		return(Gerror(SCALE_INVAL, sx, sy));
	Gctm_pu++;
	Gctm_mod++;
	Gctma =* sx;
	Gctmb =* sy;
	Gctmd =* sx;
	Gctme =* sy;
	GOOD_RETURN;
	}


postrotate(angle)
	double angle;
	{
	double sa, ca, t;
	double sin(), cos();

	Gctm_pu++;
	Gctm_mod++;
	sa = sin(angle);
	ca = cos(angle);

	t = Gctma*ca+Gctmb*sa;
	Gctmb = Gctmb*ca-Gctma*sa;
	Gctma = t;

	t = Gctmd*ca+Gctme*sa;
	Gctme = Gctme*ca-Gctmd*sa;
	Gctmd = t;

	GOOD_RETURN;
	}
