#

/*
 *	memory management module
 */

#include "../gpac.h"
#include "../error_codes.h"


struct blk
	{
	int size;
	struct blk *fptr;
	struct blk *bkptr;
	};

extern struct blk *Gavail;


Gstatm(flag)
	int flag;
	{
	register struct blk *bblk;
	register nwords;

	if(Gmem_status == CORE_FULL)
		{
		printf("CORE FULL\n");
		return;
		}
	bblk = Gavail.fptr;
	nwords = 0;
	if(flag)
		printf("  SIZE    FPTR   BKPTR\n");
	while(bblk != &Gavail)
		{
		nwords =- bblk->size;
		if(flag)
			printf("%6o  %6o  %6o\n", -bblk->size, bblk->fptr, bblk->bkptr);
		bblk = bblk->fptr;
		}
	printf("\nTOTAL WORDS %o\n", nwords);
	return(nwords);
	}
