#


#include "../gpac.h"
#include "../error_codes.h"

#define GNULL           0
#define GENDREC         1
#define GGOPEN          2
#define GGCLOSE         3
#define GAPPEND         4
#define GDELETE         5
#define GPOST           6
#define GUNPOST         7
#define GCHARS          8
#define GINTENS         9
#define GPOINT          10
#define GLINETO         11
#define GMOVETO         12
#define GLINE           13
#define GMOVE           14
#define GSCHARS		15
interp(file) char *file;
{
	int file_in;
	char buf[512];
	register char *bufptr;
	register int bytes;
	register float *floatarg;
	if((file_in=open(file,0)) == -1)
	{
		return(Gerror(OPEN_ERR, "interp", file));
	}
	bytes = read(file_in,buf,512);
	while(bytes)
	{
		if(bytes == -1)
		{
			return(Gerror(READ_ERR, "interp"));
		}
		bufptr = buf;
		while(bufptr < &buf[bytes])
		{
			switch(*bufptr++)
			{

			 case GNULL:
				continue;

			 case GENDREC:
				goto READ_NEXT;

			 case GGOPEN:
				gopen(*bufptr++);
				continue;

			 case GGCLOSE:
				gclose();
				continue;

			 case GAPPEND:
				append(*bufptr++);
				continue;

			 case GDELETE:
				delete(*bufptr++);
				continue;

			 case GPOST:
				post(*bufptr++);
				continue;

			 case GUNPOST:
				unpost(*bufptr++);
				continue;

			 case GINTENS:
				intens(*bufptr++);
				continue;

			 case GCHARS:
				chars(bufptr);
				while(*bufptr++);
				continue;

			 case GLINETO:
				floatarg = bufptr;
				lineto(floatarg[0],floatarg[1]);
				bufptr = &floatarg[2];
				continue;

			 case GMOVETO:
				floatarg = bufptr;
				moveto(floatarg[0],floatarg[1]);
				bufptr = &floatarg[2];
				continue;

			 case GLINE:
				floatarg = bufptr;
				line(floatarg[0],floatarg[1]);
				bufptr = &floatarg[2];
				continue;

			 case GMOVE:
				floatarg = bufptr;
				move(floatarg[0],floatarg[1]);
				bufptr = &floatarg[2];
				continue;

			 case GPOINT:
				floatarg = bufptr;
				point(floatarg[0],floatarg[1]);
				bufptr = &floatarg[2];
				continue;

			case GSCHARS:
				schars(*bufptr,bufptr+1);
				bufptr++;
				while(*bufptr++);
				continue;
			}
		}
READ_NEXT:
		bytes = read(file_in,buf,512);
	}
	close(file_in);
	GOOD_RETURN;
}
