#
/*
 *	scanf - the reciprocal of printf and more.
 */

/*
 *	Tom Horsley, University of Toronto, Jan 1976.
 */

int _nextarg;
int **_argp;

char _jumptab[128];

#define SKIP	4
#define EOF	5

char _skipchars[] " \t\n";
char *_fmt;
char _ungot;


scanf(format, arg)
{
	register char cur;
	register char nextc;

	_fmt= format;
	_nextarg= 0;
	_argp= &arg;
	_jumptab[0]= EOF;
	_post(_skipchars, SKIP);

	for(;;)
		switch(cur= _nextfmt())
		{

		 case 0:
			return(0);

		 case ' ':

		 case '\t':

		 case '\n':
			break;

		 case '%':
			if(_specanal() == -1)
				if(_nextarg)
					return(_nextarg);
				else
					return(-1);
			break;

		 default:
			if((nextc= _getch()) != cur)
			{
				_ungot= nextc;
				return(-_nextarg-1);
			}
			break;
		}
}


_nextfmt()
{
	register cur;

	cur= *_fmt++;
	if(cur == '\\')
	{
		cur= *_fmt++;
		if(cur == 'n')
			cur= '\n';
		else if(cur == 't')
			cur= '\t';
		else if(cur == '0')
			cur= '\0';
	}
	return(cur);
}


char _leftjust;
char _doit;
int _width;

char _floatc[] "0123456789-+eE.";
char _fixedc[] "0123456789+-";
char _octalc[] "01234567";


_specanal()
{
	register cur;
	register char skipnum;

	_leftjust= 0;
	skipnum= 0;
	_width= -1;
	_doit= 1;

	for(;;)
		switch(cur= _nextfmt())
		{

		 case '-':
			_leftjust= 1;
			break;

		 case '*':
			_doit= 0;
			break;

		 case '0':

		 case '1':

		 case '2':

		 case '3':

		 case '4':

		 case '5':

		 case '6':

		 case '7':

		 case '8':

		 case '9':
			if(skipnum)
				break;
			_width= atoi(_fmt-1);
			skipnum++;
			break;

		 case '.':
			skipnum++;
			break;

		 case '[':
			return(_group());

		 case 'e':

		 case 'f':
			return(_number(_floatc, 'f'));

		 case 'l':

		 case 'd':
			return(_number(_fixedc, 'd'));

		 case 'o':
			return(_number(_octalc, 'o'));

		 case 's':
			return(_string());

		 case 'c':
			return(_charac());

		 default:
			_nextarg= -_nextarg -1;
			return(-1);
		}

}


#define NOOP	0
#define ZERO	1
#define KEEP	2
#define ABORT	3
#define SKIP	4
#define EOF	5



_select(buf, mode)
	char *buf;
{
	register num;
	register char cur;
	register stage;

	stage= _leftjust;
	num= 0;

	while(_width--)
	{
		cur= _getch();
		switch(_jumptab[cur])
		{

		 case ZERO:
			cur= '0';
			goto keep;

		 case EOF:
			return(num);

		 case SKIP:
			if(stage)
				stage++;
			break;

		 case NOOP:
			if(mode == KEEP)
				goto abort;
			else
				goto keep;

		 case ABORT:

		 abort:
			if(_width < 0)
			{
				_ungot= cur;
				return(num);
			}
			num= 0;
			stage= 2;
			break;

		 case KEEP:

		 keep:
			if(stage == 0)
				stage++;
			if(stage>1)
				num= 0;
			else
			{
				if(_doit)
					*buf++= cur;
				num++;
			}
			break;
		}
		if(stage>1 && _width < 0)
			goto abort;
	}
	return(num);
}


_post(strng, value)
{
	register char *string;
	register char cur;
	register val;

	string= strng;
	val= value;

	while(cur= *string++)
		_jumptab[cur]= val;
}




_getch()
{
	register char val;

	if(val= _ungot)
	{
		_ungot= 0;
		return(val);
	}
	else
		return(getchar());
}




_group()
{
	register cur;
	int num;
	char skipees[128];
	char mode;
	register char *skip;
	char *st;

	skip= skipees;

	if(_leftjust && _width>0)
		_post(_skipchars, NOOP);
	while((cur= _nextfmt())!= ']' && cur)
		*skip++= cur;
	*skip= 0;
	if(skipees[0] == '^')
	{
		_post(_skipchars, NOOP);
		_post(&skipees[1], ABORT);
		num= _select(_argp[_nextarg], NOOP);
	}
	else
	{
		_post(&skipees[0], KEEP);
		num= _select(_argp[_nextarg], KEEP);
	}
	_post(&skipees[0], NOOP);
	_post(_skipchars, SKIP);
	if(num == 0)
		return(-1);
	if(_doit)
	{
		st= _argp[_nextarg++];
		st[num]= 0;
	}
	return(0);
}





_number(keepers, type)
{
	register num;
	char numbuf[40];
	if(_leftjust && _width>0)
		_post(_skipchars, ZERO);
	_post(keepers, KEEP);
	num= _select(numbuf, KEEP);
	_post(keepers, NOOP);
	_post(_skipchars, SKIP);
	if(num==0)
		return(-1);
	numbuf[num]= 0;
	if(_doit)
		if(type == 'd')
			*_argp[_nextarg++]= atoi(numbuf);
		else if(type == 'f')
			_floater(numbuf);
		else
			_octal(numbuf);
	return(0);
}


_floater(string)
{
	register float *fnum;
	extern double atof();

	fnum= _argp[_nextarg++];
	*fnum= atof(string);
}



_octal(string)
{
	register onum;
	register char *c;

	onum= 0;
	c= string;
	while(*c)
	{
		onum=<< 3;
		onum=+ (*c++ - '0');
	}
	*(_argp[_nextarg++]) = onum;
}

_string()
{
	register num;
	register char *st;

	if(_leftjust && _width>0)
		_post(_skipchars, NOOP);
	num= _select(_argp[_nextarg], NOOP);
	_post(_skipchars, SKIP);
	if(num == 0)
		return(-1);
	if(_doit)
	{
		st= _argp[_nextarg++];
		st[num]= 0;
	}
	return(0);
}


_charac()
{
	register char *c;
	register char ch;

	ch= _getch();
	if(ch == 0)
		return(-1);
	if(_doit)
	{
		c= _argp[_nextarg++];
		*c= ch;
	}
	return(0);
}
