#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tab.h"

track(n)
	char n;
	{
	int arg[3];
	int rest[5];
	register i;

	valid_segment;
	TAB_OPEN(track);
	if(Gseg_table[n].start_address == 0)
		return(Gerror(NOEXIST_ERR, "track", n));
	arg[0] = TRACK;
	arg[1] = GW;
	arg[2] = rest;
	rest[0] = rest[2] = Gseg_table[n].start_address;
	i  = Gseg_table[n].end_address;
	rest[1] = GW_JUMP | i;
	rest[3] = (rest[0]+4) | GW_XQT;
	rest[4] = rest[0]+6;
	if(Gtablet.trk_seg)
		unpost(Gtablet.trk_seg);
	if(Gstty(Gtablet.fd, arg) < 0)
		perror("tablet");
	Gtablet.trk_seg = n;
	GOOD_RETURN;
	}


untrack()
	{
	int arg[3];

	TAB_OPEN(untrack);
	if(Gtablet.trk_seg != 0)
		{
		arg[0] = UNTRACK;
		arg[1] = GW;
		Gstty(Gtablet.fd, arg);
		unpost(Gtablet.trk_seg);
		Gtablet.trk_seg = 0;
		}
	}


