#
/*
 | Definitions for the
 |	Interactive Graphics Package
*/
/*~L
module name:
	glib.h

function:
	definitions of constants and globals for the
	interactive graphics package.

globals contained:
	g_tab	- graphic segment records are entries here.
	g_count	- number of currently defined segments.
	g_head	- index (in g_tab) of 1st display segment.
	g_tail	- index of last display segment in the display cycle.
	g_free	- next free slot in display file.

modules referencing:
	Any module defining a routine in the package.

history:
	Written Jan 1978 by Avi Licht.

~L */


/*
 | Segment structure definitions
*/

/* "user" options */
#define O_VIS	040000	/* segment visiable ? */
#define O_ITAL	010000	/* italics ? */
#define O_INT	002000	/* intensity */
#define O_LP	000100	/* light-pen sensitive ? */
#define O_BLK	000020	/* blink ? */
#define O_LINE	000004	/* line type */

#define VIS	060000	/* visible segment */
#define INV	040000	/* invisible */
#define ITAL	014000	/* italics on */
#define NOITAL	010000	/* italics off */
#define INT0	002000	/* intensity 0 */
#define INT1	002200
#define INT2	002400
#define INT3	002600
#define INT4	003000
#define INT5	003200
#define INT6	003400
#define INT7	003600	/* intensity 7 */
#define LPON	000140	/* light-pen on */
#define LPOFF	000100	/* light-pen off */
#define BLKON	000030	/* blink on */
#define BLKOFF	000020	/* blink off */
#define LINE0	000004	/* solid line */
#define LINE1	000005	/* long dash */
#define LINE2	000006	/* short dash */
#define LINE3	000007	/* dot dash */

/* options for menhit */
#define M_NBLK -1	/* dont blink on menu hit*/
#define M_UBLK -2	/* stop the blinking of the menu */

/* segment flags */
#define S_USED	01	/* slot-in-use marker */
#define S_LINK	02	/* linked-segment marker */
#define S_NUM	010	/* number-segment marker */
#define S_COMP	040	/* compound segment */
#define S_MENU	0100	/* menu segment */

/*
 | Segemnt table element
*/
struct g_seg {
	int g_start;	/* starting address in display file */
	int g_end;	/* last address */
	int g_line;	/* address of line section */
	int g_pnt;	/* address of points section */
	int g_char;	/* address of text section */
	/* display-cycle links */
	char g_prev;	/* table index of previous segment */
	char g_next;	/* table index of next segment */
	int g_stat;	/* segment status : (see flags above) */
};

#define MAXSEG	100	/* max number of segments */
struct g_seg g_tab[MAXSEG];	/* segment table */

/*
 | globals
*/
int g_count;		/* number of used slots in segment table */
int g_head;		/* list head ( 1st segment ) */
int g_tail;		/* last segment in list */
int g_free;		/* 1st free slot in display file */
int g_sda;		/* virtual address of the sda */
int *g_file;		/* display file virtual address */
int *g_max;		/* display file last index */
int g_rfile;		/* display file physical address */
int g_p;		/* display file insertion pointer
			   used by put put2 put3 */
int g_fdesc;		/* vt file descriptor */

/*
 | Dummy structure for byte access
 */
struct {
	char low;
	char high;
};
/*
 | change data in d file
 | CAUTION!!!!!
 | use only to change data, or else.
 | i is an index in d file
 */
#define gschange(i,w) g_file[i] = w
