#

#include <stdio.h>

#define	MEMSIZE	040000	/* max. no. of bytes */
#define	SEGS	40	/* no. of memory segments */
#define	DFLTLOAD load7

#define	LIBRARY	"/usr/lib/gt40/"
#define	ODTFILE	"/usr/lib/gtl.odtgt"	/* odt is kept here */

char	*file;

int	oldtty[4];		/*
				 * buffer to store old tty status
				 * ready for restoration
				 */
int	tty6[4];
int	tty8[4];

struct	seg {
	char	*m_loadr;		/* memory address */
	char	*m_hiadr;		/* address of next bytes */
	} seg[SEGS];

char	mem[MEMSIZE];
char	*startadr;		/* starting address of program */

char	odtflag;		/* load debugger with program */

/*
 * 6, 7, or 8 for:
 * 6:	normal gt40 loader
 * 7:	load an 8 bit loader using
 *	the 6-bit loader; then load
 *	the program using the 8-bit
 *	loader
 * 8:	anticipated inclusion of
 *	builtin 8-bit loader
 */
char	load6;
char	load7;
char	load8;

char	rawflag;	/* suppress checking of memory conflicts */

char	listflag;		/* listing of gt40 library */
char	helpflag;		/* extra level of help */

char	absfmt;			/* absolute loader format file */
				/* else: a.out format */
char	nottty;			/* output file is not tty! */

int	checksum;

/* header portion of odt's file */
struct {
	int	odt_magic;	/* magic number */
	char	*odt_beg;	/* low-end address */
	char	*odt_siz;	/* size of odt */
	int	odt_1pad;
	int	odt_2pad;
	char	*odt_start;	/* start address of odt */
	char	*odt_pc;	/* position with odt for user's start address */
	int	odt_pad;
	} odthdr;

int	aouthdr[8]; 		/* header portion of a.out file */


/*
 * character sequences used to initiate loading with the terminals
 */
char	init6[];
char	init8[];

char	pauseflag;	/*
			 * pause before commencing load so as
			 * to allow the user to read the
			 * warning message(s).
			 */
