#
/*
 * RJP04 driver
 * PRELIMINARY *
 */


#include "../param.h"
#include "../buf.h"
#include "../conf.h"
#include "../user.h"

struct {
	int	hpcs1;	/* Control and Status register 1 */
	int	hpwc;	/* Word count register */
	int	hpba;	/* UNIBUS address register */
	int	hpda;	/* Desired address register */
	int	hpcs2;	/* Control and Status register 2*/
	int	hpds;	/* Drive Status */
	int	hper1;	/* Error register 1 */
	int	hpas;	/* Attention Summary */
	int	hpla;	/* Look ahead */
	int	hpdb;	/* Data buffer */
	int	hpmr;	/* Maintenance register */
	int	hpdt;	/* Drive type */
	int	hpsn;	/* Serial number */
	int	hpof;	/* Offset register */
	int	hpdc;	/* Desired Cylinder address register*/
	int	hpcc;	/* Current Cylinder */
	int	hper2;	/* Error register 2 */
	int	hper3;	/* Error register 3 */
	int	hpec1;	/* Burst error bit position */
	int	hpec2;	/* Burst error bit pattern */
	int	hpbae;	/* Bus address extension */
	int	hpcs3;	/* Control and status register 3 */
};

#define	HPADDR	0176700
#define	NHP	8

struct {
	char	*nblocks;
	int	cyloff;
} hp_sizes[] {
	11286,	0,		/* cyl 0 thru 26 */
	53504,	27,		/* cyl 27 thru 154 */
	53504,	155,		/* cyl 155 thru 282 */
	53504,	283,		/* cyl 283 thru 410 */
	65535,	27,		/* cyl 27 thru 183 */
	65535,	184,		/* cyl 184 thru 340 */
	29260,	341,		/* cyl 341 thru 410 */
	40600,	300,
};


struct	devtab	hptab;
struct	devtab	hputab[NHP];
struct	buf	hpbuf;
char	hpstatus[NHP];
int	hpsioc[NHP];
int	hpsios[NHP];

int	ghper1, ghper2, ghper3, ghpds, ghpcs2;

			/* Drive Commands */
#define	GO	01
#define	UNLOAD	02
#define	SEEK	04
#define DCLR	010
#define	RELEASE	012
#define	PRESET	020
#define	SEARCH	030

#define	ERR	040000	/* hpds - Error */
#define	MOL	010000	/* hpds - Medium online */
#define	DRY	0200	/* hpds - drive ready */
#define VV	0100	/* hpds - volume valid */
#define SC	0100000	/* hpcs1 - Special condition */
#define	TRE	040000	/* hpcs1 - transfer error */
#define DVA	04000	/* hpcs1 - drive available */
#define	IE	0100	/* hpcs1 - interrupt enable */
#define	NED	010000	/* hpcs2 - Nonexistent drive */
#define	WLE	04000	/* hper1 - Write lock error */
#define FMT22	010000	/* hpof - 16 bit /word format */
#define	ECI	04000	/* hpof - ecc inhibit */
/*
 * Use av_back to save track+sector,
 * b_resid for cylinder.
 */

#define	trksec	av_back
#define	cylin	b_resid

hpstrategy(abp)
struct buf *abp;
{
	register struct buf *bp;
	register char *p1, *p2;
	struct devtab *dp;
	int	unit;

	bp = abp;
	p1 = &hp_sizes[bp->b_dev.d_minor&07];
	unit = bp->b_dev.d_minor>>3;
	if (unit >= NHP || hpstatus[unit] ||
	    bp->b_blkno >= p1->nblocks) {
		bp->b_flags =| B_ERROR;
		iodone(bp);
		return;
	}
	bp->av_forw = 0;
	bp->cylin = p1->cyloff;
	p1 = bp->b_blkno;
	p2 = lrem(p1, 22);
	p1 = ldiv(p1, 22);
	bp->trksec = (p1%19)<<8 | p2;
	bp->cylin =+ p1/19;
	spl5();
	dp = &hputab[unit];
	hpsioc[unit]++;
	if ((p1 = dp->d_actf)==0)
		dp->d_actf = bp;
	else {
		for (; p2 = p1->av_forw; p1 = p2) {
			if (p1->cylin <= bp->cylin
			 && bp->cylin <  p2->cylin
			 || p1->cylin >= bp->cylin
			 && bp->cylin >  p2->cylin) 
				break;
		}
		bp->av_forw = p2;
		p1->av_forw = bp;
	}
	if (dp->d_active==0)
		hpustart(unit);
	spl0();
}

hpustart(dev)
{
	register struct buf *bp;
	register struct devtab *dp;
	register unit;
	int	search;

	unit = dev;
	dp = &hputab[unit];
	HPADDR->hpcs2.lobyte = unit;
	HPADDR->hpas = 1<<unit;
	hpstatus[unit] = 0;
	if ((HPADDR->hpcs1&DVA)==0) {
	/* either NED or dual-port not avail */
		goto abort;
	}
	if ((HPADDR->hpds&MOL)==0)
		goto abort;
	if ((bp = dp->d_actf)==0)
		return;
	if (HPADDR->hpds&ERR) {
		printf("SE %d %o\n",unit,HPADDR->hper1);
		HPADDR->hpcs1.lobyte = IE|DCLR|GO;
		if (++dp->d_errcnt > 16) {
			printf("Unit %d unloaded\n",unit);
			HPADDR->hpcs1.lobyte = IE|UNLOAD|GO;
			goto abort;
		}
		dp->d_active--;
	}
	if ((HPADDR->hpds&VV) == 0) {
		HPADDR->hpcs1.lobyte = IE|PRESET|GO;
		HPADDR->hpof = FMT22|ECI;
	}
	dp->d_active++;
	HPADDR->hpdc = bp->cylin;
	search = bp->trksec.lobyte-(HPADDR->hpla>>6)-1;
	if (search<0) search =+ 22;
	if ((bp->cylin!=HPADDR->hpcc || search>6) &&
	    dp->d_active<3) {
		search = bp->trksec;
		search.lobyte =- 4;
		if (search.lobyte<0) search.lobyte =+ 22;
		hpsios[unit]++;
		HPADDR->hpda = search;
		HPADDR->hpcs1.lobyte = IE|SEARCH|GO;
	} else {
		dp->b_forw = 0;
		if (hptab.d_actf == 0)
			hptab.d_actf = dp; else
			hptab.d_actl->b_forw = dp;
		hptab.d_actl = dp;
		if (hptab.d_active == 0)
			hpstart();
	}
	return;
abort:
	hpstatus[unit]++;
	while(bp = dp->d_actf) {
		bp->b_flags =| B_ERROR;
		dp->d_actf = bp->av_forw;
		iodone(bp);
	}
	dp->d_active = 0;
	dp->d_errcnt = 0;
	printf("RP04 drive %d offline\n",unit);
}

hpstart()
{
	register struct buf *bp;
	register struct devtab *dp;

	if ((dp = hptab.d_actf) == 0)
		return;
	bp = dp->d_actf;
	HPADDR->hpcs2.lobyte = bp->b_dev.d_minor >> 3;
	hptab.d_active++;
	HPADDR->hpdc = bp->cylin;
	rhstart(bp, &HPADDR->hpda, bp->trksec, &HPADDR->hpbae);
}

hpintr()
{
	register struct buf *bp;
	register struct devtab *dp;
	register unit;

	if (hptab.d_active) {	/* data transfer underway */
	dp = hptab.d_actf;
	bp = dp->d_actf;
	unit = bp->b_dev.d_minor>>3;
	HPADDR->hpcs2.lobyte = unit;
	if (HPADDR->hpcs1 & TRE) {		/* error bit */
		deverror(bp, HPADDR->hper1, HPADDR->hpcs2);
		ghper1 = HPADDR->hper1;
		ghper2 = HPADDR->hper2;
		ghper3 = HPADDR->hper3;
		ghpds = HPADDR->hpds;
		ghpcs2 = HPADDR->hpcs2;
		HPADDR->hpcs1 = TRE|IE|DCLR|GO;
		if (++hptab.d_errcnt > 16 ||
		  ghper1&WLE ) {
			bp->b_flags =| B_ERROR;
		} else
			hptab.d_active = 0;
	}
	if (hptab.d_active) {
		hptab.d_active = 0;
		hptab.d_errcnt = 0;
		hptab.d_actf = dp->b_forw;
		dp->d_active = 0;
		dp->d_errcnt = 0;
		dp->d_actf = bp->av_forw;
		bp->b_resid = HPADDR->hpwc;
		iodone(bp);
		HPADDR->hpcs1 = IE|RELEASE|GO;
		hpustart(unit);
	}
	if (hptab.d_active==0)
		hpstart();
	} else
		HPADDR->hpcs1.hibyte = TRE>>8;
	for (unit=0; unit<NHP; unit++) {
		if (HPADDR->hpas&(1<<unit))
			hpustart(unit);
	}
	if ((HPADDR->hpcs1&IE)==0) {
		HPADDR->hpcs1 = IE;
		if (HPADDR->hpcs1&TRE)
			HPADDR->hpcs1.hibyte = TRE>>8;
	}
}

hpread(dev)
{

	if(hpphys(dev))
	physio(hpstrategy, &hpbuf, dev, B_READ);
}

hpwrite(dev)
{

	if(hpphys(dev))
	physio(hpstrategy, &hpbuf, dev, B_WRITE);
}

hpphys(dev)
{
	register c;

	c = u.u_offset >> 9 ;
	c =+ ldiv(u.u_count+511, 512);
	if(c > hp_sizes[dev.d_minor & 07].nblocks) {
		u.u_error = ENXIO;
		return(0);
	}
	return(1);
}
