#
/* Nijmegen addition to implement P and V system calls (sysent 45.)
*/

/*
        NSEM semaphores are supported, i.e a user program may be in NSEM
        critical sections concurrently.
        defined as tunable variable in param.h
        if not defined at all, no semaphore support is generated

        'EMFILE' error return for
        process does P while already in NSEM other critical sections,
        'EEXIST' for
        process managed to select non existing function (not P, V)
        'EEXIST' for
        process does P while it is in critical section already
        'EPERM' for
        process does V while it isn't in critical section at all


        user argument 0 is the function code (0 or 1)
        user argument 1 is the semaphore password

        proc table expanded with  int p_sem[NSEM]
        if a password is entered in one of these entries, the 
        process of that proc-table is in the critical section for       
        that password.

        other routines affected:
                sysent.c ( of course, to add system call )
                exit() in sys1.c to do V on all critical
                        sections occupied by exiting program.
*/
#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"

#ifdef SEMAPHORES
semaphore() {
        register int m, n;
        register struct proc *pptr;
        int errcause;
        int *pv_entry;

        m = u.u_arg[1]; /* password for this crit. section */
        switch(u.u_arg[0]) {

        case (0): /* P */
                do {
                        spl7();
                        for (pptr = &proc[0]; pptr < &proc[NPROC]; pptr++) 
                                for ( n=0; n<NSEM; n++) 
                                        if (pptr->p_sem[n] == m) goto foundp;
                        /* here we are if the critical section is free */
                        /* go point to sem array in own table */
                        pv_entry = &(u.u_procp->p_sem[0]); 
                        for (n=0; n<NSEM; n++) 
                                if (*pv_entry++ == NULL) {
                                        *--pv_entry = u.u_arg[1]; /* store passwrd */
                                        goto exitp; /* ready */
                                }
                        errcause = EMFILE;
                        goto errorp; /* NSEM slots used */
                        /* here we come when we found the password in some
                           proc table; that proc is thus inside crit. sect */
                foundp: if (pptr == u.u_procp) {
                                errcause = EEXIST;
                                goto errorp;
                        }
                        spl0();
                        sleep( &(pptr->p_sem[n]), PSLEP); /* suspend */
                } while(1);
        errorp: u.u_error = errcause;
        exitp:  spl0();
                break;


        case(1): /* V */
                pv_entry = &(u.u_procp->p_sem[0]);
                for (n=0; n<NSEM; n++)
                        if (*pv_entry++ == m) { /* passwrd is in proctable */
                                *--pv_entry = NULL; /* remove it */
                                wakeup(pv_entry);
                                goto exitv;
                        }
                /* fall through here if V given without being in crit.sect */
                errcause = EPERM;
        errorv:
                u.u_error = errcause;
        exitv: /* drop out of routine */
                break;

        default:   /* entry for unknown case function (no P or V ) */
                u.u_error = EEXIST; 
                break;


        } /* end of switch */
}
#endif
