/*
 * SCCSID: @(#)label.c	3.0	4/22/86 
 */

/**********************************************************************
 *   Copyright (c) Digital Equipment Corporation 1984, 1985, 1986.    *
 *   All Rights Reserved. 					      *
 *   Reference "/usr/src/COPYRIGHT" for applicable restrictions.      *
 **********************************************************************/

/*

 Called by:	driver()

 Facility:	Part of the plot package for the LA50 Printer.

 Abstract:	label(s) - writes the string at the current point.

 Author:	Kevin J. Dunlap
		using some terminal driver code by Greg O'Brien
		and the 132 column font from P/OS.

 Creation:	March 1984

*/

#define DEBUG 0
#include <stdio.h>

/* the font table */
/*  This font is a 10 by 7 bit character font array.  Which is indexed
    by the ascii value of the character you want to display.
*/

int	font[][10] =
{
/*	fntbeg	nm=t132,wd=7.,ht=10.,un=9.,ud=177777,attr=0
*/
	   0,  28,  34,   4,   8,   8,   0,   8,   0,   0, /*  0 */
	   0,  62,  34,  34,  34,  34,  34,  62,   0,   0, /*  1 */ /* Box */
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, /*  2 */
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, /*  3 */
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, /*  4 */
	   0,	8,   8,   8,   8,   8,	 0,   8,   0,	0, /*  5 */ /* ! */
	   0,  20,  20,  20,   0,   0,	 0,   0,   0,	0, /*  6 */ /* " */
	   0,  20,  20,  62,  20,  62,	20,  20,   0,	0, /*  7 */ /* # */
	   0,	8,  28,  10,  28,  40,	28,   8,   0,	0, /*  8 */ /* $ */
	   0,  38,  38,  16,   8,   4,  50,  50,   0,   0, /*  9 */
	   0,   4,  10,  10,   4,  42,  18,  44,   0,   0, /* 10 */
	   0,  24,   8,   4,   0,   0,   0,   0,   0,   0, /* 11 */
	   0,  16,   8,   4,   4,   4,   8,  16,   0,   0, /* 12 */
	   0,   4,   8,  16,  16,  16,   8,   4,   0,   0, /* 13 */
	   0,   0,  34,  20,  62,  20,  34,   0,   0,   0, /* 14 */
	   0,   0,   8,   8,  62,   8,   8,   0,   0,   0, /* 15 */
	   0,	0,   0,   0,   0,   0,	24,   8,   4,	0, /* 16 */ /* , */
	   0,	0,   0,   0,  62,   0,	 0,   0,   0,	0, /* 17 */ /* - */
	   0,	0,   0,   0,   0,   0,	 8,   8,   0,	0, /* 18 */ /* . */
	   0,  32,  32,  16,   8,   4,	 2,   2,   0,	0, /* 19 */ /* / */
	   0,	8,  20,  34,  34,  34,	20,   8,   0,	0, /* 20 */ /* 0 */
	   0,   8,  12,  10,   8,   8,   8,  62,   0,   0, /* 21 */
	   0,  28,  34,  32,  24,   4,   2,  62,   0,   0, /* 22 */
	   0,  62,  32,  16,  24,  32,  34,  28,   0,   0, /* 23 */
	   0,  16,  24,  20,  18,  62,  16,  16,   0,   0, /* 24 */
	   0,  62,   2,  26,  38,  32,  34,  28,   0,   0, /* 25 */
	   0,  28,  34,   2,  26,  38,  34,  28,   0,   0, /* 26 */
	   0,  62,  32,  16,  16,   8,   4,   4,   0,   0, /* 27 */
	   0,  28,  34,  34,  28,  34,  34,  28,   0,   0, /* 28 */
	   0,  28,  34,  50,  44,  32,	34,  28,   0,	0, /* 29 */ /* 9 */
	   0,	0,   0,  24,  24,   0,	24,  24,   0,	0, /* 30 */ /* : */
	   0,	0,   0,  24,  24,   0,	24,   8,   4,	0, /* 31 */ /* ; */
	   0,  32,  16,   8,   4,   8,  16,  32,   0,   0, /* 32 */
	   0,   0,   0,  62,   0,  62,   0,   0,   0,   0, /* 33 */
	   0,   2,   4,   8,  16,   8,   4,   2,   0,   0, /* 34 */
	   0,  28,  34,  16,   8,   8,   0,   8,   0,   0, /* 35 */
	   0,  28,  34,  50,  42,  26,   2,  28,   0,   0, /* 36 */
	   0,   8,  20,  34,  34,  62,  34,  34,   0,   0, /* 37 */ /* A */
	   0,  30,  36,  36,  28,  36,  36,  30,   0,   0, /* 38 */
	   0,  28,  34,   2,   2,   2,  34,  28,   0,   0, /* 39 */
	   0,  30,  36,  36,  36,  36,  36,  30,   0,   0, /* 40 */
	   0,  62,   2,   2,  30,   2,   2,  62,   0,   0, /* 41 */
	   0,  62,   2,   2,  30,   2,   2,   2,   0,   0, /* 42 */
	   0,  28,  34,   2,   2,  50,  34,  28,   0,   0, /* 43 */
	   0,  34,  34,  34,  62,  34,  34,  34,   0,   0, /* 44 */
	   0,  28,   8,   8,   8,   8,   8,  28,   0,   0, /* 45 */
	   0, 112,  32,  32,  32,  32,  34,  28,   0,   0, /* 46 */
	   0,  34,  18,  10,   6,  10,  18,  34,   0,   0, /* 47 */
	   0,   2,   2,   2,   2,   2,   2,  62,   0,   0, /* 48 */
	   0,  34,  34,  54,  42,  34,  34,  34,   0,   0, /* 49 */
	   0,  34,  34,  38,  42,  50,  34,  34,   0,   0, /* 50 */
	   0,  28,  34,  34,  34,  34,  34,  28,   0,   0, /* 51 */
	   0,  30,  34,  34,  30,   2,   2,   2,   0,   0, /* 52 */
	   0,  28,  34,  34,  34,  34,  42,  28,  32,   0, /* 53 */
	   0,  30,  34,  34,  30,  10,  18,  34,   0,   0, /* 54 */
	   0,  28,  34,   2,  28,  32,  34,  28,   0,   0, /* 55 */
	   0,  62,   8,   8,   8,   8,   8,   8,   0,   0, /* 56 */
	   0,  34,  34,  34,  34,  34,	34,  28,   0,	0, /* 57 */
	   0,  34,  34,  34,  20,  20,  20,   8,   0,   0, /* 58 */
	   0,  34,  34,  34,  42,  42,  42,  20,   0,   0, /* 59 */
	   0,  34,  34,  20,   8,  20,  34,  34,   0,   0, /* 60 */
	   0,  34,  34,  20,   8,   8,   8,   8,   0,   0, /* 61 */
	   0,  62,  32,  16,   8,   4,	 2,  62,   0,	0, /* 62 */ /* Z */
	   0,  28,   4,   4,   4,   4,   4,  28,   0,   0, /* 63 */
	   0,   2,   2,   4,   8,  16,  32,  32,   0,   0, /* 64 */
	   0,  28,  16,  16,  16,  16,  16,  28,   0,   0, /* 65 */
	   0,   8,  20,  34,   0,   0,   0,   0,   0,   0, /* 66 */
	   0,	0,   0,   0,   0,   0,	 0,  62,   0,	0, /* 67 */ /* _ */
	   0,  12,   8,  16,   0,   0,	 0,   0,   0,	0, /* 68 */ /* ` */
	   0,	0,   0,  28,  32,  60,	34,  60,   0,	0, /* 69 */ /* a */
	   0,   2,   2,  26,  38,  34,  38,  26,   0,   0, /* 70 */
	   0,   0,   0,  28,  34,   2,  34,  28,   0,   0, /* 71 */
	   0,  32,  32,  44,  50,  34,  50,  44,   0,   0, /* 72 */
	   0,   0,   0,  28,  34,  62,   2,  28,   0,   0, /* 73 */
	   0,  24,  36,   4,  30,   4,   4,   4,   0,   0, /* 74 */
	   0,   0,   0,  44,  50,  34,  60,  32,  34,  28, /* 75 */
	   0,   2,   2,  26,  38,  34,  34,  34,   0,   0, /* 76 */
	   0,   8,   0,  12,   8,   8,   8,  28,   0,   0, /* 77 */
	   0,  16,   0,  16,  16,  16,  16,  18,  18,  12, /* 78 */
	   0,   2,   2,  34,  18,  14,  18,  34,   0,   0, /* 79 */
	   0,  12,   8,   8,   8,   8,	 8,  28,   0,	0, /* 80 */ /* l */
	   0,   0,   0,  22,  42,  42,  42,  34,   0,   0, /* 81 */
	   0,   0,   0,  26,  38,  34,  34,  34,   0,   0, /* 82 */
	   0,   0,   0,  28,  34,  34,  34,  28,   0,   0, /* 83 */
	   0,   0,   0,  26,  38,  38,  26,   2,   2,   2, /* 84 */
	   0,   0,   0,  44,  50,  50,  44,  32,  32,  32, /* 85 */
	   0,   0,   0,  26,  38,   2,   2,   2,   0,   0, /* 86 */
	   0,   0,   0,  28,   2,  28,  32,  30,   0,   0, /* 87 */
	   0,   4,   4,  30,   4,   4,  36,  24,   0,   0, /* 88 */
	   0,   0,   0,  34,  34,  34,  50,  44,   0,   0, /* 89 */
	   0,   0,   0,  34,  34,  20,  20,   8,   0,   0, /* 90 */
	   0,   0,   0,  34,  34,  42,  42,  20,   0,   0, /* 91 */
	   0,   0,   0,  34,  20,   8,  20,  34,   0,   0, /* 92 */
	   0,   0,   0,  34,  34,  50,  44,  32,  34,  28, /* 93 */
	   0,   0,   0,  62,  16,   8,   4,  62,   0,   0, /* 94 */
	   0,  48,   8,  16,  12,  16,	 8,  48,   0,	0, /* 95 */ /* { */
	   0,	8,   8,   8,   8,   8,	 8,   8,   0,	0, /* 96 */ /* | */
	   0,	6,   8,   4,  24,   4,	 8,   6,   0,	0, /* 97 */ /* } */
	   0,  36,  42,  18,   0,   0,	 0,   0,   0,	0, /* 98 */ /* ~ */
	   0,	8,   0,   8,   8,   8,	 8,   8,   0,	0, /* 99 */ /* ! inv*/
};

/* Label
	 Take the character string passed to us and pass each character
	 to char_display one at a time.
*/
extern int xnow;
extern int ynow;

label(s)
char *s;
{
	while ( *s )  /* String is terminated by a null */
	{
		char_display(*s++);
	}
}


/* Char_display
	   Take the character passed to us and display it in the bitmap.
*/

char_display(c)
register int	 c ;
{
	register int	*pattern ;
	int x, y;
	int b;
	c -= ' ' - 4 ;	/* get the index value into the font table */
	pattern = &font[c][0] ;  /* get the bit pattern from the font table */
	/* set the bits in the bitmap */
	for(x=xnow+9;x>=xnow;x--){
		b= *pattern++;
		for(y=ynow+14;y>=ynow;y--){
			if (b & 0100000) setbit(y,x);
			b <<=1;
		}
	}
	ynow = ynow+7;
}	/* end of char_display() */


