/*                               
 * char * alloc(size)
 * free (char*)
 *
 * allocate and free core of size bytes
 */


#define BLOK 512
#define BUSY 01

static char *allocs[2] ={		/*initial empty arena*/
	&allocs[1],
	&allocs[0]
};
static char **allocp =&allocs[1];	/*current search pointer*/
static char **alloct =&allocs[1];	/*top of arena (last cell)*/

alloc(nbytes)
{
	register int nwords;
	register char **p, **q;
	static char **t;

	(int)allocs[0] |= BUSY;	/*static initialization*/
	(int)allocs[1] |= BUSY;

	nwords = (nbytes+(2*sizeof(p)-1))/sizeof(p);
	for(p=allocp;;) {
		do {
			if(((int)*p&BUSY)==0) {
				while(((int)*(q = *p)&BUSY)==0)
					*p = *q;
				if(q >= &p[nwords])
					goto found;
			}
			q = p;
			p = (int)*p & ~BUSY;
		} while(q>=allocp || p<allocp);
		if((*alloct=t=sbrk(BLOK*sizeof(p))) == -1)
			return(-1);
		if(t!=alloct+1)
			(int)*alloct |= BUSY;
		alloct = (*t = &t[BLOK]-1);
		*alloct = allocs;
		(int)*alloct |= BUSY;
	}
found:
	allocp = &p[nwords];
	if(q>allocp)
		*allocp = *p;
	*p = (int)allocp|BUSY;
	return(p+1);
}

free(p)
char **p;
{
	allocp = p-1;
	(int)*allocp &= ~BUSY;
}
