/*
 *	text.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\text.h"
#include "h\malloc.h"
#include "h\inode.h"
#include "h\buf.h"
#include "h\systm.h"

struct text text[NTEXT];

void xccdec(struct text*);

/*
 * swap out process rp, change data size to os if ff
 */

#ifndef NOSWAP
void xswap(rp,ff,os)
register struct proc *rp;
word ff,os;
	{
	register blk_t a;
	if (os==0)
		os=rp->p_size;

	a=(blk_t)malloc(swapmap,(rp->p_size+511)>>9);

	if (a==NULL)
		panic("Out of swap space");

	xccdec(rp->p_textp);

	rp->p_flag|=SLOCK;
	if (swap(a,rp->p_addr,os,0))
		panic("Swap error xswap");
	if (ff)
		mfree(coremap,(dword)os,rp->p_addr);
	rp->p_flag&=~(SLOAD|SLOCK);
	rp->p_addr=(dword)a;
	rp->p_time=0;
	if (runout)
		{
		runout=0;		/* somebody is out, wake up	*/
		wakeup((int)&runout);	/* swapper process		*/
		}

	}
#endif /* NOSWAP */
/*
 *	free process's text segment
 */
void xfree(void)
	{
	register struct text *xp;
	register struct inode *ip;

	if ((xp=cup->p_textp)!=NULL)
		{
		cup->p_textp=NULL;
		xccdec(xp);
		if (--xp->x_count==0)	/* last proc with this text ended*/
			{		/* free swap unless proc is sticky*/
			ip=xp->x_iptr;
			if((ip->i_mode&ISVTX)==0)
			       {
			       xp->x_iptr=NULL;
			       mfree(swapmap,(xp->x_size+511)>>9,xp->x_daddr);
			       ip->i_flag&=~ITEXT;
			       iput(ip);
			       }
			}
		}

	}

/*
 * allocate text segment, read in text from executable
 * the same text segment can belong to multiple instances of a
 * process ( if process has separate I/D space==read only text)
 */
void xalloc(ip)
struct inode *ip;
	{
	register struct text *xp;
	register struct proc *rp;
	word ts;
	dword a;

	if (u->u_aux[1]==NULL)	/* text size	*/
		return;
	rp=NULL;
	for (xp=&text[0];xp<&text[NTEXT];xp++) 		/* see if there	*/
		if (xp->x_iptr==NULL)			/* is empty text*/
			{				/* slot,	*/
			if (rp==NULL)
				rp=(struct proc*)xp;
			}
		else
			if(xp->x_iptr==ip)		/* or if text	*/
				{			/* already 	*/
				xp->x_count++;		/* allocated	*/
				cup->p_textp=xp;
				ldtfil (TEXTS,xp->x_caddr,cup);
				goto OUT;
				}
	if((xp=(struct text*)rp)==NULL)
		panic("Out of text");
	xp->x_count=0;
	xp->x_ccount=0;
	xp->x_iptr=ip;
	ts=((u->u_aux[1]+1)/2)*2;
	xp->x_size=ts;
	if ((xp->x_daddr=(blk_t)malloc(swapmap,(ts+511)>>9))==NULL)
		panic("Out of swap space");
	expand(ts);		/* make data segment text size big	*/
	rp=cup;
	a=rp->p_addr;
	rp->p_addr=0;
	rp->p_size=0;
	ldtfil(DATAS,a,rp);
	ldtfil(TEXTS,a,rp);
	estabur(ts,ts,0,rp);    /* set up data seg to text seg		*/
	u->u_count=u->u_aux[1];	/* size of text				*/
	u->u_offset=020;	/* file less the exec header		*/
	u->u_base=0;
	readi(ip);		/* since readi can only read to data	*/
				/* executable segment are read only	*/
	rp->p_textp=xp;
	xp->x_caddr=a;
	ip->i_flag|=ITEXT;
	ip->i_count++;
	xp->x_count++;
#ifndef NOSWAP
	swap(xp->x_daddr,xp->x_caddr,ts,0);	/* put text to swap	*/
#endif /* NOSWAP */
	xp->x_ccount++;
	return;
OUT:				/* text is already allocated, don't read*/
	if (xp->x_ccount==0)	/* in again, just ++ the reference cnt	*/
		{
#ifdef NOSWAP
		panic ("Noswap swap");
#else
		xswap(cup, 1, 0);
#endif /* NOSWAP */
		cup->p_flag |= SSWAP;
		swtch();
		return;
		}
	xp->x_ccount++;
	return;
	}

/*
 * decrement in core reference count of a text, free mem if ref cnt==0
 */
void xccdec(rp)
register struct text *rp;
	{
	if(rp!=NULL && rp->x_ccount!=0)
		if(--rp->x_ccount==0)
			{
			mfree(coremap,(dword)rp->x_size,rp->x_caddr);
			}
	}

