/*
 *	sys1.c
 *	process control syscalls
 */

#include "h\types.h"
#include "h\param.h"
#include "h\text.h"
#include "h\file.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\buf.h"
#include "h\inode.h"
#include "h\malloc.h"
#include "h\systm.h"

int newproc(void);
void exit(void);

int execnt;


#define EXPRI	-1
#pragma warn -par

/*
 * exec change to a new process image
 */
void exec(n,a)
char *n;
word a;
	{
	register struct inode *ip;
	register char *cp;
	int ap,na,nc,ts,ds,ss,sep,c;
	struct buf *bp;

	ip=namei(uchar,0);
	if (ip==NULL)
		return;

	while(execnt>=NEXEC)              	/* buffers are used in	*/
		sleep((int)&execnt,EXPRI);	/* exec, so not to be	*/
	execnt++;				/* a buf hog, limit the	*/
						/* number of concurrent	*/
						/* exec calls		*/

	bp=getblk(NODEV,0);			/* buf for args		*/
	if (access(ip,IEXEC)||(ip->i_mode&IFMT)!=0)
		goto BAD;

	cp=bp->b_addr;
	na=0;				/* nuber of args	*/
	nc=0;				/* number of arg bytes	*/
#pragma warn -pia
	while(ap=fuword(a))		/* copy args to buffer	*/
#pragma warn +pia
		{
		na++;
		if (ap==-1)
			{
			goto BAD;
			}
		a+=2;
		do
			{
			c=fubyte(ap++);
			if (c==-1)
				{
				goto BAD;
				}
			*cp++=c;
			nc++;
			if (nc>510)	/* too big arglist	*/
				{
				u->u_error=E2BIG;
				goto BAD;
				}
			}
		while (c);
		}
	if ((nc&1)!=0)		/* stack an word boundary	*/
		{
		*cp++=0;
		nc++;
		}
/*
 * Read in the exec file header to u->u_aux[]:
 * W0 : 407/410/411 magic word
 * W1 : text size
 * W2 : data size
 * W3 : bss size
 * W4 : stack size -- stack is of fixed size
 * W5 : prog entry point	not used
 * W6 : symbol table pointer
 * W8 : unused, reserved
 */

	u->u_base=(char*)&u->u_aux[0];
	u->u_count=12;
	u->u_offset=0;
	u->u_segflg=1;
	readi(ip);
	u->u_segflg=0;
	if (u->u_error)
		goto BAD;

	sep=0;
	if (u->u_aux[0]==0407)		/* I-D space common n/a	*/
		{
		u->u_aux[2]+= u->u_aux[1];
		u->u_aux[1]=0;
		}
	else
	if(u->u_aux[0]==0411)		/* separate I-D		*/
		sep++;else
	if(u->u_aux[0]!=0410)		/* old format	    n/a	*/
		{
		u->u_error=ENOEXEC;
		goto BAD;
		}
	if (u->u_aux[1]!=0&&(ip->i_flag&ITEXT)==0 && ip->i_count!=1)
		{
		u->u_error=ETXTBSY;
		goto BAD;
		}

 /*
  * this is a point of no return
  *
  * The core image of a process is somewhat different than of the PDP-11
  * because Turbo C (damn!) insisted on using ds to address the stack,
  * so data and stack have to be in the same segment, stack cannot grow
  * and it has to be at virtual 0000 for data to grow upwards
  *
  *	======= <--- end of data seg, set by brk
  *	| BSS |
  *	------- <--- end of initialized data
  *	| DATA|
  *	======= <--- start of stack set at compile time
  *	| STCK|
  *	------- <--- ds:0000, ss:0000 virtual
  *
  *	=======	<--- end of text
  *	| TEXT|
  *	======= <--- cs:0000 virtual
  *
  */

	ts = ((u->u_aux[1]+1)/2)*2;	/* text size rounded up	*/
	ss = ((u->u_aux[4]+1)/2)*2;	/* stack size		*/
	ds = ((u->u_aux[2]+u->u_aux[3]+1)/2)*2;	/* data+bss	*/

	u->u_prof[3]=0;

	xfree();			/* drop old image	*/

	expand(0);

	xalloc(ip);			/* get text seg		*/
	c=ds+ss;
	expand(c);			/* expand data seg to new size	*/
	clearseg(cup->p_addr,c);	/* clear stack+data+bss		*/
	estabur(0,ds+ss,0,cup);
					/* data seg beolvasasa */
	u->u_base=(char*)u->u_aux[4];
	u->u_offset=020+u->u_aux[1];
	u->u_count=u->u_aux[2];
	readi(ip);			/* read in initialized data	*/
	u->u_tsize=ts;
	u->u_dsize=ds;
	u->u_ssize=ss;
	u->u_sep=sep;
	estabur(u->u_tsize,u->u_dsize,
			u->u_ssize,cup);

	if ((ap=10+(nc+na*2+14))>=u->u_ssize)
		{
		printf ("Smallstack\n");/* args don't fit		*/
		}
	ap=u->u_ssize-ap;

/* ap is the process's initial sp, it goes into the kernel stack, so
 * at return it will be the new user stack pointer
 * The same method is used to set the new ip.
 */

	*(cup->p_kstck-9)=0;		/* ip=0 	 		*/
	*(cup->p_kstck-2)=ap;		/* sp=ap, 			*/
	ap+=10;
	suword(ap,na);			/* exec arg 1--argc 		*/
	cp=bp->b_addr;
	c=ap+na*2+6;

	while(na--)			/* put args to stack		*/
		{
		suword(ap+=2,c);	/* argv[x] 			*/
		do      {
			subyte(c++,*cp);
		}
		while(*cp++);		/* *argv[x] 			*/
		}
	suword(ap+2,0);			/* closing 0			*/
NOAR:
					/* setuid & co */
	if ((cup->p_flag&STRC)==0)
		{
		if(ip->i_mode&ISUID)
			if(u->u_uid!=0)
				{
				u->u_uid=ip->i_uid;
				cup->p_pid=ip->i_uid;
				}
		if(ip->i_mode&ISGID)
			{
			u->u_gid=ip->i_gid;
			}
	}
					/* clear signal handlers	*/
	for (c=(int)&u->u_signal[0];c<(int)&u->u_signal[NSIG];c+=2)
		if(*(int*)c!=1)
			*(int*)c=0;

BAD:
	iput (ip);
	brelse(bp);
	if(execnt>=NEXEC)
		wakeup((int)&execnt);
	execnt--;
enable();	/* somewhere there is a lock(), but where in the hell?? */
	}
/*
 * fork duplicate current process
 */
fork()
	{
	register struct proc *p2;
	register struct user *p1;
	p1=u;
	for(p2=&proc[0];p2<&proc[NPROC];p2++)
		if(p2->p_stat==NULL)
			goto FOUND;
	p1->u_error=EAGAIN;		/* no more process slots	*/
	return(0);
FOUND:
	return(newproc());
	}

/*
 * exit terminate current process
 */
void rexit(rv)
int rv;
	{
	u->u_rv=rv<<8;
	exit();
	}

void exit(void)
	{

	register struct proc *p;
	register struct proc *q;
	word *s;
	word a;
	struct file **f;

	cup->p_flag&=~STRC;

	if (cup->p_pid==1)
		if (cup->p_size==0)
			panic("Cannot execute /etc/init");
		else
			panic("Init died");

	for(s=&u->u_signal[0];s<&u->u_signal[NSIG];)
		*s++=1;
	for (f=&u->u_ofile[0];f<&u->u_ofile[NOFILE];f++)
		if(*f)
			{
			closef(*f);
			*f=NULL;
			}
	iput(u->u_cdir);
	xfree();
#ifndef NOSWAP
	a=(word)malloc(swapmap,1);
	if (a==NULL)
		panic("Out of swap");
	p=(struct proc*)getblk(swapdev,a);
	bcopy(u,((struct buf*)p)->b_addr,256);
	bwrite((struct buf*)p);
#endif /* NOSWAP */
	q=cup;
	mfree(coremap,(dword)q->p_size,(dword)q->p_addr);
	q->p_addr=a;
	q->p_stat=SZOMB;
LOOP:
	for(p=&proc[0];p<&proc[NPROC];p++)
	if(q->p_ppid==p->p_pid)
		{
		wakeup((int)&proc[1]);
		wakeup((int)p);
		for(p=&proc[0];p<&proc[NPROC];p++)
		if(q->p_pid==p->p_ppid)
			{
			p->p_ppid=1;
			if(p->p_stat==SSTOP)
				setrun(p);
			}
		swtch();
		}
	q->p_ppid=1;	/* orphans go to init, he waits them	*/
	goto LOOP;
	}

/*
 * wait for child to terminate
 */
long wait()
	{
	register struct proc *p;
	register struct user *up;
	struct buf *bp;
	int f;

	f=0;
LOOP:
	for(p=&proc[0];p<&proc[NPROC];p++)
	if (p->p_ppid==cup->p_pid)
		{
		f++;
		if(p->p_stat==SZOMB)
			{
			u->u_aux[0]=p->p_pid;
#ifndef NOSWAP
			bp=bread(swapdev,f=(int)p->p_addr);
			mfree(swapmap,1L,(dword)f);
			p->p_stat=NULL;
			p->p_pid=0;
			p->p_ppid=0;
			p->p_sig=0;
			p->p_ttyp=0;
			p->p_flag=0;
			up=(struct user*)bp->b_addr;
			u->u_cstime+=up->u_cstime+up->u_stime;
			u->u_cutime+= up->u_cutime+up->u_utime;
			u->u_aux[1]=up->u_rv;
			brelse(bp);
#endif /* NOSWAP */
			return (((long)u->u_aux[1]<<16)
					+u->u_aux[0]);
			}
		if(p->p_stat==SSTOP)
			{
			if((p->p_flag&SWTED)==0)
				{
				p->p_flag|=SWTED;
				return(((long)((p->p_sig<<8)|0177)<<16)
					+p->p_pid);
				}
			p->p_flag&=~(STRC|SWTED);
			setrun(p);
			}
		}
	if(f)
		{
		sleep((int)cup,PWAIT);
		goto LOOP;
		}
	u->u_error=ECHILD;
	return (0);
	}

/*
 * set data seg upper limit
 */
sbreak(s)
register word s;
	{
	register int d;
	if (s<cup->p_ldt[STACKS/8].limit)
		{
		u->u_error=EINVAL;
		return(-1);
		}
	d=cup->p_ldt[DATAS/8].limit;
	estabur(u->u_tsize,s-u->u_ssize,u->u_ssize,cup);
	expand(s);
	return (d);
	}