


PATCH(1)                                                 PATCH(1)


NNAAMMEE
       patch - apply a diff file to an original

SSYYNNOOPPSSIISS
       ppaattcchh [options] [origfile [patchfile]] [+ [options] [orig-
       file]]...

       but usually just

       ppaattcchh <patchfile

DDEESSCCRRIIPPTTIIOONN
       _P_a_t_c_h will take a patch file containing any  of  the  four
       forms  of  difference listing produced by the _d_i_f_f program
       and apply those differences to an original file, producing
       a patched version.  By default, the patched version is put
       in place of the original, with the original file backed up
       to  the  same  name with the extension ``.orig'' (``~'' on
       systems that do not support long file names), or as speci-
       fied  by  the  --bb (----ssuuffffiixx), --BB (----pprreeffiixx), or --VV (----vveerr--
       ssiioonn--ccoonnttrrooll) options.   The  extension  used  for  making
       backup   files   may   also   be  specified  in  the  SSIIMM--
       PPLLEE__BBAACCKKUUPP__SSUUFFFFIIXX environment variable, which is  overrid-
       den by the above options.

       If  the  backup  file  already exists, ppaattcchh creates a new
       backup file name by changing the first lowercase letter in
       the  last component of the file's name into uppercase.  If
       there are no  more  lowercase  letters  in  the  name,  it
       removes  the  first  character  from the name.  It repeats
       this process until it comes up with  a  backup  file  that
       does not already exist.

       You  may also specify where you want the output to go with
       a --oo (----oouuttppuutt) option; if that file already exists, it is
       backed up first.

       If _p_a_t_c_h_f_i_l_e is omitted, or is a hyphen, the patch will be
       read from standard input.

       Upon startup, patch will attempt to determine the type  of
       the  diff  listing, unless over-ruled by a --cc (----ccoonntteexxtt),
       --ee (----eedd), --nn (----nnoorrmmaall), or --uu (----uunniiffiieedd) option.   Con-
       text  diffs (old-style, new-style, and unified) and normal
       diffs are applied by the _p_a_t_c_h program  itself,  while  _e_d
       diffs are simply fed to the _e_d editor via a pipe.

       _P_a_t_c_h  will  try  to  skip  any leading garbage, apply the
       diff, and then skip any trailing garbage.  Thus you  could
       feed  an  article  or message containing a diff listing to
       _p_a_t_c_h, and it should work.  If the entire diff is indented
       by a consistent amount, this will be taken into account.

       With  context  diffs,  and  to a lesser extent with normal



                              LOCAL                             1





PATCH(1)                                                 PATCH(1)


       diffs, _p_a_t_c_h can detect when the line numbers mentioned in
       the patch are incorrect, and will attempt to find the cor-
       rect place to apply each hunk of the patch.   As  a  first
       guess,  it  takes  the line number mentioned for the hunk,
       plus or minus any offset used  in  applying  the  previous
       hunk.   If  that is not the correct place, _p_a_t_c_h will scan
       both forwards and backwards for a set  of  lines  matching
       the  context  given  in the hunk.  First _p_a_t_c_h looks for a
       place where all lines of the context match.   If  no  such
       place  is  found, and it's a context diff, and the maximum
       fuzz factor is set to 1 or more, then another  scan  takes
       place  ignoring  the  first  and last line of context.  If
       that fails, and the maximum fuzz factor is  set  to  2  or
       more,  the  first  two  and  last two lines of context are
       ignored, and another scan is made.  (The  default  maximum
       fuzz  factor  is  2.)   If  _p_a_t_c_h  cannot  find a place to
       install that hunk of the patch, it will put the  hunk  out
       to a reject file, which normally is the name of the output
       file plus ``.rej'' (``#'' on systems that do  not  support
       long  file names).  (Note that the rejected hunk will come
       out in context diff form whether the  input  patch  was  a
       context  diff or a normal diff.  If the input was a normal
       diff, many of the contexts will simply be null.)  The line
       numbers  on  the hunks in the reject file may be different
       than in the patch file: they reflect the approximate loca-
       tion  patch thinks the failed hunks belong in the new file
       rather than the old one.

       As each hunk is completed, you will be  told  whether  the
       hunk succeeded or failed, and which line (in the new file)
       _p_a_t_c_h thought the hunk should go on.  If this is different
       from  the  line  number  specified in the diff you will be
       told the offset.  A single large offset MAY be an  indica-
       tion  that  a  hunk was installed in the wrong place.  You
       will also be told if a fuzz factor was used  to  make  the
       match,  in  which  case you should also be slightly suspi-
       cious.

       If no original file is  specified  on  the  command  line,
       _p_a_t_c_h will try to figure out from the leading garbage what
       the name of the file to edit is.  In the header of a  con-
       text  diff,  the  file  name is found from lines beginning
       with ``***'' or ``---'', with  the  shortest  name  of  an
       existing file winning.  Only context diffs have lines like
       that, but if there is an ``Index:'' line  in  the  leading
       garbage,  _p_a_t_c_h  will  try  to use the file name from that
       line.  The context diff header takes  precedence  over  an
       Index  line.   If  no  file  name can be intuited from the
       leading garbage, you will be asked for  the  name  of  the
       file to patch.

       If  the original file cannot be found or is read-only, but
       a suitable SCCS or RCS file is handy, _p_a_t_c_h  will  attempt
       to get or check out the file.



                              LOCAL                             2





PATCH(1)                                                 PATCH(1)


       Additionally,  if the leading garbage contains a ``Prereq:
       '' line, _p_a_t_c_h will take the first word from the prerequi-
       sites line (normally a version number) and check the input
       file to see if that word can be found.  If not, _p_a_t_c_h will
       ask for confirmation before proceeding.

       The  upshot of all this is that you should be able to say,
       while in a news interface, the following:

            | patch -d /usr/src/local/blurfl

       and patch a file in the blurfl directory directly from the
       article containing the patch.

       If the patch file contains more than one patch, _p_a_t_c_h will
       try to apply each of them as if they  came  from  separate
       patch  files.   This means, among other things, that it is
       assumed that the name of the file to patch must be  deter-
       mined  for  each diff listing, and that the garbage before
       each diff listing will be examined for interesting  things
       such as file names and revision level, as mentioned previ-
       ously.  You can give options (and  another  original  file
       name)  for the second and subsequent patches by separating
       the corresponding argument lists by a `+'.  (The  argument
       list  for  a  second or subsequent patch may not specify a
       new patch file, however.)

       _P_a_t_c_h recognizes the following options:

       --bb ssuuffff,, ----ssuuffffiixx==ssuuffff
            causes ssuuffff to be interpreted as  the  backup  exten-
            sion, to be used in place of ``.orig'' or ``~''.

       --BB pprreeff,, ----pprreeffiixx==pprreeff
            causes  pprreeff  to  be  interpreted  as a prefix to the
            backup file name. If this argument is specified,  any
            argument from --bb will be ignored.

       --cc,, ----ccoonntteexxtt
            forces _p_a_t_c_h to interpret the patch file as a context
            diff.

       --dd ddiirr,, ----ddiirreeccttoorryy==ddiirr
            causes _p_a_t_c_h to interpret ddiirr as a directory, and  cd
            to it before doing anything else.

       --DD ssyymm,, ----iiffddeeff==ssyymm
            causes  _p_a_t_c_h  to use the "#ifdef...#endif" construct
            to mark changes.  ssyymm will be used as the differenti-
            ating symbol.

       --ee,, ----eedd
            forces  _p_a_t_c_h  to  interpret  the patch file as an _e_d
            script.



                              LOCAL                             3





PATCH(1)                                                 PATCH(1)


       --EE,, ----rreemmoovvee--eemmppttyy--ffiilleess
            causes _p_a_t_c_h to remove output files  that  are  empty
            after the patches have been applied.

       --ff,, ----ffoorrccee
            forces  _p_a_t_c_h  to  assume that the user knows exactly
            what he or she is doing, and to  not  ask  any  ques-
            tions.   It  assumes  the following: skip patches for
            which a file to patch can't  be  found;  patch  files
            even  though  they  have  the  wrong  version for the
            ``Prereq:''  line  in  the  patch;  and  assume  that
            patches  are not reversed even if they look like they
            are.  This option does not suppress  commentary;  use
            --ss for that.

       --tt,, ----bbaattcchh
            similar  to  --ff, in that it suppresses questions, but
            makes some different assumptions:  skip  patches  for
            which  a  file  to  patch can't be found (the same as
            --ff); skip patches for which the file  has  the  wrong
            version  for  the  ``Prereq:'' line in the patch; and
            assume that patches are reversed if  they  look  like
            they are.

       --FF nnuummbbeerr,, ----ffuuzzzz==nnuummbbeerr
            sets  the  maximum  fuzz  factor.   This  option only
            applies to context diffs, and causes _p_a_t_c_h to  ignore
            up  to  that  many  lines  in  looking  for places to
            install a hunk.   Note  that  a  larger  fuzz  factor
            increases  the  odds  of a faulty patch.  The default
            fuzz factor is 2, and it may not be set to more  than
            the  number  of lines of context in the context diff,
            ordinarily 3.

       --ll,, ----iiggnnoorree--wwhhiitteessppaaccee
            causes the pattern matching to be  done  loosely,  in
            case  the  tabs  and  spaces have been munged in your
            input file.  Any sequence of whitespace in  the  pat-
            tern  line will match any sequence in the input file.
            Normal characters must  still  match  exactly.   Each
            line  of  the  context must still match a line in the
            input file.

       --nn,, ----nnoorrmmaall
            forces _p_a_t_c_h to interpret the patch file as a  normal
            diff.

       --NN,, ----ffoorrwwaarrdd
            causes  _p_a_t_c_h  to  ignore  patches that it thinks are
            reversed or already applied.  See also --RR ..

       --oo ffiillee,, ----oouuttppuutt==ffiillee
            causes ffiillee to be  interpreted  as  the  output  file
            name.



                              LOCAL                             4





PATCH(1)                                                 PATCH(1)


       --pp[[nnuummbbeerr]],, ----ssttrriipp[[==nnuummbbeerr]]
            sets  the  pathname  strip  count, which controls how
            pathnames found in the patch  file  are  treated,  in
            case the you keep your files in a different directory
            than the person who sent out the  patch.   The  strip
            count  specifies  how many slashes are to be stripped
            from the front of  the  pathname.   (Any  intervening
            directory  names also go away.)  For example, suppos-
            ing the file name in the patch file was

                 /u/howard/src/blurfl/blurfl.c

            setting --pp or --pp00 gives the entire  pathname  unmodi-
            fied, --pp11 gives

                 u/howard/src/blurfl/blurfl.c

            without the leading slash, --pp44 gives

                 blurfl/blurfl.c

            and   not   specifying  --pp  at  all  just  gives  you
            "blurfl.c", unless all  of  the  directories  in  the
            leading  path  (u/howard/src/blurfl)  exist  and that
            path is relative, in which case you  get  the  entire
            pathname  unmodified.   Whatever  you  end up with is
            looked for either in the current  directory,  or  the
            directory specified by the --dd option.

       --rr ffiillee,, ----rreejjeecctt--ffiillee==ffiillee
            causes  ffiillee  to  be  interpreted  as the reject file
            name.

       --RR,, ----rreevveerrssee
            tells _p_a_t_c_h that this patch was created with the  old
            and  new  files  swapped.  (Yes, I'm afraid that does
            happen occasionally, human nature being what it  is.)
            _P_a_t_c_h  will  attempt  to swap each hunk around before
            applying it.  Rejects will come out  in  the  swapped
            format.   The  --RR  option  will not work with _e_d diff
            scripts because there is too  little  information  to
            reconstruct the reverse operation.

            If  the  first  hunk  of  a  patch  fails, _p_a_t_c_h will
            reverse the hunk to see if it  can  be  applied  that
            way.   If  it  can,  you will be asked if you want to
            have the --RR option set.  If it can't, the patch  will
            continue  to be applied normally.  (Note: this method
            cannot detect a reversed patch if it is a normal diff
            and if the first command is an append (i.e. it should
            have been a delete) since appends always succeed, due
            to  the fact that a null context will match anywhere.
            Luckily, most patches add or change lines rather than
            delete them, so most reversed normal diffs will begin



                              LOCAL                             5





PATCH(1)                                                 PATCH(1)


            with  a  delete,  which  will  fail,  triggering  the
            heuristic.)

       --ss,, ----ssiilleenntt,, ----qquuiieett
            makes  _p_a_t_c_h  do  its  work silently, unless an error
            occurs.

       --SS,, ----sskkiipp
            causes _p_a_t_c_h to ignore  this  patch  from  the  patch
            file,  but  continue on looking for the next patch in
            the file.  Thus

                 patch -S + -S + <patchfile

            will ignore the first and second of three patches.

       --uu,, ----uunniiffiieedd
            forces _p_a_t_c_h to interpret the patch file as a unified
            context diff (a unidiff).

       --vv,, ----vveerrssiioonn
            causes  _p_a_t_c_h  to  print  out its revision header and
            patch level.

       --VV mmeetthhoodd,, ----vveerrssiioonn----ccoonnttrrooll==mmeetthhoodd
            causes mmeetthhoodd to be interpreted as a method for  cre-
            ating  backup  file  names.  The type of backups made
            can also be given in the VVEERRSSIIOONN__CCOONNTTRROOLL  environment
            variable, which is overridden by this option.  The --BB
            option overrides this option, causing the  prefix  to
            always  be  used  for  making backup file names.  The
            value of the VVEERRSSIIOONN__CCOONNTTRROOLL environment variable and
            the  argument to the --VV option are like the GNU Emacs
            `version-control' variable; they also recognize  syn-
            onyms  that  are  more descriptive.  The valid values
            are (unique abbreviations are accepted):

            `t' or `numbered'
                   Always make numbered backups.

            `nil' or `existing'
                   Make numbered backups of  files  that  already
                   have them, simple backups of the others.  This
                   is the default.

            `never' or `simple'
                   Always make simple backups.

       --xx nnuummbbeerr,, ----ddeebbuugg==nnuummbbeerr
            sets internal debugging flags,  and  is  of  interest
            only to _p_a_t_c_h patchers.

AAUUTTHHOORR
       Larry Wall <lwall@netlabs.com>



                              LOCAL                             6





PATCH(1)                                                 PATCH(1)


       with many other contributors.

EENNVVIIRROONNMMEENNTT
       TTMMPPDDIIRR Directory  to  put  temporary  files in; default is
              /tmp.

       SSIIMMPPLLEE__BBAACCKKUUPP__SSUUFFFFIIXX
              Extension to use for backup file names  instead  of
              ``.orig'' or ``~''.

       VVEERRSSIIOONN__CCOONNTTRROOLL
              Selects when numbered backup files are made.

FFIILLEESS
       $TMPDIR/patch*

SSEEEE AALLSSOO
       diff(1)

NNOOTTEESS FFOORR PPAATTCCHH SSEENNDDEERRSS
       There  are  several  things you should bear in mind if you
       are going to be sending out patches.  First, you can  save
       people a lot of grief by keeping a patchlevel.h file which
       is patched to increment the patch level as the first  diff
       in the patch file you send out.  If you put a Prereq: line
       in with the patch, it won't let them apply patches out  of
       order  without  some  warning.   Second,  make sure you've
       specified the file names right, either in a  context  diff
       header, or with an Index: line.  If you are patching some-
       thing in a subdirectory, be sure to tell the patch user to
       specify  a  --pp  option as needed.  Third, you can create a
       file by sending out a diff that compares a  null  file  to
       the  file  you want to create.  This will only work if the
       file you want to create doesn't exist already in the  tar-
       get directory.  Fourth, take care not to send out reversed
       patches, since it makes people wonder whether they already
       applied  the  patch.   Fifth, while you may be able to get
       away with putting 582 diff listings into one file,  it  is
       probably  wiser  to  group  related  patches into separate
       files in case something goes haywire.

DDIIAAGGNNOOSSTTIICCSS
       Too many to list here, but generally indicative that _p_a_t_c_h
       couldn't parse your patch file.

       The message ``Hmm...'' indicates that there is unprocessed
       text in the patch file and that  _p_a_t_c_h  is  attempting  to
       intuit  whether  there is a patch in that text and, if so,
       what kind of patch it is.

       _P_a_t_c_h will exit with a non-zero status if any reject files
       were created.  When applying a set of patches in a loop it
       behooves you to check this exit status so you don't  apply
       a later patch to a partially patched file.



                              LOCAL                             7





PATCH(1)                                                 PATCH(1)


CCAAVVEEAATTSS
       _P_a_t_c_h  cannot  tell  if  the line numbers are off in an _e_d
       script, and can only detect bad line numbers in  a  normal
       diff  when  it finds a ``change'' or a ``delete'' command.
       A context diff using fuzz factor 3 may have the same prob-
       lem.  Until a suitable interactive interface is added, you
       should probably do a context diff in these cases to see if
       the  changes  made  sense.   Of  course, compiling without
       errors is a pretty good indication that the patch  worked,
       but not always.

       _P_a_t_c_h  usually  produces the correct results, even when it
       has to do a lot of guessing.   However,  the  results  are
       guaranteed to be correct only when the patch is applied to
       exactly the same version of the file that  the  patch  was
       generated from.

BBUUGGSS
       Could   be  smarter  about  partial  matches,  excessively
       deviant offsets and swapped code, but that would  take  an
       extra pass.

       If code has been duplicated (for instance with #ifdef OLD-
       CODE ... #else ...  #endif), _p_a_t_c_h is incapable of  patch-
       ing  both  versions,  and, if it works at all, will likely
       patch the wrong one, and tell you  that  it  succeeded  to
       boot.

       If  you  apply  a patch you've already applied, _p_a_t_c_h will
       think it is a reversed patch, and offer  to  un-apply  the
       patch.  This could be construed as a feature.


























                              LOCAL                             8


