/* RWDOCS */
/* filename	: motor.h
 * purpose	: describe data and constants used in polling motor
 *		: for cohulip
 * author	: Randy Wright
 * Copyright	: ((C)) 1993 Randy Wright
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#ifndef MOTOR_H
#define MOTOR_H

#ifndef pollfd
#include <poll.h>
#endif

#ifndef interface
#include "iface.h"
#endif

#define MAXPOLLS 20		/* maximum number of polls in array */

typedef struct CYLINDER {
	void (*r_stroke)();	/* call when POLLIN comes */
	void (*t_stroke)();	/* call when POLLOUT comes */
	void (*p_stroke)();	/* call when POLLPRI comes */
	struct interface *ifp; /* the interface.. used as an arg to calls */
	int status;	/* true if we want to remove this cylinder */
	} CYLINDER;


extern CYLINDER crankshaft[];
extern int numcyls;
extern int throttle;

extern int makepiston(), rmpiston();


#endif /* MOTOR_H */
/* RWDOCE */
