/*
   Copyright (c) 1994 by Harry Pulley.

   May be freely distributed and modified provided that this copyright notice
   is not removed.  I am not responsible for any damages caused in any way,
   shape or form.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <poll.h>
#include <sys/sbioctl.h>

unsigned char tconst;
unsigned short samplespersec;
unsigned long buflen;
FILE *fp;
unsigned long datalen;
struct pollfd sbpoll[1];

int sb_fd,delay;

char *aligned0,*aligned1;
struct sb_ioctl sbis;
unsigned char sb_status;

void main ( argc, argv )
int argc;
char **argv;
{
    int num=0;

    if(argc<3)
    {
        printf("Usage: %s <infile> <samplerate>.\n",argv[0]);

        exit(0);
    }

    sb_fd=open("/dev/sb",O_RDWR);

    if (sb_fd<0)
    {
	printf("Unable to open SB driver.\n");

	exit(1);
    }

    sbpoll[0].fd=sb_fd;
    sbpoll[0].events=POLLOUT;

    if((fp=fopen(argv[1],"r"))==0)
    {
        printf("Unable to open %s for reading.\n",argv[1]);

        exit(1);
    }

#if 0
    printf("file: %s.\n",argv[1]);
#endif
    sbmalloc();
    fseek(fp,0L,2);
    datalen=ftell(fp);
    fseek(fp,0L,0);
    samplespersec=atoi(argv[2]);
    delay=1000*(BUF_SIZE)/samplespersec;
    delay-=delay%10;

#if 0
    printf("delay %d.\n",delay);

    printf("Samples Per Second %u.\n",samplespersec);
#endif
    tconst=time_const(samplespersec);
#if 0
    printf("Time Constant %u\n",tconst);
#endif

    sbsettconst(tconst);

    sbspkon();
    sbplay(1,num);
    sbspkoff();
    sbspkon();

    if(datalen>(BUF_SIZE)) buflen=(BUF_SIZE); else buflen=datalen;
    datalen-=buflen;
    
    fread(aligned0,1,buflen,fp);

    while(1)
    {
	sbplay(buflen,num);

        num=(num==1)?0:1;

#if 0
	delay=1000*buflen/samplespersec;
	delay-=delay%10;
#endif

	if (datalen==0)
	{
		poll(sbpoll,1,-1);

		break;
	}
	else
	{
        	if(datalen>(BUF_SIZE)) buflen=(BUF_SIZE); else buflen=datalen;
        	datalen-=buflen;
		fread((num==1)?aligned1:aligned0,1,buflen,fp);
		poll(sbpoll,1,-1);
	}
    }
    sbspkoff();

    close(sb_fd);
}

sbmalloc()
{
	aligned0=(char *)malloc(BUF_SIZE+PAGE_SIZE-1);

	if (aligned0==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned0)%PAGE_SIZE)
		aligned0+=PAGE_SIZE-(((unsigned long)aligned0)%PAGE_SIZE);

	aligned1=(char *)malloc(BUF_SIZE+PAGE_SIZE-1);

	if (aligned1==NULL)
	{
		printf("Unable to allocate buffer 0.\n");

		exit(2);
	}

	if (((unsigned long)aligned1)%PAGE_SIZE)
		aligned1+=PAGE_SIZE-(((unsigned long)aligned1)%PAGE_SIZE);

	sbis.buffer_addr=aligned0;
	sbis.buffer_len=BUF_SIZE;

	errno=0;

	ioctl(sb_fd,MAP_BUFFER0,&sbis);

	if (errno)
	{
		printf("Error %d on map 0.\n",errno);

		exit(5);
	}

	sbis.buffer_addr=aligned1;
	
	errno=0;

	ioctl(sb_fd,MAP_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d on map 1.\n",errno);

		exit(5);
	}
}

sbsettconst(val)
unsigned char val;
{
	sbis.parameter=val;

	ioctl(sb_fd,SET_TIMECONST,&sbis);
}

sbspkon()
{
	ioctl(sb_fd,SPKR_ON,&sbis);
}

sbspkoff()
{
	ioctl(sb_fd,SPKR_OFF,&sbis);
}

sbhaltdma()
{
	ioctl(sb_fd,DMA_HALT,&sbis);
}

sbplay(len,bufnum)
unsigned long len;
int bufnum;
{
	sbis.buffer_len=len;

	/* printf("len %ld\n",len); */

	errno=0;

	ioctl(sb_fd,(bufnum==0)?PLAY_BUFFER0:PLAY_BUFFER1,&sbis);

	if (errno)
	{
		printf("Error %d playing %d.\n",errno,bufnum);

		sbspkoff();

		exit(5);
	}
}

dmastatus()
{
	sbis.status=&sb_status;

	ioctl(sb_fd,DMA_STATUS,&sbis);

	printf("%d\n",sb_status&2);

	return (sb_status&2);
}
