#!/bin/sh

###
# haiss/mkdev - get host adapter card tunables.
###

DEVDIR=/dev

. /usr/lib/shell_lib.sh
COMMAND_NAME=$0
source_path $0 "HOME_DIR="
parent_of $HOME_DIR "CONF_DIR="
. $CONF_DIR/bin/conf_lib.sh

while : ; do
	get_tunable HAISS_TYPE SS_TYPE
	echo "\nHAI: Haiss controller type configuration.\n"
	echo "\nHaiss driver controller types:\n"
	echo "0) Seagate ST01/02"
	echo "1) Future Domain TMC-845/850/860/875/885"
	echo "2) Future Domain TMC-840/841/880/881"

	echo "\nHaiss is currently using controller type: $SS_TYPE"
	read_input "Change Controller type" ANS "n" require_yes_or_no 
	is_yes $ANS || break

	read_input "\nSelect a controller from the list" ANS
	case $ANS in
	[0-2])
		SS_TYPE=$ANS
		$CONF_DIR/bin/idtune -f HAISS_TYPE $SS_TYPE
		;;
	*)
		echo "Select a number from the list (0, 1, or 2)!" 
		;;
	esac

done

while : ; do
	get_tunable HAISS_INTR SS_INTR
	echo "
Haiss driver interrupt configuration.
The haiss driver must use an Interrupt Request Line. Possible IRQ's are:

      3)  IRQ 3
      4)  IRQ 4
      5)  IRQ 5
     10)  IRQ 10
     11)  IRQ 11
     12)  IRQ 12
     14)  IRQ 14
     15)  IRQ 15

Haiss is currently set to use IRQ $SS_INTR
"
	read_input "Change controller IRQ" ANS "n" require_yes_or_no
	is_yes $ANS || break

	read_input "Select an IRQ from the list" ANS
	case $ANS in
	3|4|5|10|11|12|14|15)
		SS_INTR=$ANS
		$CONF_DIR/bin/idtune -f HAISS_INTR $SS_INTR
		;;
	*)
		echo "Please select a number from the list." 
		;;
	esac
done

get_tunable HAISS_BASE SS_BASE
while : ; do
	echo "
The Seagate and and Future Domain Controllers can be configured to 
use base addresses of:

     1)   0xC800
     2)   0xCA00
     3)   0xCC00
     4)   0xCE00
     5)   0xDC00
     6)   0xDE00

haiss is currently set to use Base Address: [$SS_BASE]
"
	read_input "Change controller base address" ANS "y" require_yes_or_no
	is_yes $ANS || break

	read_input "Select a base address from the list" ANS
	case $ANS in
     	1|0xC800)
		SS_BASE=0xC800
		$CONF_DIR/bin/idtune -f HAISS_BASE $SS_BASE
		;;
	2|0xCA00)
		SS_BASE=0xC800
		$CONF_DIR/bin/idtune -f HAISS_BASE $SS_BASE
		;;
	3|0xCC00)
		SS_BASE=0xC800
		$CONF_DIR/bin/idtune -f HAISS_BASE $SS_BASE
		;;
     	4|0xCE00)
		SS_BASE=0xC800	
		$CONF_DIR/bin/idtune -f HAISS_BASE $SS_BASE
		;;
     	5|0xDC00)
		SS_BASE=0xC800
		$CONF_DIR/bin/idtune -f HAISS_BASE $SS_BASE
		;;
	6|0xDE00)
		SS_BASE=0xC800
		$CONF_DIR/bin/idtune -f HAISS_BASE $SS_BASE
		;;
	*)
		echo "Please select a number from the list." 
		;;
	esac
done

exit 0

