# (-lgl
#	Coherent 386 release 4.2-Beta
#	Copyright (c) 1982, 1993 by Mark Williams Company.
#	All rights reserved. May not be copied without permission.
#	For copying permission and licensing info, write licensing@mwc.com
# -lgl)

# Shell version to provide a more friendly interface to the 'devadm' system
# to change a device irq setting.

##################### FUNCTION DEFINITIONS #######################

# Output an error message to standard error, prefixed by the command name.

report_error () {
	basename $COMMAND_NAME "" "echo " ": $*" 1>&2
}


# Report a usage message to standard error.

usage () {
	report_error Change device IRQ settings
	cat <<\END 1>&2
usage:	[-f] device unit irq [ipl [type]]
	Change the irq setting of the specified device unit
	-f specifies that conflicting devices be automatically disabled
END
}


# Read the 'sdevice' parameters for a device into shell globals, where the
# device information includes a unit number.

read_sdevice () {
	set -- $1 $2

	WS="[ 	]"
	YN="[YyNn]"
	grep "^$1$WS$YN$WS$2" $SDEV_FILE 2>/dev/null 1>&2

	is_equal $? 0 || {
		report_error There is no 'sdevice' entry for $1
		return 1 
	}

#	set `grep ^$1 $CONF_DIR/mdevice 2>/dev/null`
#	shift
#	MDEV_FUNCS=$1
#	MDEV_FLAGS=$2
#	MDEV_PREFIX=$3
#	MDEV_BLOCK_MAJ=$4
#	MDEV_CHAR_MAJ=$5
#	MDEV_MIN_MIN=$6
#	MDEV_MIN_MAX=$7
#	MDEV_DMA_CHAN=$8
#	MDEV_CPU_ID=$9
	
	set `grep ^$1 $SDEV_FILE 2>/dev/null`
	shift
	SDEV_CONFIG=$1
	SDEV_UNIT=$2
	SDEV_INT_PRI=$3
	SDEV_INT_TYPE=$4
	SDEV_INT_VECT=$5
	SDEV_IOA_LO=$6
	SDEV_IOA_HI=$7
	SDEV_CMA_LO=$8
	SDEV_CMA_HI=$9

	OLD_SDEV_IRQ=$SDEV_INT_VECT
	return 0
}


# Update the value of an sdevice entry parameter

set_irq_sdevice () {
	is_equal $2 $OLD_SDEV_IRQ && return 0	# No effect

	set $1 "$1 $SDEV_CONFIG $SDEV_UNIT ${3-$SDEV_INT_PRI} \
		${4-$SDEV_INT_TYPE} $2 $SDEV_IOA_LO $SDEV_IOA_HI \
	        $SDEV_CMA_LO $SDEV_CMA_HI"

	# Verify that there is nothing conflicting with us
	set $1 "$2" "$($DEVADM -I $CONF_DIR -S"$2" -r 2>&1)"

	is_empty "$3" || {
		has_prefix "$3" $HOME_DIR/devadm && {
			report_error $HOME_DIR/devadm reports the following serious error:
			echo "$3" 2>&1
			return 1
		}
		is_empty "$FORCE_ENABLE" || {
			$HOME_DIR/idenable -d $3
			set $1 "$2" "$($DEVADM -I $CONF_DIR -S"$2" -r)"
		}
		is_empty $3 || {
			report_error Enabling $1 will conflict with $3
			return 1
		}
	}

	$DEVADM -I $CONF_DIR -S"$2" -W
}


. /usr/lib/shell_lib.sh
COMMAND_NAME=$0
source_path $0 "HOME_DIR="
parent_of $HOME_DIR "CONF_DIR="
CONF_PATH="$(pwd):$CONF_DIR:$CONF_DIR/install_conf:$CONF_PATH"

find_file mdevice $CONF_PATH "MDEV_FILE=" \
	"report_error File \'mdevice\' is not found in $CONF_PATH; exit 126"
find_file sdevice $CONF_PATH "SDEV_FILE=" \
	"report_error File \'sdevice\' is not found in $CONF_PATH; exit 126"

DEVADM="$HOME_DIR/devadm -X $MDEV_FILE -Y $SDEV_FILE"

is_equal $# 0 && {
	usage $0 1>&2
	exit 100
}

while getopts f SWITCH ; do
	case $SWITCH in
	-f)	FORCE_ENABLE=1
		;;
	*)	usage
		exit 100
		;;
	esac
done

shift $(($OPTIND - 1))

val $(($# < 3 || $# > 5)) && {
	report_error Bad parameters: $*
	usage
	exit 100
}

read_sdevice $1 $2 || exit 1
set_irq_sdevice $1 $3 $4 $5

