
/*
 *  Gremlin for the X window package.  Hacked from the aed gremlin.
 *
 *  aed version copyright:
 *  Copyright -C- 1982 Barry S. Roitblat
 */
#include "gremlin.h"
#include "grem2.h"
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/param.h>

extern OpaqueFrame	FrameList[];
extern Window GremlinBase;

extern short icons[NUM_WINDOWS][114];
extern short brush_icons[4][114];
extern short font_icons[4][114];
extern short size_icons[4][114];
extern short just_icons[16][114];
extern short adjust_icons[4][114];
extern short buffer_icons[5][114];
extern short point_icons[5][114];

extern Font pointfont, text_win_font;

extern int icon_light[], bang;
extern char input_buffer[];

extern TextPut(), InputText(), RedrawText();

/* imports from config.c */

extern char GMapFile[];

/* database imports */

extern ELT *DBInit(), *DBRead();
extern POINT *PTInit(), *PTMakePoint();

/* imports from menu.c */

extern XHelp(), XCSBlink(), DoBlink();

/* graphics imports */
extern GRInit(), GRClose();
extern GRSetGrid(), GRDisplayGrid(), GRBlankGrid();
extern GRDisableTablet(), GREnableTablet();
extern GRSetMap(), GRsetwmask();
extern GRBlankPoints(), GRShowPoints();
extern artmode;

/* imports from undodb.c */

extern UNForget();
extern UNELT *unlist, *unback;

/* imports from long.c */

extern char *Editfile;
extern LGText(), LGAlign(), LGLittlePoint(), LGPrintPath(), LGCSetPoints();
extern CP(), LGCommand();
extern LGQuit(), LGEdit(), LGSave(), LGDrawPolygon();
extern LGPoint(), LGDeletePoint();
extern LGHAdjust(), LGVAdjust(), LGIncludeSet(), LGMirror();
extern LGRead(), LGWrite(), LGQuit(), LGUndo();
extern LGMPoint(), LGClearPoints(), LGMText(), LGMBrush(), LGMFont();
extern LGMSize(), LGPath(), LGShowPoints(),LGMenu(),savemen();

/* imports from short.c */

extern (*(shrtns[]))();
extern char shcmds[];
extern SHCommand(), SHSetArea();
extern SHRedis();
extern SHUpdate();
extern SHDrawVector();
extern SHDrawArc();
extern SHDrawCurve();
extern SHBox();
extern SHArrow();
extern SHMAdjust();
extern SHGravity(), SHGrid(), SHDefineSet(), SHErase(), SHTranslate();
extern SHCopy(), SHScale(), SHRotate();

/* Forward references within this file: */

extern OnStop();
extern unimplemented();

extern Window w;
extern XChangeBrush(), Strip();
extern XChangeFont();
extern XChangeSize();
extern XChangeJust();
extern XChangeAdjust();
extern XChangeBuffer();
extern XChangeGrid();
extern XBang(), XRelocate();
extern XCSet();

/* Library routines: */

extern char *malloc(), *sprintf(), *strcat(), *strcpy();

/*
 *  jump tables
 */

int (*last_function)();
int (*jump_left[NUM_WINDOWS+1])() = {
	SHDrawVector,
	SHDrawArc,
	SHDrawCurve,
	SHBox,
	SHArrow,
	LGText,
	XChangeBrush,
	XChangeFont,
	XChangeJust,
	XChangeSize,
	XChangeAdjust,
	SHUpdate,
	XBang,
	SHGravity,
	SHGrid,
	SHDefineSet,
	SHSetArea,
	SHErase,
	SHTranslate,
	SHCopy,
	SHScale,
	SHRotate,
	LGMirror,
	LGEdit,
	LGWrite,
	LGQuit,
	LGUndo,
	LGAlign,
	XChangeBuffer,
	LGClearPoints,
	LGMPoint,
	LGPath,
	LGLittlePoint,
	LGCSetPoints,
	XHelp,
	XRelocate,
	LGPoint,
	unimplemented,
};

char left_can_change[NUM_WINDOWS+1] = {
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	0,
	0,
	0,
	0,
	1,
	0,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	1,
	0,
	1,
	1,
	0,
};

int (*jump_middle[NUM_WINDOWS+1])() = {
	LGDrawPolygon,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	LGMText,
	LGMBrush,
	LGMFont,
	unimplemented,
	LGMSize,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	XChangeGrid,
	LGIncludeSet,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	LGMenu,
	savemen,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	LGPrintPath,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	LGDeletePoint,
	unimplemented
};
int (*jump_right[NUM_WINDOWS+1])() = {
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	LGRead,
	LGSave,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
	unimplemented,
};


/* Declaration of Globals */

Window w;
int masked, window_num;

ELT *PICTURE, *cset, arhead;
int CBRUSH, CFONT, CSIZE, CJUST, CBUF, CGRID, Gridon, Orientation;
int Alignment, SEQ, Adjustment, GravityOn, Consume, CHANGED, csetoff, update;
int TextMode, CSETPOINTS = 0;
float PX, PY, Lastx, Lasty;
POINT *POINTLIST, *BACKPOINT, MENPOINT[NUSER];
ELT *MEN[NUSER];
char cmdbuf[400];
int SEARCH = TRUE;
int jmodes = 8;

char *textpos[] = {"bl", "bc", "br", "cl", "cc", "cr", "tl", "tc", "tr",
                   "lb", "cb", "rb", "lc",       "rc", "lt", "ct", "rt" };
char *dispmode[] = {"BL", "BR", "CC", "XX", "XX", "XX", "XX", "XX",
                    "XX", "XX", "TL", "TC", "TR", "CL", "CR", "BC" };
int textmode[] = { 0, 15, 1, 13, 2, 14, 10, 11, 12,
                   0, 15, 1, 13,    14, 10, 11, 12 };

/* symbolic types, brushes, etc. */

char *lines[] = { "broken", "dashed", "dotted",
                  "medium", "narrow", "thick", NULL };
int lnum[] = { 2, 4, 1, 6, 5, 3 };
char types[] = { 'l', 'r', 'c', 'v', 'a', 'u', '\0' };
char *fonts[] = { "Bold", "Italics", "Roman", "Special",
                  "bold", "italics", "roman", "special", NULL };
int fnum[] = { 3, 2, 1, 4, 3, 2, 1, 4 };

XButtonPressedEvent event;

error(s)
char *s;
/*
 *      This routine prints an error message and sets the Consume flag
 * so that points are not cleared.
 */
{
    XFeep(0);
	TextPut(s);
    Consume = FALSE;
}

message(s)
char *s;
/*
 *      This routine prints an informational message and sets the Consume flag
 * so that points are not cleared.
 */
{
	TextPut(s);
}

main(argc, argv)
int argc;
char *argv[];
{
    FILE *fp, *POpen(), *fopen(),*grtty, *tablet, *map, *startup;
    POINT *p1, pos;
    int x1, y1, x2, y2, i, j, count;
    int button, cux, cuy;
    char colours[768], msg[50], sw, *arg, *file;
    char *ptr, *type, *getenv(), home[100];
    char *path = ".";
    ino_t inode;

    file = argv[1];

    PSetPath(path);

	/* signal(SIGINT, SIG_IGN); */
	signal(SIGTSTP, OnStop);
	signal(SIGTTIN, OnStop);
	signal(SIGTTOU, OnStop);

    CBRUSH = 5;
    CFONT = 1;
    CSIZE = 1;
    CJUST = 0;
	CBUF = 0;
	CGRID = 16;
	csetoff = 0;
	update = 0;
	last_function = unimplemented;
    Gridon = FALSE;
    Adjustment = NOADJ;
	TextMode = 0;
    Alignment = 1;
    artmode = FALSE;
    SEQ = 0;
    GravityOn = FALSE;
    CHANGED = FALSE;
    POINTLIST = PTInit();
    BACKPOINT = PTInit();
    unlist = unback = nullun;
    p1 = PTInit();       /* initialize arrowhead template */
    (void) PTMakePoint(0.0, 0.0, &p1);
    (void) PTMakePoint(-5.0, 3.0, &p1);
    (void) PTMakePoint(-3.0, 0.0, &p1);
    (void) PTMakePoint(-5.0, -3.0, &p1);
    (void) PTMakePoint(0.0, 0.0, &p1);
    arhead.type = VECTOR;
    arhead.ptlist = p1;
    arhead.brushf = 0;   /* brush filled in when used */
    arhead.size = 0;
    arhead.textpt = malloc(1);
    *(arhead.textpt) = '\0';

	XInit();

    PICTURE = DBInit();    /* initialize picture databse */
    cset = DBInit();       /* and current set   */
    for (i=0; i<4; ++i)    /* and user symbols  */
        MEN[i] = DBInit();
    unlist = unback = nullun;

        /* read start-up file */
        /* look in home directory */
    sprintf(home,"%s/.gremlinrc",getenv("HOME"));
    startup = fopen(home, "r");
    if (startup != NULL)
    {
        ptr = fgets(cmdbuf, 400, startup);
        while (ptr != NULL)
        {
            for (i=0; (cmdbuf[i] != '\n'); ++i)
                if (i > 399) break;
            cmdbuf[i] = '\0';    /* remove trailing carriage return */
            if (cmdbuf[0] == ':') LGCommand(&(cmdbuf[1]));
            else SHCommand(&(cmdbuf[0]));
            ptr = fgets(cmdbuf, 400, startup);
        }  /* end while */
    }  /* end if startup */
    else inode = 0;

            /* look in current directory */
    startup = fopen(".gremlinrc", "r");
    if (startup != NULL)
    {
		char junk[MAXPATHLEN];
		if(strcmp(getenv("HOME"),getwd(junk))!=0) /* same as before? */
        {
            ptr = fgets(cmdbuf, 400, startup);
            while (ptr != NULL)
            {
                for (i=0; (cmdbuf[i] != '\n'); ++i)
                    if (i > 399) break;
                cmdbuf[i] = '\0';    /* remove trailing carriage return */
                if (cmdbuf[0] == ':') LGCommand(&(cmdbuf[1]));
                else SHCommand(&(cmdbuf[0]));
                ptr = fgets(cmdbuf, 400, startup);
            }  /* end while */
        }  /* end if cwd is home */
    }  /* end if startup */

    Editfile = malloc(100);
    if (file == NULL)
        *Editfile = '\0';
    else
    {
        (void) strcpy(Editfile, file);
        fp = POpen(Editfile, (char **) NULL, SEARCH);
        if (fp == NULL)  error("(creating new file)");
        else PICTURE = DBRead(Editfile,&Orientation, &pos);
    }

	input_buffer[0] = '\0';

	while ( TRUE )    /* Exits through the 'quit' command */
    {
		int events, foo;

        Consume = TRUE;
        UNForget();

		XSync(0);
		if(CSETPOINTS) DoBlink(1);
		XNextEvent(&event);

		for(window_num=0;window_num<=PAGE_WIN+1;window_num++)
			if(event.window == FrameList[window_num].self)
				goto gotit;
		/* must have been for the Base or Help window */
		if(event.type == ExposeWindow && event.window == GremlinBase)
			XRedrawBaseWin();
		update = 0;
		continue;
gotit:
		if(event.type == ExposeWindow)
		{
			switch(window_num) {
			case 6:
				XBitmapBitsPut(event.window,0,0,38,38,brush_icons[CBRUSH],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				break;
			case 7:
				XBitmapBitsPut(event.window,0,0,38,38,font_icons[CFONT],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				break;
			case 8:
				XBitmapBitsPut(event.window,0,0,38,38,just_icons[CJUST],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				break;
			case 9:
				XBitmapBitsPut(event.window,0,0,38,38,size_icons[CSIZE],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				break;
			case 10:
				XBitmapBitsPut(event.window,0,0,38,38,adjust_icons[Adjustment],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				break;
			case 14:
			{
				char num[5];

				sprintf(num,"%d",CGRID);
				XBitmapBitsPut(event.window,0,0,38,38,icons[window_num],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				XText(FrameList[14].self,10,10,num,strlen(num),pointfont,WhitePixel,BlackPixel);
				break;
			}
			case 27:
			{
				char num[5];

				sprintf(num,"%4d",Alignment);
				XBitmapBitsPut(event.window,0,0,38,38,icons[window_num],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				XText(FrameList[27].self,1,1,num,strlen(num),pointfont,WhitePixel,BlackPixel);
				break;
			}
			case 28:
				XBitmapBitsPut(event.window,0,0,38,38,buffer_icons[CBUF],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				break;
#ifdef notdef
			case 28:
				XBitmapBitsPut(event.window,0,0,38,38,point_icons[artmode],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				break;
#endif notdef
			default:	/* all other cases < PAGE_WIN */
				XBitmapBitsPut(event.window,0,0,38,38,icons[window_num],BlackPixel,WhitePixel,0,icon_light[window_num],AllPlanes);
				update = 0;
				break;
			case PAGE_WIN:
			{
				if(!update)
				{
					SHUpdate();
					update = 1;
				}
				break;
			}
			case PAGE_WIN+1:
				RedrawText();
				break;
			}
		}
		else
		{
			update = 0;
			if(event.type == KeyPressed)
			{
				int bcount;
				char* input;

				input = XLookupMapping((XKeyPressedEvent*)&event,&bcount);
				if(bcount ==1)
					InputText(input);
			}
			else
			if(event.type == ButtonPressed)
			{
				masked = event.detail&255;
				PX = event.x;
				PY = event.y;
				if(masked&LeftButton)
				{
					if(window_num!=PAGE_WIN && CSETPOINTS &&
						left_can_change[window_num]) DoBlink(0);
					if(event.window!=FrameList[PAGE_WIN].self)
						last_function = jump_left[window_num];
					(*jump_left[window_num])();
				}
				else
				if(masked&MiddleButton)
				{
					if(window_num!=PAGE_WIN && CSETPOINTS) DoBlink(0);
					if(event.window!=FrameList[PAGE_WIN].self)
						last_function = jump_middle[window_num];
					(*jump_middle[window_num])();
				}
				else
				{
					if(window_num==PAGE_WIN)
					{
						if(CSETPOINTS) DoBlink(0);
						(*last_function)();
					}
					else
					{
						last_function = jump_right[window_num];
						if(CSETPOINTS && last_function != unimplemented)
							DoBlink(0);
						(*jump_right[window_num])();
					}
				}
				if(Consume) CP();
				if(bang)
					if(!--bang)
						MNUnHighLt(12);
			}
			else
				fprintf(stderr,"gremlin internal error--bad event type\n");
		}
    }  /* end while */
}  /* end main */


OnStop(signo)
int signo;
{
    signal(signo, SIG_DFL);
    sigsetmask(0);
    (void) kill(0, signo);
    signal(signo, OnStop);
}

unimplemented()
{
	XFeep(0);
	TextPut("not implemented.");
	Consume = FALSE;
}
