
/*
 *  Gremlin for the X window package.  Hacked from the aed gremlin.
 *  
 *  aed version copyright:
 *  Copyright -C- 1982 Barry S. Roitblat
 */
#include "gremlin.h"

extern MNHighLt(), MNUnHighLt();
extern OpaqueFrame FrameList[];
extern TextPut();
extern short icons[][114];
extern Font text_win_font;
extern Consume;
extern Window GremlinBase;
extern Window HelpWindow;

char *lbm[NUM_WINDOWS+1][3] = {
{
	"Draws vectors connecting the placed points.",
	"",
	"",
},
{
	"Draws an arc centered at point 0, starting at point 1, and heading towards point 2",
	"If point 2 is not specified, a circle is drawn.  BUGS: small circles aren't round.",
	"Occasionaly, there's a pixel missing.  Thick brushes don't totally erase.",
},
{
	"Draws a quadratic spline connecting the placed points.",
	"",
	"",
},
{
	"Draws a rectangle using the first two points as opposite corners.",
	"",
	"",
},
{
	"Draws an arrowhead with the tip at point 0, coming from point 1.",
	"",
	"",
},
{
	"Enters text at point 0.",
	"GRN BUG: ln01 text is slightly lower (about 3 pixels) than X text.",
	"",
},
{
	"Changes the current brush style.  The current brush is displayed in",
	"the icon window.",
	"",
},
{
	"Changes the current font.  R=roman, I=italics, B=bold, S=special.",
	"",
	"",
},
{
	"Changes the current justification mode.",
	"",
	"",
},
{
	"Changes the current font size.",
	"",
	"",
},
{
	"Changes the adjustment mode.",
	"",
	"",
},
{
	"Redraws the page window.",
	"",
	"",
},
{
	"Toggles safe mode.  When this icon is unlit (safe) and the picture has been",
	"changed since the last write, gremlin refuses to read a new picture or",
	"quit until the current picture has been saved. Turns itself off shortly.",
},
{
	"Toggles gravity mode.  When this icon is lit, points will gravitate",
	"towards existing points.",
	"",
},
{
	"Toggles the grid.",
	"",
	"",
},
{
	"Define set:  The current set is defined to be the element(s) closest to",
	"any points.  No points specified will define the entire picture as",
	"the current set.",
},
{
	"Box define set:  the current set becomes all objects entirely",
	"contained within the rectangle defined by the first two points.",
	"",
},
{
	"Deletes the current set.",
	"",
	"",
},
{
	"Moves the current set.  The displacement is relative to the first two",
	"points.",
	"",
},
{
	"Copies the current set.  The displacement of the copy is relative to the",
	"first two points.  Multiple copies may be made.  The current set becomes",
	"the last copy.",
},
{
	"Scale current set using the first three points.  The scaling factor is",
	"the ratio of the distance between the first two points and the first and",
	"third points.",
},
{
	"Rotate current set at point 0.  The angle between line 0,1 and line 0,2",
	"is the angle of rotation.",
	"",
},
{
	"Mirrors current set at point 0.  Mirrors horizontal if point 2 and point 1",
	"are on opposite x sides of point 0, vertical if point 2 and point 1 are on",
	"opposite y sides of point 0.",
},
{
	"Edits the filename that is contained in the text buffer.","","",
},
{
	"Writes the picture to the current editfile.",
	"",
	"",
},
{
	"Quits gremlin.",
	"",
	"",
},
{
	"Undos the last gremlin operation.",
	"",
	"",
},
{
	"Sets the alignment to the integer contained in the text buffer or the",
	"current grid size.",
	"",
},
{
	"Selects the current set buffer.  The number of the buffer is displayed",
	"in the icon.",
	"",
},
{
	"Clears excess points from the display.",
	"",
	"",
},
{
	"The element of the current set which contains the point closest to the",
	"first point is redrawn with that point replaced by the remaining points.",
	"(deleted if no other points)",
},
{
	"Set the search path for reading gremlinfiles.",
	"Components are seperated by colons.  :: is taken to mean the current",
	"directory.",
},
{
	"Toggles the image of points.",
	"",
	"",
},
{
	"When this icon is lit, line elements in the current set will be displayed",
	"with shorter brush patterns.  Text elements are inverted.",
	".",
},
{
	"Help: after selecting this icon, click any mouse button in the icon for",
	"which help is wanted.  The help window will stay displayed until",
	"another mouse button is clicked.",
},
{
	"Relocates all of the Gremlin windows to their initial positions.",
	"",
	"",
},
{
	"Lays down a point at the current mouse location.","","",
},
{
	"","","",
},
};
char *mbm[NUM_WINDOWS+1][3] = {
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "Changes the text of all text elements in the current set to be the text",
  "in the text buffer.","",},
{ "Changes the brush of all line elements in the current set to be the brush",
   "displayed in the icon.","",},
{ "Changes the font of all text elements in the current set to be the font",
  "displayed in the icon.","",},
{ "","","",},
{ "Changes the size of all text elements in the current set to be the size",
  "displayed in the icon.","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "Sets the grid size.  The text buffer should contain an integer.","","",},
{ "For each point laid down, the element nearest to it is added to the",
  "current set.","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "Read in from the specified buffer.  Requires a point that specifies the",
  "place to be used for top left corner of the page window.","",},
{ "Write the current set into the selected buffer.","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "Prints the current search path.","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "Removes the last point.","","", },
{ "","","",},
};
char *rbm[NUM_WINDOWS+1][3]={
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ 
	"Reads in the file named in the text buffer.  May be given a positioning point.",
	"",
	"BUG: positioning point is flakey.",},
{ "Writes the current set to the file specified by the text buffer.","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "","","",},
{ "Repeats the last function.","","BUG: auto redraw doesn't always work.",},
{ "","","",},
};

XHelp()
{
	XEvent event;
	int count;
#define Xprintf(x,y,s) \
	XText(HelpWindow, (x), (y), (s), strlen(s), \
		text_win_font, BlackPixel, WhitePixel)
#define XTextHeight 15

	MNHighLt(34);
	XSync(0);
	XNextEvent(&event);
	MNUnHighLt(34);
	if(event.type==ButtonPressed)
	{
		for(count=0;count<=PAGE_WIN+1;count++)
			if(event.window==FrameList[count].self)
				break;
		if(count > PAGE_WIN+1) {
			TextPut("That window is not used.");
			return;
		}
	} else {
		XPutBackEvent(&event);
		TextPut("Select Help, then select an icon with any button.");
		return;
	}
	XMapWindow(HelpWindow);
	if(count<PAGE_WIN)
		XBitmapBitsPut(HelpWindow, 10, 10, 38, 38,
			icons[count], BlackPixel, WhitePixel, 0, GXcopy, AllPlanes);
	else
	if(count==PAGE_WIN)
		Xprintf(10,10,"Page Window");
	else	
		Xprintf(10,10,"Text Window");
	Xprintf(10,80,"Left Button:");
	Xprintf(10,100,lbm[count][0]);
	Xprintf(10,120,lbm[count][1]);
	Xprintf(10,140,lbm[count][2]);
	Xprintf(10,180,"Middle Button:");
	Xprintf(10,200,mbm[count][0]);
	Xprintf(10,220,mbm[count][1]);
	Xprintf(10,240,mbm[count][2]);
	Xprintf(10,280,"Right Button:");
	Xprintf(10,300,rbm[count][0]);
	Xprintf(10,320,rbm[count][1]);
	Xprintf(10,340,rbm[count][2]);
	XSync(0);
	XMaskEvent(KeyPressed|ButtonPressed, &event);
	if(event.type!=ButtonPressed) {
		XPutBackEvent(&event);
	}
	XUnmapWindow(HelpWindow);
	Consume = FALSE;
	return;
}

