.TH GREMLIN 1 
.UC 4
.SH NAME
gremlin \- picture editor under X
.SH SYNOPSIS
.B gremlin
.br
.SH DESCRIPTION
.I Gremlin
is an interactive picture editor for producing line drawings.  This version of
.I gremlin
displays a rough estimate of the current picture using the 
.I X
window package.  Output produced by the
.I Gremlin
program is converted by
.I grn(1)
to produce roff commands.

.SH THE X INTERFACE
.I Gremlin
uses the environment variable DISPLAY to determine which display to use.
Format of DISPLAY should be <host>:<display number>.  If DISPLAY is null,
the current host and display 0 is assumed.  The display
must have the current host in the
.I X
host table (see xhost(1) for more detailed information).
.I Gremlin
displays several (currently 36) small windows used for menu icons, one large
window for the picture, and one thin window for I/O and error reporting
(the top line of the I/O window is used to display the current file being
edited, the second for error reporting, and the third displays the text
buffer).  Each of these windows may be moved/lowered/iconified as desired,
however the picture window may not redraw (temporary bug).
Resizing should not occur on the picture window in the y (vertical) 
direction (temporary bug).
.I Gremlin
does not `grab' any mouse buttons or mouse/control-key combinations, so
it may be used simultaneously with other
.I X
application programs.  However, using window managers that
grab normal mouse buttons (ex. xwm(1) -n, xnwm(1) -n) will require
using keycomp(1) to add keystrokes so that the mouse buttons and keystrokes
are on the same `level'.

.SH THE MENU ICON COMMAND INTERFACE
.I Gremlin
commands (explained below) may be invoked by pressing a mouse button while
the cursor in a menu icon.  Different mouse buttons perform different commands
in the same menu icon.  Icons may also `invert' colors, signifying that a
binary option is set.
Help identifying and briefly explaining the icons may be obtained using the
.B ?
(help) icon.  Place the cursor in the
.B ?
icon and press the left mouse button.  The icon will invert and
.I Gremlin
will wait for another mouse button in any window and then display a help
window for that icon.  The help window will be displayed until another
.I X
event is recieved.

.SH THE TEXT COMMAND INTERFACE
.I Gremlin
commands may also be invoked directly from the keyboard.  There are two
types of text commands.  The short, one letter commands are designed to
allow commonly used commands to be invoked without moving the cursor from
the picture window.  The letters for these commands are not intended to
be mnemonic; rather they all lie on the left side of the keyboard within
reach of the left hand.  Any key typed while the cursor is not in the
I/O window will be interpreted as a short command (unless gremlin in
in text mode, explained below).

Long commands must be entered when the cursor is in the I/O window (barring
text mode again).  These commands are less frequently used commands and
commands that take arguements.

.SH TEXT MODE AND THE TEXT BUFFER
.I Gremlin
has two modes of operation: normal and text.  In normal mode, all keys typed
while the cursoris not in the I/O window will be interpreted as short
commands.  The mouse cursor resembles crosshairs when gremlin is in normal
mode.  Text mode allows long commands to be entered while the mouse is not
in the I/O window, and is entered by a : or a tab.  The cursor will change
to a pencil.  All key presses will then be entered into the text buffer.
Simple editing may be performed with ^H (character erase) and ^U (line
erase).  Command interpretation will occur when a carriage return is
encountered and text mode will be exited.

The text buffer is also used to supply arguements to the menu icons.

.SH THE MOUSE INTERFACE
.I Gremlin
uses mouse button presses while the cursor is in the picture window to
define points that are used in almost all commands.  The left button
will place a point at the current cursor location.  The middle button
will erase the last point.  The right button will reinvoke the last menu icon
command.

.SH GREMLIN COMMANDS
     Following is a list of the commands available under 
.I gremlin
and an explanation of their use.  

.ll -.5i
.in +.5i
.ti -0.5i
.B "^L - Update Screen."
     The delete command may leave blank spots on the screen where objects 
overlapped.  These blank spots do not actually exist in the picture and can
be properly observed by updating the screen.

.ti -0.5i
.B "1,2,3,4 - Save current set in set buffer."
     The current set is copied into the specified set buffer
for possible later retrieval.  

.ti -0.5i
.ti -.5i
.B "a - Draw Arc."
     The command uses 3 points to define an arc.  The first point determines
the center of a circle.  The second defines a radius and, thus, is a point on
the circle.  The third point is optional and, if specified, determines a 
counter-clockwise angle from the second point which is the extent of the arc.
If the third point is omitted, or the angle is 0, a full circle is drawn.

.ti -.5i
.B "b - Draw curve."
     Draw a smooth curve through the specified points.

.ti -0.5i
.B "c - Copy Current Set."
     Copying uses 2 or more points.  Copying is similar to translation except
that a copy of the current set is displaced to each of the remaining points.

.ti -0.5i
.B "d - Define Current Set."
     This command uses points to select elements for the current set.
The points should be near, or touching, the reference points of the desired
elements. (gravity can be used to aid when laying down the points).  If no
points are specified, the entire picture becomes the current set.  The previous
contents of the current set are no longer selected.

.ti -0.5i
.B "e - Erase."
     This command erases all elements currently defined in the current set.  

.ti -0.5i
.B "f - Select Area for Current Set"
     Two points are used to define a rectangle (the points are the endpoints
of the diagonal of the rectangle).  All elements which lie \fBentirely\fR within the
rectangle are selected to define the current set.  The previous elements of
the current set are no longer selected.  The rectangle is not displayed.

.ti -0.5i
.B "g - Gravity."
     This command toggles each time the command is invoked.
When on, gravity forces a point to coincide with the nearest
existing point or reference point.  Gravity will only take effect, however,
if the cursor is near enough to an element in the picture.

.ti -0.5i
.B "q - Display Grid."
     This command also toggles each time it is invoked.  The
display grid command causes a grid to appear on the graphic
screen.  The grid spacing is 16 pixels.

.ti -0.5i
.B "r - Rotate Current Set"
     Three points are used to define a rotation.  The rotation is performed,
relative to the first point, through an angle formed by the lines 
between points 1 and 2 and points 1 and 3 respectively.

.ti -0.5i
.B "s - Scale Current Set."
     Scaling uses three points to define a transformation.  The current set
in scaled by the ratio of the distances between the first and second and the
first and third points.

.ti -0.5i
.B "t - Translate (move) Current Set."
     This command uses 2 points.  The current set is displaced by the
relative distance between the points.

.ti -0.5i
.B "u - undo."
	 Undos the last operation.

.ti -.5i
.B "v - Draw Vectors."
     Connects each of the points laid down, in the order specified, with 
lines.

.ti -.5i
.B "w - Draw arrowhead."
     This command uses two points.
The first point represents
the point in the picture where the tip of the arrowhead is to be drawn. 
The second point indicates the direction the arrow is to point. 

.ti -.5i
.B "x - Draw box"
     This command uses two points defining the endpoints of the diagonal
of a rectangle and draws that rectangle.  

.ti -.5i
.B "z - Manhattan Adjust."
     This command combines horizontal and vertical adjustment 
to automatically force each point to be directly horizontal or 
vertical with respect to the previous point, whichever it is closer to.

.ti -0.5i
.B ":align n - Alignment."
     This command forces points to be aligned on pixel boundaries
as specified by the parameter (i.e. if alignment is 10, all points will
fall at pixels with addresses evenly divisible by 10).  If no parameter is
specified, the alignment will toggle between 1 and the grid size.

.ti -0.5i
.B ":brush n - Select brush n."
     Currently, there are 6 brush types available called 'dotted', 'broken', 'thick', 'dashed', 'narrow', and 'medium'.  The brushes may also be selected by a number, 1-6, in the above order.

.ti -0.5i
.B ":buffer n - Retrieve set buffer."
     This command provides a means for selecting the sets stored in 
buffers from the keyboard.  The menu symbols are numbered top to bottom, 
left to right. This command requires one or more positioning points
to indicate where in the picture the buffer is to be copied, and a copy
of the buffer is made at each point.

.ti -0.5i
.B ":clearpoints - Clear points."
     The \fB:clearpoints\fR command is used to clear (remove) the 
unused points on the screen.

.ti -0.5i
.B ":deletepoint - Delete point. "
.sp 1
     This command erases the last point specified (same as the delete point
button on the cursor).

.ti -0.5i
.B ":edit - Edit file."
     This command causes a new file to be opened for editing.  The state of the
current picture is not preserved except that any symbols defined in the menu
buffers are maintained.  

.ti -.5i
.B ":font n - Select font n."
     The fonts are selected by a name of Roman, Italics, Bold,
or Special respectively.  Fonts may also be specified by an integer
between 1 and 4 according to the above order.

.ti -.5i
.B ":hadjust - Horizontal Adjust."
     This mode is toggled (on or off) each time the command is invoked.  
When on, horizontal adjustment forces each point laid down to
lie on a horizontal line from the previous point (i.e. only horizontal     
displacement of the cursor is used).  

.B ":halftone - halftone Current Set."
	This mode is toggled (on or off) each time the command is invoked.
When on, line elements in the current set will be displayed with a shorter
brush.  Text elements will appear in inverse video.

.ti -0.5i
.B ":includeset - Include in Current Set"
     The selected elements are added to the current set along with whatever
elements currently comprise the set.

.ti -0.5i
.B ":justify - Text justification mode"
     This command specifies the current text justification mode.  Text can
be justified at the bottom, center, or top vertically and at the left, center,
or right horizontally.  The justification is specified as a 2 character code
representing the horizontal and vertical justification mode.  The characters
can be entered in either order, upper or lower case, but should not be 
separated by spaces.  Ex: To justify a string at the left and bottom, the 
justification code could be entered as 'BL', 'bl', 'LB', or 'lb'.

.ti -0.5i
.B ":littlepoint - Point size control"
     This command toggles the point display between the standard "+" followed
by an integer and a smaller "+" with no number.

.ti -0.5i
.B ":mbrush brush - Modify brush."
     This command causes the picture elements in the current set to be redrawn 
with a new brush.

.ti -0.5i
.B ":mfont font - Modify font."
     This command causes any text picture elements in the current set to be 
redisplayed in a new font.

.ti -0.5i
.B ":mirror - mirror current set."
     Three points are also used to define a mirroring.  The mirroring takes
place about the x and/or y axes respectively if the third point is on the
opposite side of the first from the second in the x or y direction.

.ti -0.5i
.B ":mpoint - Move point."
     This command uses one or more points and causes the element of the current
set which  contains the point closest to the first of these points to be
redrawn with that point replaced with the remaining points.

.ti -0.5i
.B ":msize size - Modify size."
     This command causes any text picture elements in the current set to be 
redisplayed in a new character size.

.ti -0.5i
.B ":mtext text - Modify text."
     This command causes any text picture elements in the current set to be 
replaced with the text string specified.

.ti -0.5i
.B ":path string   	Set path."
The search path contains the names of one or more 
directories that \fIgremlin\fR will examine in order when opening files
for reading, it searches for the file in each of the directories in the
path until the open succeeds.  If no directory in the path contains the
file, one more attempt will be made to read the file from the gremlin
library.  If the original file name begins with a "~" or "/" then the 
path mechanism is bypassed and \fIgremlin\fR searches only in one place.
      \fIString\fR contains one or more directory names separated by colons
(":").  Directories may be specified using the "~" notation and "::" is 
equiavlent to ":.:".  If \fIstring\fR is not specified, the current path
is printed.  The search path mechanism is used only for reading files.

.ti -.5i
.B ":point x y - Place point. "
     This command is used as a means for placing points in the picture area
from the text terminal similar to the green mouse button.  
\fIX\fR and \fIy\fR are the coordinates of the point to be placed.  

.ti -0.5i
.B ":quit - Quit."
     Quit ends the edit session.

.ti -0.5i
.B ":read filename - Read Picture file"
     The symbol defined in file \fIfilename\fR is read into the picture
as the current set.  

.ti -0.5i
.B ":saveset filename - Write the current set."
     Write out the current set to the specified file.

.ti -0.5i
.B ":showpoints - Show reference points."
     Display reference points of all elements in the current set.

.ti -.5i
.B ":size n - Select size n."
     This command chooses the size of the  current font.  The user has
a choice of 4 sizes designated by integers 1 though 4.  By convention, size 1
is usually the smallest and 4, the largest, but it is not necessary that they
be printed that way when hard copy is produced.

.ti -.5i
.B ":text string - Insert Text "
     Text the string is added to the picture appropriately justified (as
determined by the current text justification mode) on the point or points
specified.  Text is entered following the command (but
preceded by a space) and is terminated by a carriage return.

.ti -0.5i
.B ":undo - undo last command."
     This command undoes the last command (even if it was an undo command) 
the same as the blue mouse button.

.ti -.5i
.B ":vadjust - Vertical Adjust."
     This command is similar to horizontal adjust except that points are forced
vertical from their predecessors.  

.ti -0.5i
.B ":write filename - Write edit file."
     Write out the picture to the current or specified edit file.

.SH GREMLIN STARTUP FILES
Gremlin looks first in the current directory and then in the home directory
for the file
.I .gremlinrc.
Text commands placed in this file will be executed during initialization.

.SH "SEE ALSO"
gprint(1)
.br
grn(1)
.br
The Gremlin Picture Editor -- users manual.

.SH AUTHOR
Barry Roitblat.  Hacked for X by Dick Leban, University of Wisconsin
Computer Systems Lab.

.SH BUGS UNDER X
Thick styles don't erase completely.

.SH GRN BUGS
Text on an ln01 appears about three mvax pixels lower.

