.TH XSHELL 1 "31 October 1985" "X Version 10"
.SH NAME
xshell - X Window System, key/button command exec
.SH SYNOPSIS
.B xshell
[ \fIoptions\fP ] [ \fIhost\fP:\fIdisplay\fP ] ...
.SH DESCRIPTION
.I Xshell
is a program for starting up X applications with a single key or button
stroke.  It displays a scallop shell icon in which button and key
presses stand for different commands.  The user can bind a command string
to any key or button by inserting a line like the following in his or her 
\fI.Xdefaults\fP file:
.PP
.nf
    xshell.action.keyname:   command to be exec'ed
.fi
.PP
Keynames are simply letters, numbers, and symbols as they appear on the
keyboard (e.g. a, $, 9), or one of the following special names (taken from 
the X keyboard definitions):
.PP
.nf
    KEYPAD0              FUNC1            E1
    KEYPAD.              FUNC2            E2
    ENTER                FUNC3            E3
    KEYPAD1              FUNC4            E4
    KEYPAD2              FUNC5            E5
    KEYPAD3              FUNC6            E6
    KEYPAD4              FUNC7            LEFTARROW
    KEYPAD5              FUNC8            RIGHTARROW
    KEYPAD6              FUNC9            DOWNARROW
    KEYPAD,              FUNC10           UPARROW
    KEYPAD7              FUNC11           SHIFT
    KEYPAD8              FUNC12           CONTROL
    KEYPAD9              FUNC13           LOCK
    KEYPAD-              FUNC14           SYMBOL
    PF1                  FUNC15
    PF2                  FUNC16
    PF3                  FUNC17
    PF4                  FUNC18
    LEFTBUTTON           FUNC19
    MIDDLEBUTTON         FUNC29
    RIGHTBUTTON

.fi
.PP
Thus, the following `.Xdefaults' definitions specify that the Left Button
will spawn a terminal window, the Middle Button an editor, the Right Button
a calculator, $ a Bourne shell, and # a superuser shell:
.PP
.nf
    xshell.action.LeftButton:       xterm =80x65-0+0 -fn 6x10
    xshell.action.MiddleButton:     xted =80x65+0-0 
    xshell.action.RightButton:      xterm =20x20-0-0 -fn 6x10 -e dc
    xshell.action.$:                xterm =80x65+0+0 -fn 6x10 -e sh
    xshell.action.#:                xterm =80x65+0+0 -fn 6x10 -e su
.fi
.PP
.I Xshell
breaks the command string up into words by removing all white space (i.e.
tabs and spaces) and uses the vfork() and execvp() system calls to spawn
off the command.  A more complicated parsing algorithm could easily be
added, but the current method is adequate (and fast and memory efficient).
.PP
One thing to keep in mind is that 
.I xshell
is NOT a window manager.  It was written to make popping up frequently used
utilities as painless as possible (how many times have you found that you
need just 1 more window....).  It might make a nice addition to some of
the more verbose window managers, but it runs quite nicely as a separate
program.

.SH ARGUMENTS
.PP
.I Xshell
is designed to be somewhat compatible with 
.I xclock
in the arguments that it takes.  However, 
.I xshell 
will allow you to abbreviate its longer flags to any length you chose.  Thus,
the \-reverse flag can be spelled out, given as \-rev, or even just \-r:
.PP
.TP 10
.B \-fg \fIcolor\fP
On color displays, determines the color of the foreground.
.PP
.TP 10
.B \-bg \fIcolor\fP
On color displays, determines the color of the background.
.PP
.TP 10
.B \-bd \fIcolor\fP
On color displays, determines the color of the border.
.PP
.TP 10
.B \-bw \fIpixels\fP
Specify the width in pixels of the border around the
.I xshell
window.
.PP
.TP 10
.B \-v\[olume\] \fIn\fP
Volume for calls to \fIXFeep\fP, used when errors (such as unbound key) are found.
.PP
.TP 10
.B \-f\[lash\] \fIn\fP
Number of times to flash the shell window to acknowledge a button or key press.
.PP
.TP 10
.B \-d\[elay\] \fIn\fP
One-hundredths of a second to wait between flashs (default is 5).
.PP
.TP 10
.B \-r\[everse\]
Reverse video (swap foreground and background).
.PP
.TP 10
.B \-q\[uiet\]
Do not `feep' on errors (see volume).
.PP
.TP 10
.B \-s\[mall\]
Use a smaller (48x48) version of the shell icon.  The default icon is 96x96.
.PP
.TP 10
.B =\fIgeometry\fP
By default 
.I xshell
will create a window the size of whatever icon you select; the standard X
window geometry argument will override this.
See \fIX(1)\fP for details.
.PP
.TP 10
.B \fIhost\fP:\fIdisplay\fP
specifies the display on which to put the
.I xshell
window.  This overrides the DISPLAY environment variable.

.SH X DEFAULTS
.PP
To make invoking 
.I xshell
easier, each of the flags listed above may be specified in the user's
\fI.Xdefaults\fP file:
.PP
.TP 10
.B Foreground
gives the foreground color.
.PP
.TP 10
.B Background
gives the background color.
.PP
.TP 10
.B Border
gives the border color.
.PP
.TP 10
.B BorderWidth
gives the border width.
.PP
.TP 10
.B ReverseVideo
if "on", the shell icon should be white on black instead of black on white.
.PP
.TP 10
.B Volume
gives the volume to use in calls to XFeep().
.PP
.TP 10
.B Flash
gives the number of times to flash the shell window to acknowledge key or
button presses.
.PP
.TP 10
.B Delay
gives hundredths of a second to wait in between flashes.
.PP
.TP 10
.B Quiet
prevents 
.I xshell
from feeping at you when you mistype.
.PP
.TP 10
.B IconSize
if "small", a halfsize (48x48) version of the scallopshell is used.
.PP
.TP 10
.B WindowGeometry
gives the shell window size using standard X =WxH+X+Y notation.

.SH ENVIRONMENT
.PP
.PP
.TP 10
.B DISPLAY
To get the default host and display number.

.SH SEE ALSO
xwm(1), xnwm(1), X(1), execl(3), vfork(2)
.SH DIAGNOSTICS
If 
.B \-quiet
is not given on the command line or
``xshell.Quiet: on''
does not appear in the user's \fI.Xdefaults\fP,
.I xshell
will `feep' if a key or button is pressed for which there is no definition
in the \fI.Xdefaults\fP file.
.SH AUTHOR
.PP
Copyright 1985, Cognition Inc.
.PP
Jim Fulton (Cognition Inc.)
.SH BUGS
.I Xshell
uses the XGetDefault call to fetch the command string for a given key.  Thus,
you cannot bind the colon (``:'') character to a command.
.PP
A more `user-friendly' interface could include dialog boxes that the user
could pop up to type in a command directly so that a full shell doesn't have
to be started.  Then again, it is nice and compact now and if you really 
need to do that more than once you should use a real shell.
.PP
This program along with
\fIxwm(1)\fP and \fIxnwm\fP have been mostly superceded by \fIuwm(1)\fP.

