


RCSINTRO(1)         UNIX Programmer's Manual          RCSINTRO(1)



NAME
     rcsintro - introduction to RCS commands

DESCRIPTION
     The Revision Control System (RCS) manages multiple revisions
     of text files.  RCS automates the storing, retrieval, log-
     ging, identification, and merging of revisions. RCS is use-
     ful for text that is revised frequently, for example pro-
     grams, documentation, graphics, papers, form letters, etc.

     The basic user interface is extremely simple. The novice
     only needs to learn two commands: _c_i and _c_o. _C_i, short for
     "checkin", deposits the contents of a text file into an
     archival file called an RCS file. An RCS file contains all
     revisions of a particular text file.  _C_o, short for
     "checkout", retrieves revisions from an RCS file.

     Functions of RCS

     o+    Storage and retrieval of multiple revisions of text.
          RCS saves all old revisions in a space efficient way.
          Changes no longer destroy the original, because the
          previous revisions remain accessible. Revisions can be
          retrieved according to ranges of revision numbers, sym-
          bolic names, dates, authors, and states.

     o+    Maintenance of a complete history of changes. RCS logs
          all changes automatically.  Besides the text of each
          revision, RCS stores the author, the date and time of
          checkin, and a log message summarizing the change.  The
          logging makes it easy to find out what happened to a
          module, without having to compare source listings or
          having to track down colleagues.

     o+    Resolution of access conflicts. When two or more pro-
          grammers wish to modify the same revision, RCS alerts
          the programmers and prevents one modification from cor-
          rupting the other.

     o+    Maintenance of a tree of Revisions. RCS can maintain
          separate lines of development for each module. It
          stores a tree structure that represents the ancestral
          relationships among revisions.

     o+    Merging of revisions and resolution of conflicts.  Two
          separate lines of development of a module can be
          coalesced by merging.  If the revisions to be merged
          affect the same sections of code, RCS alerts the user
          about the overlapping changes.

     o+    Release and configuration control. Revisions can be
          assigned symbolic names and marked as released, stable,



Printed 1/10/87              6/29/83                            1






RCSINTRO(1)         UNIX Programmer's Manual          RCSINTRO(1)



          experimental, etc.  With these facilities, configura-
          tions of modules can be described simply and directly.

     o+    Automatic identification of each revision with name,
          revision number, creation time, author, etc.  The iden-
          tification is like a stamp that can be embedded at an
          appropriate place in the text of a revision.  The iden-
          tification makes it simple to determine which revisions
          of which modules make up a given configuration.

     o+    Minimization of secondary storage. RCS needs little
          extra space for the revisions (only the differences).
          If intermediate revisions are deleted, the correspond-
          ing deltas are compressed accordingly.


     Getting Started with RCS

     Suppose you have a file f.c that you wish to put under con-
     trol of RCS. Invoke the checkin command

               ci  f.c

     This command creates the RCS file f.c,v, stores f.c into it
     as revision 1.1, and deletes f.c.  It also asks you for a
     description. The description should be a synopsis of the
     contents of the file. All later checkin commands will ask
     you for a log entry, which should summarize the changes that
     you made.

     Files ending in ,v are called RCS files (`v' stands for
     `versions'), the others are called working files.  To get
     back the working file f.c in the previous example, use the
     checkout command

               co  f.c

     This command extracts the latest revision from f.c,v and
     writes it into f.c. You can now edit f.c and check it back
     in by invoking

               ci  f.c

     _C_i increments the revision number properly. If _c_i complains
     with the message

               ci error: no lock set by <your login>

     then your system administrator has decided to create all RCS
     files with the locking attribute set to `strict'. In this
     case, you should have locked the revision during the previ-
     ous checkout. Your last checkout should have been



Printed 1/10/87              6/29/83                            2






RCSINTRO(1)         UNIX Programmer's Manual          RCSINTRO(1)



               co  -l  f.c

     Of course, it is too late now to do the checkout with lock-
     ing, because you probably modified f.c already, and a second
     checkout would overwrite your modifications. Instead, invoke

               rcs  -l  f.c

     This command will lock the latest revision for you, unless
     somebody else got ahead of you already. In this case, you'll
     have to negotiate with that person.

     Locking assures that you, and only you, can check in the
     next update, and avoids nasty problems if several people
     work on the same file.  Even if a revision is locked, it can
     still be checked out for reading, compiling, etc. All that
     locking prevents is a CHECKIN by anybody but the locker.

     If your RCS file is private, i.e., if you are the only per-
     son who is going to deposit revisions into it, strict lock-
     ing is not needed and you can turn it off.  If strict lock-
     ing is turned off, the owner off the RCS file need not have
     a lock for checkin; all others still do. Turning strict
     locking off and on is done with the commands

               rcs  -U  f.c       and         rcs  -L  f.c

     If you don't want to clutter your working directory with RCS
     files, create a subdirectory called RCS in your working
     directory, and move all your RCS files there. RCS commands
     will look first into that directory to find needed files.
     All the commands discussed above will still work, without
     any modification. (Actually, pairs of RCS and working files
     can be specified in 3 ways: (a) both are given, (b) only the
     working file is given, (c) only the RCS file is given. Both
     RCS and working files may have arbitrary path prefixes; RCS
     commands pair them up intelligently).

     To avoid the deletion of the working file during checkin (in
     case you want to continue editing), invoke

               ci  -l  f.c        or          ci  -u  f.c

     These commands check in f.c as usual, but perform an impli-
     cit checkout. The first form also locks the checked in revi-
     sion, the second one doesn't. Thus, these options save you
     one checkout operation.  The first form is useful if locking
     is strict, the second one if not strict.  Both update the
     identification markers in your working file (see below).

     You can give _c_i the number you want assigned to a checked in
     revision. Assume all your revisions were numbered 1.1, 1.2,



Printed 1/10/87              6/29/83                            3






RCSINTRO(1)         UNIX Programmer's Manual          RCSINTRO(1)



     1.3, etc., and you would like to start release 2.  The com-
     mand

               ci  -r2  f.c       or          ci  -r2.1  f.c

     assigns the number 2.1 to the new revision.  From then on,
     _c_i will number the subsequent revisions with 2.2, 2.3, etc.
     The corresponding _c_o commands

               co  -r2  f.c       and         co  -r2.1  f.c

     retrieve the latest revision numbered 2.x and the revision
     2.1, respectively. _C_o without a revision number selects the
     latest revision on the "trunk", i.e., the highest revision
     with a number consisting of 2 fields. Numbers with more than
     2 fields are needed for branches.  For example, to start a
     branch at revision 1.3, invoke

               ci  -r1.3.1  f.c

     This command starts a branch numbered 1 at revision 1.3, and
     assigns the number 1.3.1.1 to the new revision. For more
     information about branches, see _r_c_s_f_i_l_e(5).


     Automatic Identification

     RCS can put special strings for identification into your
     source and object code. To obtain such identification, place
     the marker

               $Header$

     into your text, for instance inside a comment.  RCS will
     replace this marker with a string of the form

               $Header:  filename  revision_number  date  time
     author  state $

     With such a marker on the first page of each module, you can
     always see with which revision you are working.  RCS keeps
     the markers up to date automatically.  To propagate the
     markers into your object code, simply put them into literal
     character strings. In C, this is done as follows:

               static char rcsid[] = "$Header$";

     The command _i_d_e_n_t extracts such markers from any file, even
     object code and dumps.  Thus, _i_d_e_n_t lets you find out which
     revisions of which modules were used in a given program.





Printed 1/10/87              6/29/83                            4






RCSINTRO(1)         UNIX Programmer's Manual          RCSINTRO(1)



     You may also find it useful to put the marker $Log$ into
     your text, inside a comment. This marker accumulates the log
     messages that are requested during checkin.  Thus, you can
     maintain the complete history of your file directly inside
     it.  There are several additional identification markers;
     see _c_o(1) for details.

IDENTIFICATION
     Author: Walter F. Tichy, Purdue University, West Lafayette,
     IN, 47907.
     Revision Number: 3.0 ; Release Date: 83/05/11 .
     Copyright 8c9 1982 by Walter F. Tichy.

SEE ALSO
     ci(1), co(1), ident(1), merge(1), rcs(1), rcsdiff(1),
     rcsmerge(1), rlog(1), rcsfile(5).
     Walter F. Tichy, "Design, Implementation, and Evaluation of
     a Revision Control System," in _P_r_o_c_e_e_d_i_n_g_s _o_f _t_h_e _6_t_h _I_n_t_e_r_-
     _n_a_t_i_o_n_a_l _C_o_n_f_e_r_e_n_c_e _o_n _S_o_f_t_w_a_r_e _E_n_g_i_n_e_e_r_i_n_g, IEEE, Tokyo,
     Sept. 1982.



































Printed 1/10/87              6/29/83                            5



