


CXREF(1)            UNIX Programmer's Manual             CXREF(1)



NAME
     cxref - cross reference C source files

SYNOPSIS
     cxref [ -FSCcfis ] [ -w _w_i_d_t_h ] [files]

DESCRIPTION
     _C_x_r_e_f reads the named C source files and produces on the
     standard output a cross reference of all the identifiers and
     constants in the files.  Constants are integer constants
     (12, 0421, 0x1A), floating point constants (123.45, 0.2e-4),
     string constants ("this is a string\n"), and character con-
     stants ('a', '\033').  Identifiers, character constants, and
     string constants are sorted lexicographically, i.e. accord-
     ing to the machine collating sequence (7-bit ASCII on the
     Vax or the Pyramid).  Integer and floating point constants
     are sorted numerically.  The trailing 'l' or 'L' on long
     integer constants will not show up in the output listing.

     If no files are named, _c_x_r_e_f reads the standard input. For
     multiple files, the argument "-" (a single dash) indicates
     that the standard input should be read at that point.

     If arguments are given, they must come before any file
     names.

     _C_x_r_e_f recognizes the following arguments:

          -F   Fold case in comparison.  By default, case is dis-
               tinct in comparison of identifiers and string and
               character constants.  (_c_x_r_e_f simply passes the
               "-F" option on to _s_o_r_t(1) as "-f".)

          -S   Cross reference all files separately.  The default
               action is to cross reference all named files
               together.

          -c   Leave character constants out of the cross refer-
               ence listing.

          -f   Leave floating point constants out of the cross
               reference listing.

          -i   Leave integer constants out of the cross reference
               listing.

          -s   Leave string constants out of the cross reference
               listing.

          -C   Leave _a_l_l constants, character, string, integer,
               and floating point, out of the cross reference
               listing.  By default, all types of constants are



Printed 1/10/87           Georgia Tech                          1






CXREF(1)            UNIX Programmer's Manual             CXREF(1)



               included in the cross reference.

          -w _w_i_d_t_h
               Make the output be _w_i_d_t_h columns wide.  The output
               width will never be less than 51 or more than 132
               columns.  _C_x_r_e_f silently adjusts incorrect set-
               tings to the nearest allowable setting.  If no
               width is specified, the output will default to 80
               columns wide.

     _C_x_r_e_f does _n_o_t include #include files, or expand macro
     definitions.  Files named in #include lines can be listed on
     the command line if they should also be cross referenced.

     If a quoted string has an escaped newline in it (see ``The C
     Programming Language'', page 181, or Section 2.5 of the C
     Reference Manual), it will show up inside the string in the
     output listing as \N.  This is to make it visible to the
     programmer, and to keep the various filters which _C_x_r_e_f uses
     to actually do the work from getting terribly confused.

     _C_x_r_e_f is best run in the background, with its output
     redirected into a file or the line printer spooler _l_p_r(1),
     since it reads all the named files, using _s_o_r_t(1) as an
     intermediate pass.  The sorting can take time which the user
     can probably put to more productive use.

DIAGNOSTICS
     Self explanatory.

BUGS
     Systems running UNIX 4.0 and later already have a program
     named _c_x_r_e_f.  Therefore, on those systems, this program
     should be renamed.

     _C_x_r_e_f does not do any formatting on its output (other than
     to insure that it writes the proper number of columns), so
     it should probably be run piping its output into _p_r(1).

     Floating point constants are converted to a common format
     for sorting, therefore they may appear in the output in a
     format different from (but numerically equivalent to) their
     form in the original source code.

SEE ALSO
     _l_e_x(1), _l_p_r(1), _p_r(1), _s_o_r_t(1)

FILES
     /tmp/cxr.$$.*
          temporary files for integer and floating point
          contstants.  _C_x_r_e_f removes these files when it is
          through.



Printed 1/10/87           Georgia Tech                          2






CXREF(1)            UNIX Programmer's Manual             CXREF(1)



AUTHOR
     Arnold Robbins
     School of Information and Computer Science
     Georgia Institute of Technology
     Atlanta, Geogia  30332

     UUCP:     gatech!arnold
     CSNET:    arnold@gatech
     ARPANET:  arnold%gatech.csnet@csnet-relay.arpa

     Copyright (c) 1984 by Arnold Robbins.  All rights reserved.
     This program may not be sold, but may be distributed pro-
     vided this notice is included.










































Printed 1/10/87           Georgia Tech                          3



