.TH "FILING5D" 1 "3-Feb-87" "Xerox (WRC)"
.\" $Header: Filing5d.n,v 1.1 87/04/01 13:54:15 ed Exp $
.SH NAME
Filing5d - XNS Filing version 5 service
.SH DESCRIPTION
.I Filing5d
is a service for the XNS Courier Filing protocol version 5.
This service implements a subset of the Filing Protocol which is similar
to the XNS FilingSubset Protocol; however, extensions to this subset
provide additional functionality more closely aligned with full Filing
functionality. 
.PP
The service is forked from the XNS courier daemon,
.IR xnscourierd , 
upon connection requests for version 5 of the Filing Protocol.
.SH "PROCEDURE SUPPORT"
The Filing Protocol defined procedures 
.IR Logon , 
.IR Logoff , 
.IR Continue , 
.IR Open , 
.IR Close ,
.IR Create ,
.IR Delete ,
.IR GetAttributes ,
.IR ChangeAttributes ,
.IR Copy ,
.IR Move ,
.IR Store ,
.IR Retrieve ,
.IR Replace ,
.IR Serialize ,
.I Deserialize
and
.I List
are supported. The extent of support is
consistent with the FilingSubset Protocol with extensions added to provide
additional functionality and interoperability.
.SH "ATTRIBUTE SUPPORT"
Attribute support within the service is also consistent with the FilingSubset
Protocol. All attributes defined as mandatory in the FilingSubset Protocol
are supported (\fIcreatedOn\fR, 
.IR dataSize , 
.IR isDirectory , 
.IR modifiedOn , 
.IR pathname, 
.IR type ).
Additional attributes (\fIcreatedBy\fR, 
.IR fileID , 
.IR name ,
.IR readOn , 
.IR version)
are supported
and/or allowed to provide interoperability. 
.PP
Additional Viewpoint related attributes are uninterpreted by the 
file service; however, they are retained and returned to the client when
retrieved.
.PP
The \fIOpen\fR procedure allows files to be identified through the use of the
.IR fileID ,
.I name
or 
.I pathname
attributes.
.PP
.I Filing5d
maintains the file type attribute in a manner consisten with the storage of
the file locally. Files are stored locallay as described in 
\fIViewpointfiles(5N)\fR. Uninterpreted attributes are
retained with the file content so that they may be returned when asked for.
.PP
Since the service does not maintain the file types explicitly within the Unix
file system
.I Filing5d
will make an educated guess of the file type based on the contents and/or
stored attributes of the file, when a client requests the type of a file.
.SH "FILE TRANSFERS"
.I Filing5d
currently makes a distinction between  
.I tText 
and other file types for use during file transfer. Files of type
.I tText
undergo a translation of contents for compatibility with existing Filing
implementations; Unix EOL characters
(\\n) are translated to and from Xerox EOL characters (\\r), Xerox left
arrow characters are translated to underscore, etc.
All other files are treated as a binary stream with no translation incurred.
.SH AUTHENTICATION
The Filing Protocol (version 5) allows clients to supply a set of primary
credentials and accompanying verifier. Since the credentials and verifier
are encrypted in a form recognizable by the network Authentication service,
there is no mechanism available for supplying a verifier to be used by the
host system for verification.
.PP
.I Filing5d
uses the following assumptions for user validation. Credentials and verifiers
must be of type
.IR simple .
The
.I Logon
will be rejected if 
.I nullCredentials 
or 
.I strong 
credentials are supplied. The credentials and verifier will be validated 
against the network Authentication service and rejected if not successful.
The object name supplied in the credentials will then be used as the user
name for validation against the Unix /etc/passwd file. If the name does
not exist, the procedure will be rejected. If the user is valid, the 
.I Logon
will be successful with no ensuing Unix password verification. (The assumption
is that a valid network user that has an account on the host is also a valid
host user.) 
.PP
In some situations, the credentials supplied may contain a full Clearinghouse
name rather than a more convenient Clearinghouse alias (i.e., \*(lqJohn Q.
Public:Computer Science:Cornell-Univ\*(rq). In these instances, the supplied
name obviously will not pass as a Unix user name.
.I Filing5d
therefore, will strip the last name of the object field (i.e., Public)
and attempt to use this as the user name for the Unix host. An additional
conversion to all lower case characters will take place if the original
attempt fails.
.SH "SEE ALSO"
Filing4d(1N), Filing6d(1N), FilingSubset1d(1N), Viewpointfiles(5N)
.br
Filing Protocol, \s8XNSS\s0 108507 (July 1985)
.br
Filing Protocol, \s8XNSS\s0 108605 (May 1986)
.br
FilingSubset Implementor's Guide, \s8XNSG\s0 098609 (September 1986)
.SH NOTES
A limited subset of the full Filing Protocol is actually implemented.
Procedures dealing with controls, access lists or random access are not yet
implemented.
.PP
.I ChangeAttributes 
only allows the \fIname\fR attribute to be modified.
.PP
Service related attributes (\fIaccessList\fR,
.IR checksum ,
.IR childrenUniquelyNamed ,
.IR defaultAccessList ,
.IR numberOfChildren ,
.IR ordering ,
.IR parentID ,
.IR position ,
.IR subtreeSize ,
.IR subtreeSizeLimit )
are not implemented within this service.
.SH BUGS
Like all other server implementations in the Unix/XNS environment a single
Filing session is not allowed to exist over multiple transport (SPP) 
connections.
.SH AUTHOR
Ed Flint
