#include "sys_param.h"
#ifndef major
#include "sys_types.h"
#endif
#include "sys_time.h"
#include "sys_dir.h"
#include <stdio.h>
#include <HFS.h>

extern int trace;

DIR *opendir(root)
char *root;
{
	char path[256];
	CInfoPBRec iopb;
	static DIR thedir;
	DIR *dir;
	int result;

	extern StringPtr pname();
	extern int default_vrefnum;
	extern long default_dir_id;
	
	unix_to_mac_path(path, root, FALSE);
	
	iopb.hFileInfo.ioNamePtr = pname(path);
	iopb.hFileInfo.ioVRefNum = default_vrefnum;
	iopb.hFileInfo.ioDirID = default_dir_id;
	
	iopb.hFileInfo.ioFDirIndex = 0;
	result = PBGetCatInfo(&iopb, FALSE);

	if (result == dirNFErr || result == fnfErr)
		return NO_DIR;

	if (result != noErr)
		merror(result, "opendir - PBGetCatInfo", path);

	dir = &thedir;
	dir->dir_index = 0;
	dir->dir_id = iopb.hFileInfo.ioDirID;

	if (trace)
		printf("\t[opendir] for '%s', dirID 0x%lx\n", path, default_dir_id);

	return dir;
}

closedir(dir)
DIR *dir;
{
}

rewinddir(dir)
DIR *dir;
{
	dir->dir_index = 0;
}

struct direct *readdir(dir)
DIR *dir;
{
	struct direct *entry = &dir->dir_entry;
	int result;
	CInfoPBRec iopb;
	char name[256];
	
	name[0] = '\0';
	iopb.hFileInfo.ioNamePtr = (StringPtr)name;
	iopb.hFileInfo.ioVRefNum = default_vrefnum;
	iopb.hFileInfo.ioFDirIndex = ++(dir->dir_index);
	iopb.hFileInfo.ioDirID = dir->dir_id;

	result = PBGetCatInfo(&iopb, FALSE);
	if (trace)
		printf("\t[readdir] index %d, result %d\n", dir->dir_index, result);

	if (result == fnfErr)
		return NO_ENTRY;

	PtoCstr(name);
	strcpy(entry->d_name, name);

	if (trace)
		printf("\t[readdir] returns '%s'\n", name);
	return entry;
}


