/*	@(#)test8.c	1.3 89/01/10 NFS Rev 2 Testsuite	*/
/*
 * Test symlink, readlink
 *
 * Uses the following important system calls against the server:
 *
 *	chdir()
 *	mkdir()		(for initial directory creation if not -m)
 *	creat()
 *	symlink()
 *	readlink()
 *	lstat()
 *	unlink()
 */

#include "tests.h"


#ifdef ANSI
void usage(void);
void main(int argc, char *argv[]);
#endif

int Tflag = 0;		/* print timing */
int Hflag = 0;		/* print help message */
int Fflag = 0;		/* test function only;  set count to 1, negate -t */
int Nflag = 0;		/* Suppress directory operations */

#define SNAME "/this/is/a/symlink"	/* symlink prefix */

void
usage()
{
	fprintf(stdout, "usage: %s [-htfn] [files count fname sname]\n", Myname);
	fprintf(stdout, "  Flags:  h    Help - print this usage info\n");
	fprintf(stdout, "          t    Print execution time statistics\n");
	fprintf(stdout, "          f    Test function only (negate -t)\n");
	fprintf(stdout, "          n    Suppress test directory create operations\n");
}

void
main(argc, argv)
	int argc;
	char *argv[];
{
	int files = 10;		/* number of files in each dir */
	int fi;
	int count = 20;	/* times to do each file */
	int ct;
	int totfiles = 0;
	int totdirs = 0;
	char *fname = FNAME;
	char *sname = SNAME;
	struct timeval time;
	char str[MAXPATHLEN];
	char new[MAXPATHLEN];
	char buf[MAXPATHLEN];
	int ret;
	struct stat statb;
	char *opts;

	umask(0);
	setbuf(stdout, NULL);
	Myname = *argv++;
#ifndef S_IFLNK
	fprintf(stdout, "\
%s: symlink and readlink not supported on this client\n", Myname);
#else /* S_IFLNK */
	argc--;
	while (argc && **argv == '-') {
		for (opts = &argv[0][1]; *opts; opts++) {
			switch (*opts) {
				case 'h':	/* help */
					usage();
					exit(1);

				case 't':	/* time */
					Tflag++;
					break;
				
				case 'f':	/* funtionality */
					Fflag++;
					break;
				
				case 'n':	/* No Test Directory create */
					Nflag++;
					break;

				default:
					error("unknown option '%c'", *opts);
					usage();
					exit(1);
			}
		}
		argc--;
		argv++;
	}

	if (argc) {
		files = (int) getparm(*argv, 1L, "files");
		argv++;
		argc--;
	}
	if (argc) {
		count = (int) getparm(*argv, 1L, "count");
		argv++;
		argc--;
	}
	if (argc) {
		fname = *argv;
		argv++;
		argc--;
	}
	if (argc) {
		sname = *argv;
		argv++;
		argc--;
	}
	if (argc) {
		usage();
		exit(1);
	}

	if (Fflag) {
		Tflag = 0;
		count = 1;
	}

	if (!Nflag)
		testdir(NULL);
	else
		mtestdir(NULL);

	fprintf(stdout, "%s: symlink and readlink\n", Myname);

	if (Tflag) {
		starttime();
	}

	for (ct = 0; ct < count; ct++) {
		for (fi = 0; fi < files; fi++) {
			sprintf(str, "%s%d", fname, fi);
			sprintf(new, "%s%d", sname, fi);
			if (symlink(new, str) < 0) {
				error("can't make symlink %s", str);
				if (errno == EOPNOTSUPP)
					complete();
				else
					exit(1);
			}
                        if (lstat(str, &statb) < 0) {
                                error("can't stat %s after symlink", str);
                                exit(1);
                        }
			if ((statb.st_mode & S_IFMT) != S_IFLNK) {
				error("mode of %s not symlink");
				exit(1);
			}
			if ((ret = readlink(str, buf, MAXPATHLEN))
			     != strlen(new)) {
				error("readlink %s ret %d, expect %d",
					str, ret, strlen(new));
				exit(1);
			}
			if (strncmp(new, buf, ret) != NULL) {
				error("readlink %s returned bad linkname",
					str);
				exit(1);
			}
			if (unlink(str) < 0) {
				error("can't unlink %s", str);
				exit(1);
			}
		}
	}

	if (Tflag) {
		endtime(&time);
	}
	fprintf(stdout, "\t%d symlinks and readlinks on %d files",
		files * count * 2, files);
	if (Tflag) {
		printtimes(&time, 0L);
	}
	fprintf(stdout, "\n");
#endif /* S_IFLNK */
	complete();
}
