##
## Copyright (c) 1982 Regents of the University of California.
## All rights reserved.  The Berkeley software License Agreement
## specifies the terms and conditions for redistribution.
##
##	@(#)instrs	5.1 (Berkeley) 4/30/85
##
##	Robert R. Henry
##	University of California, Berkeley
##	Berkeley, CA
##	February 6, 1982
##
##	Updated 19 May 83 to include the page number in the
##	architecture reference manual (1981 edition) the instruction
##	is documented on, and to enumerate the instructions in the same
##	order as the reference manual does.
##
##	THIS FILE IS BOTH AN AWK SCRIPT AND THE DATA
##
##	Instruction definitions for the VAX
##
##	This file is processed by an awk script, viz:
##	(echo "FLAVOR AS"; cat instrs) | awk -f instrs > as.instrs
##	(echo "FLAVOR ADB"; cat instrs) | awk -f instrs > as.instrs
##	(echo "FLAVOR SDB"; cat instrs) | awk -f instrs > as.instrs
##	(echo "FLAVOR C2"; cat instrs) | awk -f instrs > c2.instrs
##
##	The data in this file is shared between:
##	as	assembler
##	c2	optimizer
##	adb	debugger
##	sdb	symbolic debugger
##
##	The awk script reads itself, and produces macros understood
##	by the appropriate consumer. The awk script determines how
##	to interpret the file by looking for a line of the form:
##	FLAVOR	AS
##	FLAVOR	ADB		(same as AS, but without pseudo instructions)
##	FLAVOR	SDB		(same as ADB)
##	FLAVOR	C2		(radically different format for instructions)
##	and proceeding accordingly.  This line should be prepended to
##	the front of this file.
##
##	Lines starting with # are always comments to awk
##	Lines starting with ## are always comments
##	Lines starting with a single # are data lines, to be output.
##
##	Empty lines are passed through
##
##	field	user(s)		what
##
##	$2	awk		#: comment to awk
##
##	$3	as, c2, adb	instruction name
##
##	$4	c2		instruction class
##	$5	c2		instruction sub class
##				HARD, TN1, TN2, TN3, TNX2, OP
##
##	$6	as, adb		escape opcode byte (NONE, NEW, ESCD, ESCF)
##	$7	as, adb		primary opcode byte
##	
##	$8	as, adb		number of arguments
##	$9	as, adb		1st operand: access A,V,R,W,M,I,B
##	$10	as, adb		1st operand: type, BWLQOFDGH
##
##	$11	as, adb		2nd operand: access
##		...
##
##
##	These are the definitions used in this file:
##	instruction class (c2)
##		understood only by c2.  If it is HARD, the second field
##		is ignored.
##	instruction subclass: (c2)
##		HARD		paired with the class
##		S		single valued attribute to C2
##		TN1		class + type of 1st operand
##		TN2		class + type of 2nd operand
##		TN3		class + type of 3rd operand
##		TNX2		class + type of 1st and 2nd operand
##		OP		class + type of 1st operand and # of args
##		default		class + subclass
##
##	escape byte:
##		CORE		1 byte opcodes in all VAXen
##		NEW		1 byte opcodes only in newer VAXen
##		ESCD		2 byte opcodes, escape byte of 0xFD, newer VAXen
##		ESCF		2 byte opcodes, escape byte of 0xFF, newer VAXen
##	code byte
##	number of arguments
##	Access type
##		A		for address, only in memory
##		V		for address [sic], either in memory or register
##		W		for writing
##		R		for reading
##		M		for modifying
##		B		for branch displacement
##		I		for xfc code
##	Data types
##		B	byte
##		W	word
##		L	long
##		Q	quad
##		O	octa
##		F	f_float
##		D	d_float
##		G	g_float
##		H	h_float
##
##	The order of instructions in this table is not critical;
##	the clients take care of their own table construction and ordering.
##	The instructions are grouped (more or less) into functional groups.
##
##	The following is the awk program to interpret this table.

BEGIN{
	flavor = AS;
	##
	##	magic padding before the string for AS
	##	4 bytes of 0's: seek position of the string
	##	2 bytes, value 2, indicating core resident
	##	2 bytes, value 0, length
	##
	ASpad = "\\0\\0\\0\\0" "\\2\\0";
}
{
	if (NF == 0){
		printf("\n");
		next;
	}
	if ($1 == "FLAVOR"){
		flavor = $2;
		if (flavor == "SDB"){
			flavor = "ADB";
		}
		next;
	}
	if ($1 != "#"){
		next;
	}

	if ($6 == "MACR"){
		if (flavor == "ADB"){
			next;
		}
		if (flavor == "AS"){
			if ($4 == "CBR")
				$4 = "IJXXX";
			printf("PSEUDO(\"%s\\0%o\\0%s\",", ASpad,length($3),$3);
			printf("%s, %s),\n", $7, $4);
			next;
		}
		if (flavor == "C2"){
			if ($5 == "C2X")
				next;
			printf("\"%s\",", $3);
			if ($4 == "CBR" && $5 != "JBR"){
				printf("T(CBR,%s),\n", $5);
			} else {
				printf("%s,\n", $5);
			}
			next;
		}
	}

	if (flavor == "C2"){
		printf("\"%s\",", $3);
		if ($4 == "HARD"){		# 0 value
			printf("0,\n");
			next;
		}
		if ($5 == "S"){			# single value
			printf("%s,\n", $4);
			next;
		}
		if ($5 == "TN1"){		# use type of 1st operand
			printf("T(%s,TYP%s),\n", $4, $10);
			next;
		}
		if ($5 == "TN3"){		# use type of 3rd operand
			printf("T(%s,TYP%s),\n", $4, $14);
			next;
		}
		if ($5 == "TNX2"){		# cross product of 1st and 2nd operand
			printf("T(%s,U(TYP%s,TYP%s)),\n", $4, $10, $12);
			next;
		}
		if ($5 == "OP"){		# arithmetic operator
			printf("T(%s,U(TYP%s,OP%d)),\n", $4, $10, $8);
			next;
		}
		printf("T(%s,%s),\n", $4, $5);	# special value
		next;
	}
	if (flavor == "AS"){
		printf("OP(\"%s\\0%o\\0%s\", ", ASpad, length($3), $3);
		printf("%s, %s, %d", $6, $7, $8);
	} else {
		printf("OP(\"%s\", %s, %s, %d", $3, $6, $7, $8);
	}
	if (flavor == "AS" || flavor == "ADB"){
		for (i = 9; i+1 <= NF; i = i + 2){
			printf(", A_%s%s", $i, $(i+1));
		}
		for (i = $8; i < 6; i++){
			printf(",0");
		}
		printf("),\n");
	}
}
##
##-------------------------------------------------------
##1 2		3     4  	5    6	        7  8 9
##
##
## PSEUDO (MACR) operators come first

## Data initializers

# 000a .byte	IBYTE	C2X	MACR 0		VAR
# 000b .word	IWORD	WGEN	MACR 0		VAR
# 000c .int	IINT	LGEN	MACR 0		VAR
# 000d .long	ILONG	LGEN	MACR 0		VAR
# 000a .quad	IQUAD	C2X	MACR 0		VAR
# 000a .octa	IOCTA	C2X	MACR 0		VAR
# 000a .float	IFFLOAT	C2X	MACR 0		VAR
# 000a .double	IDFLOAT	C2X	MACR 0		VAR
# 000a .ffloat	IFFLOAT	C2X	MACR 0		VAR
# 000a .dfloat	IDFLOAT	C2X	MACR 0		VAR
# 000a .gfloat	IGFLOAT	C2X	MACR 0		VAR
# 000a .hfloat	IHFLOAT	C2X	MACR 0		VAR
# 000a .space	ISPACE	C2X	MACR 0		1
# 000a .fill	IFILL	C2X	MACR 0		2
# 000a .ascii	IASCII	C2X	MACR 0		VAR
# 000a .asciz	IASCIZ	C2X	MACR 0		VAR

# 000a .data	IDATA	DATA	MACR 0		1
# 000a .text	ITEXT	TEXT	MACR 0		1
# 000a .align	IALIGN	ALIGN	MACR 0		1
	
# 000a .line	ILINENO	C2X	MACR 0		1
# 000a .file	IFILE	C2X	MACR 0		1

# 000a .globl	IGLOBAL	EROU	MACR 0		1
# 000a .comm	ICOMM	COMM	MACR 0		2
# 000a .lcomm	ILCOMM	LCOMM	MACR 0		2
# 000a .set	ISET	SET	MACR 0		2
# 000a .lsym	ILSYM	C2X	MACR 0		2
# 000a .org	IORG	C2X	MACR 0		1

# 000a .stab	ISTAB	C2X	MACR 0		6
# 000a .stabd	ISTABDOT	C2X	MACR 0	3
# 000a .stabn	ISTABNONE	C2X	MACR 0	3
# 000a .stabs	ISTABSTR	C2X	MACR 0	3

# 000a .ABORT	IABORT	C2X	MACR 0		0

## Pseudo jumps

# 000a jbc	CBR	JBC	MACR 0xe1	1	B B
# 000a jlbc	CBR	JLBC	MACR 0xe9	1	B B
# 000a jbs	CBR	JBS	MACR 0xe0	1	B B
# 000a jlbs	CBR	JLBS	MACR 0xe8	1	B B
# 000a jbcc	CBR	JBCC	MACR 0xe5	1	B B
# 000a jbsc	CBR	JBSC	MACR 0xe4	1	B B
# 000a jbcs	CBR	JBCS	MACR 0xe3	1	B B
# 000a jbss	CBR	JBSS	MACR 0xe2	1	B B

# 000a jbr	CBR	JBR	MACR 0x11	1	B B
# 000a jcc	CBR	C2X	MACR 0x1e	1	B B
# 000a jcs	CBR	C2X	MACR 0x1f	1	B B
# 000a jvc	CBR	C2X	MACR 0x1c	1	B B
# 000a jvs	CBR	C2X	MACR 0x1d	1	B B
# 000a jlss	CBR	JLT	MACR 0x19	1	B B
# 000a jlssu	CBR	JLO	MACR 0x1f	1	B B
# 000a jleq	CBR	JLE	MACR 0x15	1	B B
# 000a jlequ	CBR	JLOS	MACR 0x1b	1	B B
# 000a jeql	CBR	JEQ	MACR 0x13	1	B B
# 000a jeqlu	CBR	JEQ	MACR 0x13	1	B B
# 000a jneq	CBR	JNE	MACR 0x12	1	B B
# 000a jnequ	CBR	JNE	MACR 0x12	1	B B
# 000a jgeq	CBR	JGE	MACR 0x18	1	B B
# 000a jgequ	CBR	JHIS	MACR 0x1e	1	B B
# 000a jgtr	CBR	JGT	MACR 0x14	1	B B
# 000a jgtru	CBR	JHI	MACR 0x1a	1	B B
##
## Registers
##
# 000a r0	REG	C2X	MACR 0		0
# 000a r1	REG	C2X	MACR 1		0
# 000a r2	REG	C2X	MACR 2		0
# 000a r3	REG	C2X	MACR 3		0
# 000a r4	REG	C2X	MACR 4		0
# 000a r5	REG	C2X	MACR 5		0
# 000a r6	REG	C2X	MACR 6		0
# 000a r7	REG	C2X	MACR 7		0
# 000a r8	REG	C2X	MACR 8		0
# 000a r9	REG	C2X	MACR 9		0
# 000a r10	REG	C2X	MACR 10		0
# 000a r11	REG	C2X	MACR 11		0
# 000a r12	REG	C2X	MACR 12		0
# 000a r13	REG	C2X	MACR 13		0
# 000a r14	REG	C2X	MACR 14		0
# 000a r15	REG	C2X	MACR 15		0
# 000a ap	REG	C2X	MACR 12		0
# 000a fp	REG	C2X	MACR 13		0
# 000a sp	REG	C2X	MACR 14		0
# 000a pc	REG	C2X	MACR 15		0

## Normal instructions

# 158a chmk	HARD HARD	CORE 0xbc	1  R W 
# 158b chme	HARD HARD	CORE 0xbd	1  R W 
# 158c chms	HARD HARD	CORE 0xbe	1  R W 
# 158d chmu	HARD HARD	CORE 0xbf	1  R W 
# 160a prober	PROBER TN1	CORE 0x0c	3  R B  R W  A B 
# 160a probew	PROBEW TN1	CORE 0x0d	3  R B  R W  A B 
# 161a rei	HARD HARD	CORE 0x02	0 
# 163a ldpctx	HARD HARD	CORE 0x06	0 
# 163b svpctx	HARD HARD	CORE 0x07	0 
# 165a mtpr	MTPR TN1	CORE 0xda	2  R L  R L 
# 165b mfpr	MFPR TN1	CORE 0xdb	2  R L  W L 
# 168a xfc	HARD HARD	CORE 0xfc	0 
# 169a bpt	HARD HARD	CORE 0x03	0 
# 170a bugw	HARD HARD	ESCF 0xfe	1  R W 
# 170b bugl	HARD HARD	ESCF 0xfd	1  R L 
# 171a halt	HARD HARD	CORE 0x00	0 
# 179a movb	MOV TN1		CORE 0x90	2  R B  W B 
# 179b movw	MOV TN1		CORE 0xb0	2  R W  W W 
# 179c movl	MOV TN1		CORE 0xd0	2  R L  W L 
# 179d movq	MOV TN1		CORE 0x7d	2  R Q  W Q 
# 179e movo	MOV TN1		ESCD 0x7d	2  R O  W O 
# 179f movf	MOV TN1		CORE 0x50	2  R F  W F 
# 179g movd	MOV TN1		CORE 0x70	2  R D  W D 
# 179h movg	MOV TN1		ESCD 0x50	2  R G  W G 
# 179i movh	MOV TN1		ESCD 0x70	2  R H  W H 
# 180a pushl	PUSH TN1	CORE 0xdd	1  R L 
# 181a clrb	CLR TN1		CORE 0x94	1  W B 
# 181b clrw	CLR TN1		CORE 0xb4	1  W W 
# 181c clrf	CLR TN1		CORE 0xd4	1  W F 
# 181c clrl	CLR TN1		CORE 0xd4	1  W L 
# 181d clrd	CLR TN1		CORE 0x7c	1  W D 
# 181d clrg	CLR TN1		CORE 0x7c	1  W G 
# 181d clrq	CLR TN1		CORE 0x7c	1  W Q 
# 181e clrh	CLR TN1		ESCD 0x7c	1  W H 
# 181e clro	CLR TN1		ESCD 0x7c	1  W O 
# 182a mnegb	NEG TN1		CORE 0x8e	2  R B  W B 
# 182b mnegw	NEG TN1		CORE 0xae	2  R W  W W 
# 182c mnegl	NEG TN1		CORE 0xce	2  R L  W L 
# 182d mnegf	NEG TN1		CORE 0x52	2  R F  W F 
# 182e mnegg	NEG TN1		ESCD 0x52	2  R G  W G 
# 182f mnegd	NEG TN1		CORE 0x72	2  R D  W D 
# 182g mnegh	NEG TN1		ESCD 0x72	2  R H  W H 
# 183a mcomb	COM TN1		CORE 0x92	2  R B  W B 
# 183b mcomw	COM TN1		CORE 0xb2	2  R W  W W 
# 183c mcoml	COM TN1		CORE 0xd2	2  R L  W L 
# 184A cvtbw	CVT TNX2	CORE 0x99	2  R B  W W 
# 184B cvtbl	CVT TNX2	CORE 0x98	2  R B  W L 
# 184C cvtwb	CVT TNX2	CORE 0x33	2  R W  W B 
# 184D cvtwl	CVT TNX2	CORE 0x32	2  R W  W L 
# 184E cvtlb	CVT TNX2	CORE 0xf6	2  R L  W B 
# 184F cvtlw	CVT TNX2	CORE 0xf7	2  R L  W W 
# 184G cvtbf	CVT TNX2	CORE 0x4c	2  R B  W F 
# 184H cvtbd	CVT TNX2	CORE 0x6c	2  R B  W D 
# 184I cvtbg	CVT TNX2	ESCD 0x4c	2  R B  W G 
# 184J cvtbh	CVT TNX2	ESCD 0x6c	2  R B  W H 
# 184K cvtwf	CVT TNX2	CORE 0x4d	2  R W  W F 
# 184L cvtwd	CVT TNX2	CORE 0x6d	2  R W  W D 
# 184M cvtwg	CVT TNX2	ESCD 0x4d	2  R W  W G 
# 184N cvtwh	CVT TNX2	ESCD 0x6d	2  R W  W H 
# 184O cvtlf	CVT TNX2	CORE 0x4e	2  R L  W F 
# 184P cvtld	CVT TNX2	CORE 0x6e	2  R L  W D 
# 184Q cvtlg	CVT TNX2	ESCD 0x4e	2  R L  W G 
# 184R cvtlh	CVT TNX2	ESCD 0x6e	2  R L  W H 
# 184S cvtfb	CVT TNX2	CORE 0x48	2  R F  W B 
# 184T cvtdb	CVT TNX2	CORE 0x68	2  R D  W B 
# 184U cvtgb	CVT TNX2	ESCD 0x48	2  R G  W B 
# 184V cvthb	CVT TNX2	ESCD 0x68	2  R H  W B 
# 184W cvtfw	CVT TNX2	CORE 0x49	2  R F  W W 
# 184X cvtdw	CVT TNX2	CORE 0x69	2  R D  W W 
# 184Y cvtgw	CVT TNX2	ESCD 0x49	2  R G  W W 
# 184Z cvthw	CVT TNX2	ESCD 0x69	2  R H  W W 
# 184a cvtfl	CVT TNX2	CORE 0x4a	2  R F  W L 
# 184b cvtrfl	CVT TNX2	CORE 0x4b	2  R F  W L 
# 184c cvtdl	CVT TNX2	CORE 0x6a	2  R D  W L 
# 184d cvtrdl	CVT TNX2	CORE 0x6b	2  R D  W L 
# 184e cvtgl	CVT TNX2	ESCD 0x4a	2  R G  W L 
# 184f cvtrgl	CVT TNX2	ESCD 0x4b	2  R G  W L 
# 184g cvthl	CVT TNX2	ESCD 0x6a	2  R H  W L 
# 184h cvtrhl	CVT TNX2	ESCD 0x6b	2  R H  W L 
# 184i cvtfd	CVT TNX2	CORE 0x56	2  R F  W D 
# 184j cvtfg	CVT TNX2	ESCD 0x99	2  R F  W G 
# 184k cvtfh	CVT TNX2	ESCD 0x98	2  R F  W H 
# 184l cvtdf	CVT TNX2	CORE 0x76	2  R D  W F 
# 184m cvtdh	CVT TNX2	ESCD 0x32	2  R D  W H 
# 184n cvtgf	CVT TNX2	ESCD 0x33	2  R G  W F 
# 184o cvtgh	CVT TNX2	ESCD 0x56	2  R G  W H 
# 184p cvthf	CVT TNX2	ESCD 0xf6	2  R H  W F 
# 184q cvthd	CVT TNX2	ESCD 0xf7	2  R H  W D 
# 184r cvthg	CVT TNX2	ESCD 0x76	2  R H  W G 
# 187a movzbw	MOVZ TNX2	CORE 0x9b	2  R B  W W 
# 187b movzbl	MOVZ TNX2	CORE 0x9a	2  R B  W L 
# 187c movzwl	MOVZ TNX2	CORE 0x3c	2  R W  W L 
# 188a cmpb	CMP TN1		CORE 0x91	2  R B  R B 
# 188b cmpw	CMP TN1		CORE 0xb1	2  R W  R W 
# 188c cmpl	CMP TN1		CORE 0xd1	2  R L  R L 
# 188d cmpf	CMP TN1		CORE 0x51	2  R F  R F 
# 188e cmpd	CMP TN1		CORE 0x71	2  R D  R D 
# 188f cmpg	CMP TN1		ESCD 0x51	2  R G  R G 
# 188g cmph	CMP TN1		ESCD 0x71	2  R H  R H 
# 189a incb	INC TN1		CORE 0x96	1  M B 
# 189b incw	INC TN1		CORE 0xb6	1  M W 
# 189c incl	INC TN1		CORE 0xd6	1  M L 
# 190a tstb	TST TN1		CORE 0x95	1  R B 
# 190b tstw	TST TN1		CORE 0xb5	1  R W 
# 190c tstl	TST TN1		CORE 0xd5	1  R L 
# 190d tstf	TST TN1		CORE 0x53	1  R F 
# 190e tstd	TST TN1		CORE 0x73	1  R D 
# 190g tstg	TST TN1		ESCD 0x53	1  R G 
# 190h tsth	TST TN1		ESCD 0x73	1  R H 
# 191a addb2	ADD OP		CORE 0x80	2  R B  M B 
# 191a addh2	ADD OP		ESCD 0x60	2  R H  M H 
# 191b addb3	ADD OP		CORE 0x81	3  R B  R B  W B 
# 191b addh3	ADD OP		ESCD 0x61	3  R H  R H  W H 
# 191c addw2	ADD OP		CORE 0xa0	2  R W  M W 
# 191d addw3	ADD OP		CORE 0xa1	3  R W  R W  W W 
# 191e addl2	ADD OP		CORE 0xc0	2  R L  M L 
# 191f addl3	ADD OP		CORE 0xc1	3  R L  R L  W L 
# 191g addf2	ADD OP		CORE 0x40	2  R F  M F 
# 191h addf3	ADD OP		CORE 0x41	3  R F  R F  W F 
# 191i addd2	ADD OP		CORE 0x60	2  R D  M D 
# 191j addd3	ADD OP		CORE 0x61	3  R D  R D  W D 
# 191k addg2	ADD OP		ESCD 0x40	2  R G  M G 
# 191l addg3	ADD OP		ESCD 0x41	3  R G  R G  W G 
# 193a adwc	HARD HARD	CORE 0xd8	2  R L  M L 
# 194a adawi	HARD HARD	CORE 0x58	2  R W  M W 
# 195c subb2	SUB OP		CORE 0x82	2  R B  M B 
# 195d subb3	SUB OP		CORE 0x83	3  R B  R B  W B 
# 195e subw2	SUB OP		CORE 0xa2	2  R W  M W 
# 195f subw3	SUB OP		CORE 0xa3	3  R W  R W  W W 
# 195g subl2	SUB OP		CORE 0xc2	2  R L  M L 
# 195h subl3	SUB OP		CORE 0xc3	3  R L  R L  W L 
# 195i subf2	SUB OP		CORE 0x42	2  R F  M F 
# 195j subf3	SUB OP		CORE 0x43	3  R F  R F  W F 
# 195k subd2	SUB OP		CORE 0x62	2  R D  M D 
# 195l subd3	SUB OP		CORE 0x63	3  R D  R D  W D 
# 195m subg2	SUB OP		ESCD 0x42	2  R G  M G 
# 195n subg3	SUB OP		ESCD 0x43	3  R G  R G  W G 
# 195o subh2	SUB OP		ESCD 0x62	2  R H  M H 
# 195p subh3	SUB OP		ESCD 0x63	3  R H  R H  W H 
# 197a decb	DEC TN1		CORE 0x97	1  M B 
# 197b decw	DEC TN1		CORE 0xb7	1  M W 
# 197c decl	DEC TN1		CORE 0xd7	1  M L 
# 198a sbwc	HARD HARD	CORE 0xd9	2  R L  M L 
# 199a mulb2	MUL OP		CORE 0x84	2  R B  M B 
# 199b mulb3	MUL OP		CORE 0x85	3  R B  R B  W B 
# 199c mulw2	MUL OP		CORE 0xa4	2  R W  M W 
# 199d mulw3	MUL OP		CORE 0xa5	3  R W  R W  W W 
# 199e mull2	MUL OP		CORE 0xc4	2  R L  M L 
# 199f mull3	MUL OP		CORE 0xc5	3  R L  R L  W L 
# 199g mulf2	MUL OP		CORE 0x44	2  R F  M F 
# 199h mulf3	MUL OP		CORE 0x45	3  R F  R F  W F 
# 199i muld2	MUL OP		CORE 0x64	2  R D  M D 
# 199j muld3	MUL OP		CORE 0x65	3  R D  R D  W D 
# 199k mulg2	MUL OP		ESCD 0x44	2  R G  M G 
# 199l mulg3	MUL OP		ESCD 0x45	3  R G  R G  W G 
# 199m mulh2	MUL OP		ESCD 0x64	2  R H  M H 
# 199n mulh3	MUL OP		ESCD 0x65	3  R H  R H  W H 
# 201a emodf	HARD HARD	CORE 0x54	5  R F  R B  R F  W L  W F 
# 201a emul	HARD HARD	CORE 0x7a	4  R L  R L  R L  W Q 
# 201b emodd	HARD HARD	CORE 0x74	5  R D  R B  R D  W L  W D 
# 201c emodg	HARD HARD	ESCD 0x54	5  R G  R W  R G  W L  W G 
# 201d emodh	HARD HARD	ESCD 0x74	5  R H  R W  R H  W L  W H 
# 204a divb2	DIV OP		CORE 0x86	2  R B  M B 
# 204b divb3	DIV OP		CORE 0x87	3  R B  R B  W B 
# 204c divw2	DIV OP		CORE 0xa6	2  R W  M W 
# 204d divw3	DIV OP		CORE 0xa7	3  R W  R W  W W 
# 204e divl2	DIV OP		CORE 0xc6	2  R L  M L 
# 204f divl3	DIV OP		CORE 0xc7	3  R L  R L  W L 
# 204g divf2	DIV OP		CORE 0x46	2  R F  M F 
# 204h divf3	DIV OP		CORE 0x47	3  R F  R F  W F 
# 204i divd2	DIV OP		CORE 0x66	2  R D  M D 
# 204j divd3	DIV OP		CORE 0x67	3  R D  R D  R D 
# 204k divg2	DIV OP		ESCD 0x46	2  R G  M G 
# 204l divg3	DIV OP		ESCD 0x47	3  R G  R G  W G 
# 204m divh2	DIV OP		ESCD 0x66	2  R H  M H 
# 204n divh3	DIV OP		ESCD 0x67	3  R H  R H  R H 
# 205a ediv	HARD HARD	CORE 0x7b	4  R L  R Q  W L  W L 
# 207a bitb	BIT TN1		CORE 0x93	2  R B  R B 
# 207a bitl	BIT TN1		CORE 0xd3	2  R L  R L 
# 207a bitw	BIT TN1		CORE 0xb3	2  R W  R W 
# 208a bisb2	BIS OP		CORE 0x88	2  R B  M B 
# 208b bisb3	BIS OP		CORE 0x89	3  R B  R B  W B 
# 208c bisw2	BIS OP		CORE 0xa8	2  R W  M W 
# 208d bisw3	BIS OP		CORE 0xa9	3  R W  R W  W W 
# 208e bisl2	BIS OP		CORE 0xc8	2  R L  M L 
# 208f bisl3	BIS OP		CORE 0xc9	3  R L  R L  W L 
# 209a bicb2	BIC OP		CORE 0x8a	2  R B  M B 
# 209b bicb3	BIC OP		CORE 0x8b	3  R B  R B  W B 
# 209c bicw2	BIC OP		CORE 0xaa	2  R W  M W 
# 209d bicw3	BIC OP		CORE 0xab	3  R W  R W  W W 
# 209e bicl2	BIC OP		CORE 0xca	2  R L  M L 
# 209f bicl3	BIC OP		CORE 0xcb	3  R L  R L  W L 
# 210a xorb2	XOR OP		CORE 0x8c	2  R B  M B 
# 210b xorb3	XOR OP		CORE 0x8d	3  R B  R B  W B 
# 210c xorw2	XOR OP		CORE 0xac	2  R W  M W 
# 210d xorw3	XOR OP		CORE 0xad	3  R W  R W  W W 
# 210e xorl2	XOR OP		CORE 0xcc	2  R L  M L 
# 210f xorl3	XOR OP		CORE 0xcd	3  R L  R L  W L 
# 211a ashl	ASH TN3		CORE 0x78	3  R B  R L  W L 
# 211b ashq	ASH TN3		CORE 0x79	3  R B  R Q  W Q 
# 212a rotl	HARD HARD	CORE 0x9c	3  R B  R L  W L 
# 214a polyf	HARD HARD	CORE 0x55	3  R F  R W  A B 
# 214b polyd	HARD HARD	CORE 0x75	3  R D  R W  A B 
# 214c polyg	HARD HARD	ESCD 0x55	3  R G  R W  A B 
# 214d polyh	HARD HARD	ESCD 0x75	3  R H  R W  A B 
# 220a pushr	HARD HARD	CORE 0xbb	1  R W 
# 221a popr	HARD HARD	CORE 0xba	1  R W 
# 222a movpsl	HARD HARD	CORE 0xdc	1  W L 
# 223a bispsw	HARD HARD	CORE 0xb8	1  R W 
# 223b bicpsw	HARD HARD	CORE 0xb9	1  R W 
# 224a movab	MOVA TN1	CORE 0x9e	2  A B  W L 
# 224a pushab	PUSHA TN1	CORE 0x9f	1  A B 
# 224b movaw	MOVA TN1	CORE 0x3e	2  A W  W L 
# 224b pushaw	PUSHA TN1	CORE 0x3f	1  A W 
# 224c movaf	MOVA TN1	CORE 0xde	2  A F  W L 
# 224c moval	MOVA TN1	CORE 0xde	2  A L  W L 
# 224c pushaf	PUSHA TN1	CORE 0xdf	1  A F 
# 224c pushal	PUSHA TN1	CORE 0xdf	1  A L 
# 224d pushad	PUSHA TN1	CORE 0x7f	1  A D 
# 224d pushag	PUSHA TN1	CORE 0x7f	1  A G 
# 224d pushaq	PUSHA TN1	CORE 0x7f	1  A Q 
# 224e pushah	PUSHA TN1	ESCD 0x7f	1  A H 
# 224e pushao	PUSHA TN1	ESCD 0x7f	1  A O 
# 224f movad	MOVA TN1	CORE 0x7e	2  A D  W L 
# 224f movag	MOVA TN1	CORE 0x7e	2  A G  W L 
# 224f movaq	MOVA TN1	CORE 0x7e	2  A Q  W L 
# 224g movah	MOVA TN1	ESCD 0x7e	2  A H  W L 
# 224g movao	MOVA TN1	ESCD 0x7e	2  A O  W L 
# 226a index	HARD HARD	CORE 0x0a	6  R L  R L  R L  R L  R L  W L 
# 232a insque	HARD HARD	CORE 0x0e	2  A B  A B 
# 234a remque	HARD HARD	CORE 0x0f	2  A B  W L 
# 240a insqhi	HARD HARD	NEW  0x5c	2  A B  A Q 
# 241a insqti	HARD HARD	NEW  0x5d	2  A B  A Q 
# 245a remqhi	HARD HARD	NEW  0x5e	2  A Q  W L 
# 248a remqti	HARD HARD	NEW  0x5f	2  A Q  W L 
# 251a ffc	HARD HARD	CORE 0xeb	4  R L  R B  V B  W L 
# 251b ffs	HARD HARD	CORE 0xea	4  R L  R B  V B  W L 
# 253a extv	EXTV TN1	CORE 0xee	4  R L  R B  V B  W L 
# 253b extzv	EXTZV TN1	CORE 0xef	4  R L  R B  V B  W L 
# 255a cmpv	HARD HARD	CORE 0xec	4  R L  R B  V B  R L 
# 255b cmpzv	HARD HARD	CORE 0xed	4  R L  R B  V B  R L 
# 257a insv	INSV -1		CORE 0xf0	4  R L  R L  R B  V B 
# 261a bneq	CBR JNE		CORE 0x12	1  B B 
# 261b bnequ	CBR JNE		CORE 0x12	1  B B 
# 261c beql	CBR JEQ		CORE 0x13	1  B B 
# 261d beqlu	CBR JEQ		CORE 0x13	1  B B 
# 261e bgtr	CBR JGT		CORE 0x14	1  B B 
# 261f bleq	CBR JLE		CORE 0x15	1  B B 
# 261g bgeq	CBR JGE		CORE 0x18	1  B B 
# 261h blss	CBR JLT		CORE 0x19	1  B B 
# 261i bgtru	CBR JHI		CORE 0x1a	1  B B 
# 261j blequ	CBR JLOS	CORE 0x1b	1  B B 
# 261k bvc	CBR 0		CORE 0x1c	1  B B 
# 261l bvs	CBR 0		CORE 0x1d	1  B B 
# 261m bgequ	CBR JHIS	CORE 0x1e	1  B B 
# 261n bcc	CBR JHIS	CORE 0x1e	1  B B 
# 261o blssu	CBR JLO		CORE 0x1f	1  B B 
# 261p bcs	CBR JLO		CORE 0x1f	1  B B 
# 263a brb	JBR S		CORE 0x11	1  B B 
# 263b brw	JBR S		CORE 0x31	1  B W 
# 263c jmp	JMP S		CORE 0x17	1  A B 
# 264a bbs	CBR JBS		CORE 0xe0	3  R L  V B  B B 
# 264b bbc	CBR JBC		CORE 0xe1	3  R L  V B  B B 
# 265a bbss	CBR JBSS	CORE 0xe2	3  R L  V B  B B 
# 265b bbcs	CBR JBCS	CORE 0xe3	3  R L  V B  B B 
# 265c bbsc	CBR JBSC	CORE 0xe4	3  R L  V B  B B 
# 265d bbcc	CBR JBCC	CORE 0xe5	3  R L  V B  B B 
# 266a bbssi	CBR JBSS	CORE 0xe6	3  R L  V B  B B 
# 266b bbcci	CBR JBCC	CORE 0xe7	3  R L  V B  B B 
# 267a blbs	CBR JLBS	CORE 0xe8	2  R L  B B 
# 267b blbc	CBR JLBC	CORE 0xe9	2  R L  B B 
# 268a acbb	ACB TN1		CORE 0x9d	4  R B  R B  M B  B W 
# 268b acbw	ACB TN1		CORE 0x3d	4  R W  R W  M W  B W 
# 268c acbl	ACB TN1		CORE 0xf1	4  R L  R L  M L  B W 
# 268d acbf	ACB TN1		CORE 0x4f	4  R F  R F  M F  B W 
# 268e acbd	ACB TN1		CORE 0x6f	4  R D  R D  M D  B W 
# 268f acbg	ACB TN1		ESCD 0x4f	4  R G  R G  M G  B W 
# 268g acbh	ACB TN1		ESCD 0x6f	4  R H  R H  M H  B W 
# 270a aoblss	AOBLSS S	CORE 0xf2	3  R L  M L  B B 
# 270b aobleq	AOBLEQ S	CORE 0xf3	3  R L  M L  B B 
# 271a sobgeq	SOBGEQ S	CORE 0xf4	2  M L  B B 
# 271b sobgtr	SOBGTR S	CORE 0xf5	2  M L  B B 
# 273a caseb	CASE TN1	CORE 0x8f	3  R B  R B  R B 
# 273b casew	CASE TN1	CORE 0xaf	3  R W  R W  R W 
# 273c casel	CASE TN1	CORE 0xcf	3  R L  R L  R L 
# 275a bsbb	HARD HARD	CORE 0x10	1  B B 
# 275b bsbw	HARD HARD	CORE 0x30	1  B W 
# 275c jsb	JSB S		CORE 0x16	1  A B 
# 276a rsb	JBR RSB		CORE 0x05	0 
# 280a callg	CALLS S		CORE 0xfa	2  A B  A B 
# 282a calls	CALLS S		CORE 0xfb	2  R L  A B 
# 284a ret	JBR RET		CORE 0x04	0 
# 288a movc3	MOVC3 S		CORE 0x28	3  R W  A B  A B 
# 288b movc5	HARD HARD	CORE 0x2c	5  R W  A B  R B  R W  A B 
# 290a movtc	HARD HARD	CORE 0x2e	6  R W  A B  R B  A B  R W  A B 
# 292a movtuc	HARD HARD	CORE 0x2f	6  R W  A B  R B  A B  R W  A B 
# 294a cmpc3	HARD HARD	CORE 0x29	3  R W  A B  A B 
# 294b cmpc5	HARD HARD	CORE 0x2d	5  R W  A B  R B  R W  A B 
# 297a scanc	HARD HARD	CORE 0x2a	4  R W  A B  A B  R B 
# 297b spanc	HARD HARD	CORE 0x2b	4  R W  A B  A B  R B 
# 299a locc	HARD HARD	CORE 0x3a	3  R B  R W  A B 
# 299b skpc	HARD HARD	CORE 0x3b	3  R B  R W  A B 
# 301a matchc	HARD HARD	CORE 0x39	4  R W  A B  R W  A B 
# 304a crc	HARD HARD	CORE 0x0b	4  A B  R L  R W  A B 
# 312a movp	HARD HARD	CORE 0x34	3  R W  A B  A B 
# 313a cmpp3	HARD HARD	CORE 0x35	3  R W  A B  A B 
# 313b cmpp4	HARD HARD	CORE 0x37	4  R W  A B  R W  A B 
# 314a addp4	HARD HARD	CORE 0x20	4  R W  A B  R W  A B 
# 314b addp6	HARD HARD	CORE 0x21	6  R W  A B  R W  A B  R W  A B 
# 316a subp4	HARD HARD	CORE 0x22	4  R W  A B  R W  A B 
# 316b subp6	HARD HARD	CORE 0x23	6  R W  A B  R W  A B  R W  A B 
# 318a mulp	HARD HARD	CORE 0x25	6  R W  A B  R W  A B  R W  A B 
# 319a divp	HARD HARD	CORE 0x27	6  R W  A B  R W  A B  R W  A B 
# 321a cvtlp	HARD HARD	CORE 0xf9	3  R L  R W  A B 
# 322a cvtpl	HARD HARD	CORE 0x36	3  R W  A B  W L 
# 323a cvtpt	HARD HARD	CORE 0x24	5  R W  A B  A B  R W  A B 
# 325a cvttp	HARD HARD	CORE 0x26	5  R W  A B  A B  R W  A B 
# 327a cvtps	HARD HARD	CORE 0x08	4  R W  A B  R W  A B 
# 329a cvtsp	HARD HARD	CORE 0x09	4  R W  A B  R W  A B 
# 330a ashp	HARD HARD	CORE 0xf8	6  R B  R W  A B  R B  R W  A B 
# 335a editpc	HARD HARD	CORE 0x38	4  R W  A B  A B  A B 
# 385a nop	HARD HARD	CORE 0x01	0 
# 392a escd	HARD HARD	CORE 0xfd	0 
# 392b esce	HARD HARD	CORE 0xfe	0 
# 393c escf	HARD HARD	CORE 0xff	0 
