.TH REPL 1 "3 August 1983"
.UC 4
.SH NAME
repl \- reply to a message
.SH SYNOPSIS
.B repl
[ +folder ] [ msg ] [ \-editor editor ] [ \-inplace ] [ \-annotate ]
[ \-help ] [ \-noinplace ] [ \-noannotate ]
.SH DESCRIPTION
\fIRepl\fR aids a user in producing a reply to an existing
message.
In its simplest form (with no arguments), it will set up
a message-form skeleton in reply to the current message in the
current folder, invoke the editor, and send the composed
message if so directed.
The composed message is constructed as
follows:
.nf

.in 1i
To: <Reply-To> or <From>
cc: <cc>, <To>
Subject: Re: <Subject>
In-reply-to: Your message of <Date>
.ti +\w'In-reply-to: 'u
<Message-Id>
.in .5i

.fi
where field names enclosed in angle brackets (< >) indicate the
contents of the named field from the message to which the reply
is being made.
Once the skeleton is constructed, an editor is
invoked (as in \fIcomp\fR, \fIdist\fR, and \fIforw\fR).
While in the editor,
the message being replied to is available through a link named
\*(lq@\*(rq.
In NED, this means the replied-to message may be \*(lqused\*(rq
with \*(lquse @\*(rq, or put in a window by \*(lqwindow @\*(rq.
.PP
As in \fIcomp\fR, \fIdist\fR, and \fIforw\fR, the user will be queried
before the message is sent.
If `\-annotate' is
specified, the replied-to message will be annotated with the
single line
.nf

.ti +.5i
Replied: \*(<<Date\*(>>.

.fi
The command
\*(lqcomp \-use\*(rq may be used to pick up interrupted editing, as in
\fIdist\fR and \fIforw\fR; the `\-inplace' switch annotates the message in
place, so that all folders with links to it will see the annotation.
.SH FILES
.nf
.ta \w'$HOME/\*.mh\(ruprofile    'u
$HOME/\*.mh\(ruprofile	The user profile
<mh-dir>/draft	The constructed message file
/usr/bin/send	To send the composed message
.fi
.SH "PROFILE COMPONENTS"
.nf
.ta \w'Current-Folder:    'u
Path:	To determine the user's MH directory
Editor:	To override the use of /bin/ned as the default editor
Current-Folder:	To find the default current folder
.fi
.SH DEFAULTS
.nf
`+folder' defaults to current
`msgs' defaults to cur
`\-editor' defaults to /bin/ned
`\-noannotate'
`\-noinplace'
.fi
.SH CONTEXT
If a `+folder' is specified, it will become the current
folder, and the current message will be set to the replied-to
message.
