.\" $XFree86: xc/programs/Xserver/hw/tinyx/vesa/Xvesa.man,v 1.2 2005/03/12 23:36:27 dawes Exp $
.TH Xvesa 1 __vendorversion__
.SH NAME
Xvesa \- VESA Bios Extensions tiny X server
.SH SYNOPSIS
.B Xvesa
.RI [ :display ] 
.RI [ option ...]
.SH DESCRIPTION
.B Xvesa
is a generic X server for Linux on the x86 platform.  
.B Xvesa
doesn't know about any particular hardware, and sets the video mode by
running the video BIOS in VM86 mode.
.B Xvesa
can use both standard VGA BIOS modes and any modes advertised by a
VESA BIOS if available.

.B Xvesa
runs untrusted code with full privileges, and is therefore a fairly
insecure X server.
.B The Xvesa server should only be used in trusted environments.
.SH OPTIONS
Besides the normal TinyX server's options (see TinyX(1)),
.B Xvesa
accepts the following command line switches:
.TP 8
.B \-mode \fIn\fB
specifies the VESA video mode to use.  This option overrides any
.B \-screen
options.
.TP 8
.B \-listmodes
list all supported video modes.  If
.B \-force
was specified before
.BR \-listmodes ,
lists all the modes that your BIOS claims to support, even those that
the
.B Xvesa
server won't be able to use.
.TP 8
.B \-force
disable some sanity checks and use the specified mode even if the
BIOS claims not to support it.
.TP 8
.B \-shadow
use a shadow framebuffer even if it is not strictly necessary.  This
may dramatically improve performance on some hardware.
.TP 8
.B \-nolinear
don't use a linear framebuffer even if one is available.  You don't
want to use this option.
.TP 8
.B \-swaprgb
pass RGB values in the order that works on broken BIOSes.  Use this if
the colours are wrong in PseudoColor and 16 colour modes.
.TP 8
.B \-map\-holes
use a contiguous (hole-less) memory map.  This fixes a segmentation
violation with some rare BIOSes that violate the VESA specification,
but may cause slightly higher memory usage on systems that over-commit
memory.
.TP 8
.B \-verbose
emit diagnostic messages during BIOS initialization and teardown.
.SH KEYBOARD
Multiple key presses recognized directly by
.B Xvesa
are:
.TP 8
.B Ctrl+Alt+Backspace
Immediately kill the server.
.TP 8
.B Ctrl+Alt+F1...F12
Switch to virtual console 1 through 12.

.SH SEE ALSO
X(__miscmansuffix__), Xserver(1), TinyX(1), xdm(1), xinit(1), XFree86(1).
.SH AUTHORS
The VESA driver was written by Juliusz Chroboczek.  Keith Packard added
support for standard VGA BIOS modes and is especially proud of 320x200
16 colour mode.
